/**
 * \file      dia_TracePluginSecurity.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#include "dia_TracePluginSecurity.h"

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_MANAGER__
#include "common/framework/security/dia_SecurityManager.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_TracePluginSecurity.cpp.trc.h"
#endif

//#define DIA_C_TTFIS_PAYLOAD_START_POS     3

tU8
dia_TracePluginSecurity::mReqLevel = 0;

//-----------------------------------------------------------------------------

dia_TracePluginSecurity::dia_TracePluginSecurity(tVoid) :
      dia_TracePlugin(ID_DIA_SECURITY, PAR_DIA_MCNET),
      mReqCmd(0x00)
{}

//-----------------------------------------------------------------------------

dia_TracePluginSecurity::~dia_TracePluginSecurity(tVoid)
{}

//-----------------------------------------------------------------------------

#define DIA_C_SECURITY_CMD_KNOCKKNOCK     ((tU16) 0xF082)
#define DIA_C_SECURITY_CMD_UNLOCK         ((tU16) 0xF084)

tDiaResult
dia_TracePluginSecurity::onTraceMessage ( tU8* pMessage )
{
   dia_tclFnctTrace oTrace("dia_tclTracePluginSecurity::onTraceMessage");

   // number of following bytes
   tU16 length = pMessage[0];
//   tU8* pPayLoad = &pMessage[DIA_C_TTFIS_PAYLOAD_START_POS];

   DIA_TR_ERR("--- Got a SECURITY Message");

   for ( tU16 i=0; i<=length; i++ )
   {
      DIA_TR_INF("byte[%02d] = 0x%02x",i,pMessage[i]);
   }

   mReqCmd = tU16(pMessage[3] << 8);
   mReqCmd = tU16(mReqCmd | pMessage[4]);

   switch ( mReqCmd )
   {
   case DIA_C_SECURITY_CMD_KNOCKKNOCK:
      {
         mReqLevel = pMessage[5];

         const tU16 bufferSize = 3;
         tU8 udsBuffer[bufferSize] = { 0x02, 0x27, 0x61 };

         switch ( mReqLevel )
         {
         case 0x02:
         case 0x03:
            {
               // Create an object containing the UDS msg. It is deleted by dia_tclDiagSessionUds
               dia_MessageBufferUDS* pMsgBuff = OSAL_NEW dia_MessageBufferUDS(udsBuffer,bufferSize,vSendSeedResponseToTrace);
               dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(pMsgBuff));
               pMsgBuff = 0; //lint !e438 !e423 Warning: Creation of memory leak in assignment to 'pMsgBuff'. --> lifetime is controlled by FSM of diagnostic engine
            } //lint !e438 Warning: last value assigned to variable 'pMsgBuff' not used
            break;

         case 0x00:
            {
               DIA_TR_INF("######################################################");
               DIA_TR_INF("#");
               DIA_TR_INF("# Lock Device");
               DIA_TR_INF("#");
               DIA_TR_INF("######################################################");

               (tVoid) getInstanceOfSecurityManager()->lock();
            }
            break;

         default:
            break;
         }
      }
      break;

   case DIA_C_SECURITY_CMD_UNLOCK:
      {
         const tU16 bufferSize = 11;
         tU8 udsBuffer[bufferSize] = { 0x0A, 0x27, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
         for ( tU16 j=3,k=5; j<bufferSize; j++,k++ ) udsBuffer[j] = pMessage[k];
         dia_MessageBufferUDS* pMsgBuff = OSAL_NEW dia_MessageBufferUDS(udsBuffer,bufferSize,vSendKeyResponseToTrace);
         dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(pMsgBuff));
         pMsgBuff = 0; //lint !e438 !e423 Warning: Creation of memory leak in assignment to 'pMsgBuff'. --> lifetime is controlled by FSM of diagnostic engine
      } //lint !e438 Warning: last value assigned to variable 'pMsgBuff' not used
      break;

   default:
      break;
   }

   return DIA_SUCCESS; //lint !e438 Warning: last value assigned to variable 'poMsgBuffer' not used
}

//-----------------------------------------------------------------------------

void
dia_TracePluginSecurity::vSendSeedResponseToTrace ( const tU8 msgBuffer[], tU16 length, tCookieType /*cookie*/ )
{
   dia_tclFnctTrace oTrace("dia_TracePluginSecurity::vSendSeedResponseToTrace");

   for ( tU16 i=0; i<length; i++ )
   {
      DIA_TR_INF("byte[%02d] = 0x%02x",i,msgBuffer[i]);
   }

   if ( (msgBuffer[0] == 0x67) && (msgBuffer[1] == 0x61) )
   {
      const tU16 responseLength = 15;
      tU8 responseBuffer[responseLength] = { 0xF0, 0x83, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

      for ( tU16 k=6, j=7; k<length; k++,j++ )
      {
         responseBuffer[j] = msgBuffer[k];
      }

      // send response msg to TTFis
      //ETG_TRACE_FATAL_CLS((TR_CLASS_DIAGNOSTICS_SECURITY, "Security msg TX via TTFis: Length: %d Data: %02x", responseLength, ETG_LIST(responseLength, ETG_T8, responseBuffer)));
   }

   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk()); //lint !e429: custodial pointer is freed by after engine has processed the message
}

//-----------------------------------------------------------------------------

void
dia_TracePluginSecurity::vSendKeyResponseToTrace ( const tU8 msgBuffer[], tU16 length, tCookieType /*cookie*/ )
{
   dia_tclFnctTrace oTrace("dia_TracePluginSecurity::vSendKeyResponseToTrace");

   for ( tU16 i=0; i<length; i++ )
   {
      DIA_TR_INF("byte[%02d] = 0x%02x",i,msgBuffer[i]);
   }

   if ( (msgBuffer[0] == 0x67) && (msgBuffer[1] == 0x62) )
   {
      const tU16 responseLength = 3;
      tU8 responseBuffer[responseLength] = { 0xF0, 0x85, 0x00 };
      responseBuffer[2] = mReqLevel;
      mReqLevel = 0x00;

      (tVoid) getInstanceOfSecurityManager()->unlock();

      DIA_TR_INF("######################################################");
      DIA_TR_INF("#");
      DIA_TR_INF("# Unlock Device");
      DIA_TR_INF("#");
      DIA_TR_INF("######################################################");

      // send response msg to TTFis
      //ETG_TRACE_FATAL_CLS((TR_CLASS_DIAGNOSTICS_SECURITY, "Security msg TX via TTFis: Length: %d Data: %02x", responseLength, ETG_LIST(responseLength, ETG_T8, responseBuffer)));
   }

   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk()); //lint !e429: custodial pointer is freed by after engine has processed the message
}

