/**
 * \file      dia_TraceMonitor.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_OSAL_DRIVER_TRACE__
#include "common/framework/platform/osal/dia_OSALDriverTrace.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_TraceMonitor.cpp.trc.h"
#endif

#include "dia_TraceMonitor.h"
#include "dia_TracePlugin.h"

#define DIA_C_TTFIS_TRACE_CMD_POS         1
#define DIA_C_TTFIS_TRACE_SUBCMD_POS      2
//#define DIA_C_TTFIS_PAYLOAD_START_POS     3

using namespace std;

//-----------------------------------------------------------------------------

dia_TraceMonitor::dia_TraceMonitor ( void )
   : mpDriverTrace(0),
     mpDefaultPlugin(0)
{
   (tVoid) setSysAdapterListener<dia_ITraceListener>(this);
}

//-----------------------------------------------------------------------------

dia_TraceMonitor::dia_TraceMonitor ( dia_IDriver* traceDriver )
   : mpDriverTrace(traceDriver),
     mpDefaultPlugin(0)
{
   (tVoid) setSysAdapterListener<dia_ITraceListener>(this);
}

//-----------------------------------------------------------------------------

dia_TraceMonitor::~dia_TraceMonitor(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITraceListener>(this);
      mpDriverTrace   = 0;
      mpDefaultPlugin = 0;
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioLinearMode::~dia_IOCtrlAudioLinearMode !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_TraceMonitor::addTracePlugin ( dia_TracePlugin* pPlugin, tBool bDefaultPlugin )
{
   dia_tclFnctTrace trc("dia_TraceMonitor::bAddTracePlugin()");

   if ( !pPlugin ) return DIA_FAILED;

   tDiaResult retCode = DIA_FAILED;
   map<tU8,tU8>::iterator formatIter = mPluginFormats.find(pPlugin->getID());
   if (formatIter == mPluginFormats.end()) {
      mPluginFormats[pPlugin->getID()] = pPlugin->getFormat();
   }

   tU32 key = (((tU32) pPlugin->getID()) << 24) | (((tU32) pPlugin->getParameter()) << 16);
   map<tU32,dia_TracePlugin*>::iterator iter = mPluginRep.find(key);
   if (iter == mPluginRep.end())
   {
      mPluginRep[key] = pPlugin;
      if ( bDefaultPlugin ) mpDefaultPlugin = pPlugin;
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_TraceMonitor::removeTracePlugin ( const dia_TracePlugin* pPlugin )
{
   dia_tclFnctTrace trc("dia_TraceMonitor::removeTracePlugin()");

   if ( !pPlugin ) return DIA_SUCCESS;

   tU32 key = (((tU32) pPlugin->getID()) << 24) | (((tU32) pPlugin->getParameter()) << 16);
   map<tU32,dia_TracePlugin*>::iterator iter = mPluginRep.find(key);
   if ( (iter != mPluginRep.end()) && (iter->second == pPlugin) )
   {
      mPluginRep.erase(key);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tVoid
dia_TraceMonitor::vOnTraceMessage ( tU8* pMessage )
{
   dia_tclFnctTrace trc("dia_TraceMonitor::vOnTraceMessage()");

   if ( !pMessage ) return;

   // we need information about the message format in order to extract a valid key
   map<tU8, tU8>::iterator formatIter = mPluginFormats.find(pMessage[DIA_C_TTFIS_TRACE_CMD_POS]);
   if ( formatIter == mPluginFormats.end() ) return; // no format was specified for the given ID

   // to compose a key we need to know if the plugin uses a subcommand
   tU8 param = (formatIter->second) ? pMessage[DIA_C_TTFIS_TRACE_SUBCMD_POS] : PAR_DIA_NOT_AVAILABLE;

   tU32 key = (((tU32) pMessage[DIA_C_TTFIS_TRACE_CMD_POS]) << 24) | (((tU32) param) << 16);

   DIA_TR_INF("dia_tclTraceMonitor::bOnTraceMessage pMessage[DIA_C_TTFIS_TRACE_CMD_POS] 0x%02x", (tU32) pMessage[DIA_C_TTFIS_TRACE_CMD_POS]);
   DIA_TR_INF("dia_tclTraceMonitor::bOnTraceMessage param 0x%02x", (tU32) param);
   DIA_TR_INF("dia_tclTraceMonitor::bOnTraceMessage key   0x%08x", (tU32) key);

   map<tU32,dia_TracePlugin*>::iterator iter = mPluginRep.find(key);

   if (iter != mPluginRep.end())
   {
      (tVoid) iter->second->onTraceMessage(pMessage);
   }
   else
   {
      if ( mpDefaultPlugin ) (tVoid) mpDefaultPlugin->onTraceMessage(pMessage);
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_TraceMonitor::open ( tVoid ) const
{
   dia_tclFnctTrace trc("dia_TraceMonitor::open()");
   return ( mpDriverTrace ) ? mpDriverTrace->open() : DIA_E_OPEN_FAILED_TRACE;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_TraceMonitor::close ( tVoid ) const
{
   return ( mpDriverTrace ) ? mpDriverTrace->close() : DIA_FAILED;
}

//-----------------------------------------------------------------------------


