/*
 * dia_TraceCmdTestConditionCall.cpp
 *
 *  Created on: Dec 19, 2013
 *      Author: kaa1hi
 */

// Example: Call Memory_Reset = DIA_REQ CMD 00 09 0A

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#ifndef DIA_TRACECMDTESTCONDITIONCALL_H_
#include "common/framework/trace/dia_TraceCmdTestConditionCall.h"
#endif

void
dia_TraceCmdTestConditionCall::execute ( const tU8* pMessage ) const
{
   dia::ScopeTrace oTrace("dia_TraceCmdTestConditionCall::execute");

   const tU8 maxNameLength = 100;
   char condName[maxNameLength];
   ::memset(condName,0,maxNameLength);

   // extract condition name from message
   int count = 0;
   for ( int i=5; i < pMessage[0]; i++ )
   {
      condName[count++] = pMessage[i];
   }
   condName[count] = 0;

   if ( ::strlen(condName) == 0 )
   {
      DIA_TR_ERR("dia_TraceCmdTestConditionCall::execute: Failed to extract test condition name");
      return;
   }

   dia::UID testcondition = dia_getHashCodeFromString(condName);

   DIA_TR_INF("dia_TraceCmdTestConditionCall::execute - UID = 0x%08x, Name = '%s'.", testcondition, condName);

   dia_TestController* pTestController = getInstanceOfTestController();
   if ( pTestController )
   {
      pTestController->runTests(testcondition);
   }
}
