/*
 * \file        dia_TraceCmdPrintAllServiceHandlers.cpp
 *
 * \brief       Internal command for getting information about registered service handlers
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Sep 22, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */

// DIA_REQ CMD 0 E 61
// DIA_PRINT_ALL_SERVICE_HANDLERS 60


#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef DIA_TRACECMDPRINTALLSERVICEHANDLERS_H_
#include <common/framework/trace/dia_TraceCmdPrintAllServiceHandlers.h>
#endif

#define DIA_MESSAGE_LEN (5)

// p = pMessage
//               p0 p1 p2 p3 p4 p5
//                        |   |  |
// (2 bytes) cmdID      --|-+-|  |
// (1 byte)  sessionID  ---------|

void dia_TraceCmdPrintAllServiceHandlers::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdPrintAllServiceHandlers::execute");

   if (DIA_MESSAGE_LEN != pMessage[0])
   {
      DIA_TR_ERR("dia_TraceCmdPrintAllServiceHandlers::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      DIA_TR_ERR("dia_TraceCmdPrintAllServiceHandlers::execute Expected message length is 5.");
      DIA_TR_INF("dia_TraceCmdPrintAllServiceHandlers::execute Usage #1: DIA_PRINT_ALL_SERVICE_HANDLERS 60");
      DIA_TR_INF("dia_TraceCmdPrintAllServiceHandlers::execute Usage #2: DIA_REQ CMD 0 E 61");
      return;
   }

   std::map<tU32, std::string> engineServerMap;

   engineServerMap[DIA_UID_ENGINE_UNKNOWN]                = std::string(DIA_NAME_ENGINE_UNKNOWN);
   engineServerMap[DIA_UID_ENGINE_CUSTOMER_UDS]           = std::string(DIA_NAME_ENGINE_CUSTOMER_UDS);
   engineServerMap[DIA_UID_ENGINE_PRODUCTION_UDS]         = std::string(DIA_NAME_ENGINE_PRODUCTION_UDS);
   engineServerMap[DIA_UID_ENGINE_PRODUCTION_UDS_RUN_IN]  = std::string(DIA_NAME_ENGINE_PRODUCTION_UDS_RUN_IN);
   engineServerMap[DIA_UID_ENGINE_PRODUCTION_UDS_BURN_IN] = std::string(DIA_NAME_ENGINE_PRODUCTION_UDS_BURN_IN);

   DIA_TR_INF("Number of Engine Server: %zu", engineServerMap.size());

   std::map<tU32,std::string>::iterator iter = engineServerMap.begin();

   for (; iter!=engineServerMap.end(); ++iter)
   {
      DIA_TR_INF("###########################################################################################");
      DIA_TR_INF("####################### ENGINE SERVER %s #######################", iter->second.c_str());
      DIA_TR_INF("###########################################################################################");

      dia_EngineServer* pEngine = 0;
      tDiaResult retValQueryEngine = getInstanceOfEngineManager()->queryEngineServer(iter->first,&pEngine);

      if ((DIA_SUCCESS==retValQueryEngine) && (NULL!=pEngine))
      {
         dia_Session* pActiveSession = NULL;
         const tU8 sessionID = pMessage[5];
         tDiaResult retValQuerySession = pEngine->getSessionController()->querySession( &pActiveSession, sessionID );

         DIA_TR_INF("*************** SESSION ID = 0x%02X ***************", sessionID);

         if ((DIA_SUCCESS==retValQuerySession) && (NULL!=pActiveSession))
         {
            dia_ServiceDispatcher* pDispatcher = pActiveSession->getDispatcher();

            if (NULL!=pDispatcher)
            {
               pDispatcher->printAllServiceHandlers();
            }
            else
            {
               DIA_TR_INF("dia_TraceCmdPrintAllServiceHandlers::execute pDispatcher=0x%p", pDispatcher);
            }
         }
         else
         {
            if (DIA_FAILED==retValQuerySession)
            {
               DIA_TR_INF("dia_TraceCmdPrintAllServiceHandlers::execute ERROR sessionID=0x%X NOT FOUND!", sessionID);

               tU32 i = 0;
               const std::vector<tU8> sessions = pEngine->getServerConfiguration().getSessions();

               DIA_TR_INF("***********************************");
               DIA_TR_INF("*** BEGIN: AVAILABLE SESSION ID ***");
               DIA_TR_INF("***********************************");
               for (std::vector<tU8>::const_iterator it = sessions.begin() ; it != sessions.end(); ++it, ++i)
               {
                  DIA_TR_INF("[%03d] session_id = 0x%02X", i, (*it) );
               }
               DIA_TR_INF("***********************************");
               DIA_TR_INF("**** END: AVAILABLE SESSION ID ****");
               DIA_TR_INF("***********************************");
            }
            DIA_TR_INF("dia_TraceCmdPrintAllServiceHandlers::execute retValQuerySession=0x%X pActiveSession=0x%p", retValQuerySession, pActiveSession);
         }
      }
      else
      {
         DIA_TR_INF("dia_TraceCmdPrintAllServiceHandlers::execute retVal=0x%X pEngine=0x%p", retValQueryEngine, pEngine);
      }
   }
}
