/*
 * dia_TraceCmdFactory.h
 *
 *  Created on: Dec 19, 2013
 *      Author: kaa1hi
 */

#ifndef DIA_TRACECMDFACTORY_H_
#define DIA_TRACECMDFACTORY_H_

#ifndef __INCLUDED_DIA_TRACE_CMD__
#include "common/framework/trace/dia_TraceCmd.h"
#endif

#ifndef DIA_TRACECMDCODEPLUGGET_H_
#include "common/framework/trace/dia_TraceCmdCodeplugGet.h"
#endif

#ifndef DIA_TRACECMDTOGGLECRC_H_
#include "common/framework/trace/dia_TraceCmdToggleCrc.h"
#endif

#ifndef DIA_TRACECMDPROPERTYBAGGET_H_
#include "common/framework/trace/dia_TraceCmdPropertyBagGet.h"
#endif

#ifndef DIA_TRACECMDPROPERTYBAGSET_H_
#include "common/framework/trace/dia_TraceCmdPropertyBagSet.h"
#endif

#ifndef DIA_TRACECMDTESTCONDITIONCALL_H_
#include "common/framework/trace/dia_TraceCmdTestConditionCall.h"
#endif

#ifndef DIA_TRACECMDCARCONFIGSET_H_
#include "common/framework/trace/dia_TraceCmdCarConfigSet.h"
#endif

#ifndef DIA_TRACECMDREGREAD_H_
#include "common/framework/trace/dia_TraceCmdRegRead.h"
#endif

#ifndef DIA_TRACECMDREGWRITE_H_
#include "common/framework/trace/dia_TraceCmdRegWrite.h"
#endif

#ifndef DIA_TRACECMDPRINTREGISTEREDLISTENERS_H_
#include "common/framework/trace/dia_TraceCmdPrintRegisteredListeners.h"
#endif

#ifndef DIA_TRACECMDRUNCONFIGUPDATE_H_
#include "common/framework/trace/dia_TraceCmdRunConfigUpdate.h"
#endif

#ifndef DIA_TRACECMDPRINTEVENTLIST_H_
#include "common/framework/trace/dia_TraceCmdPrintEventList.h"
#endif

#ifndef DIA_TRACECMDTESTERDISAPPEAR_H_
#include "common/framework/trace/dia_TraceCmdTesterDisappear.h"
#endif

#ifndef DIA_TRACECMDPRINTALLSERVICEHANDLERS_H_
#include "common/framework/trace/dia_TraceCmdPrintAllServiceHandlers.h"
#endif

#ifndef DIA_TRACECMDCHANGEMAXSIZEEVENTLIST_H_
#include "common/framework/trace/dia_TraceCmdChangeMaxSizeEventList.h"
#endif

#ifndef DIA_TRACECMDEXECUTERUNIN_H_
#include "common/framework/trace/cmd/dia_TraceCmdExecuteRunIn.h"
#endif

#ifndef DIA_TRACECMDTERMINATERUNIN_H_
#include "common/framework/trace/cmd/dia_TraceCmdTerminateRunIn.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_CMD_INJECTCCAMESSAGE__
#include "common/framework/trace/cmd/dia_TraceCmdInjectCCAMessage.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_CMD_EXECUTE_PDX_FLASHING__
#include <common/framework/trace/cmd/dia_TraceCmdExecutePDXFlashing.h>
#endif

class dia_TraceCmdFactory
{
private:
	static dia_TraceCmdFactory* s_pTraceCommandFactoryProject; // pointer to the project specific Trace Command Factory

public:
   dia_TraceCmdFactory() {}
   virtual ~dia_TraceCmdFactory() {}

   static void registerProjectTraceCommandFactory(dia_TraceCmdFactory* traceCommandFactoryProject)
   {
	   DIA_TR_INF("dia_TraceCmdFactory::registerProjectTraceCommandFactory...");

	   if (traceCommandFactoryProject)
	   {
		   s_pTraceCommandFactoryProject = traceCommandFactoryProject;
	   }
   }

   static void unregisterProjectTraceCommandFactory(dia_TraceCmdFactory* traceCommandFactoryProject)
   {
	   DIA_TR_INF("dia_TraceCmdFactory::unregisterProjectTraceCommandFactory...");

	   if (traceCommandFactoryProject == s_pTraceCommandFactoryProject)
	   {
		   s_pTraceCommandFactoryProject = NULL;
	   }
   }

   virtual dia_TraceCmd* createTraceCmdProject(tU16 /*traceCmdId*/) {return NULL;} // to be overwritten in project specific implementation of dia_TraceCmdFactory

   enum dia_enTraceCmdID
   {
      // identify the pin settings of a connected code plug (Nissan)
      Unknown                 = 0x0000,
      ToggleCrc               = 0x0006,
      PropertyBagGet          = 0x0007,
      PropertyBagSet          = 0x0008,
      TestConditionCall       = 0x0009,
      PrintSrvRegLstrs        = 0x000A,   /* print list of service registration listeners */
      PrintEventList          = 0x000B,
      ChangeMaxSizeEventList  = 0x000C,
      TesterDisappear         = 0x000D,
      PrintAllServiceHandlers = 0x000E,
      InjectCCAMessage        = 0x000F,
      /* ... */
      configUpdate            = 0x0013,
      StartRunIn              = 0x0014,
      TerminateRunIn          = 0x0015,
      StartPDXFlashing        = 0x0016,
      /* Commands that must be mapped to a project specific commands*/
      ProjectCmd01            = 0x0020,
      ProjectCmd02            = 0x0021,
      ProjectCmd03            = 0x0022,
      ProjectCmd04            = 0x0023,
      ProjectCmd05            = 0x0024
   };

   static dia_TraceCmd* createTraceCmd(dia_enTraceCmdID traceCmdId)
   {
      switch (traceCmdId)
      {
         case ToggleCrc:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdToggleCrc");
            return new dia_TraceCmdToggleCrc();
         case PropertyBagGet:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdPropertyBagGet");
            return new dia_TraceCmdPropertyBagGet();
         case PropertyBagSet:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdPropertyBagSet");
            return new dia_TraceCmdPropertyBagSet();
         case TestConditionCall:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdTestConditionCall");
            return new dia_TraceCmdTestConditionCall();
         case PrintSrvRegLstrs:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdPrintRegisteredListeners");
            return new dia_TraceCmdPrintRegisteredListeners();
         case PrintEventList:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdPrintEventList");
            return new dia_TraceCmdPrintEventList();
         case ChangeMaxSizeEventList:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdChangeMaxSizeEventList");
            return new dia_TraceCmdChangeMaxSizeEventList();
         case TesterDisappear:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdTesterDisappear");
            return new dia_TraceCmdTesterDisappear();
         case PrintAllServiceHandlers:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdPrintAllServiceHandlers");
            return new dia_TraceCmdPrintAllServiceHandlers();
         case configUpdate:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdRunConfigUpdate");
            return new dia_TraceCmdRunConfigUpdate();
         case StartRunIn:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdExecuteRunIn");
            return new dia_TraceCmdExecuteRunIn();
         case TerminateRunIn:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdTerminateRunIn");
            return new dia_TraceCmdTerminateRunIn();
         case InjectCCAMessage:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia_TraceCmdInjectCCAMessage");
            return new dia_TraceCmdInjectCCAMessage();
         case StartPDXFlashing:
            DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of dia::TraceCmdExecutePDXFlashing");
            return new dia::TraceCmdExecutePDXFlashing();

         default:
        	// Check if a project specific TraceCmd is requested
			if (traceCmdId>= ProjectCmd01 && traceCmdId<=ProjectCmd05)
			{
				DIA_TR_INF("dia_TraceCmdFactory::createTraceCmd Creating instance of project specific TraceCmd");
				if (s_pTraceCommandFactoryProject)
				{
					return s_pTraceCommandFactoryProject->createTraceCmdProject(static_cast<tU16>(traceCmdId));
				}
			}
            break;
      }
      DIA_TR_ERR("dia_TraceCmdFactory::createTraceCmd Not supported cmd! traceCmdId=0x%04x", static_cast<tU16>(traceCmdId));
      return NULL;
   }
};

#endif /* DIA_TRACECMDFACTORY_H_ */
