/*
 * \file        dia_TraceCmdChangeMaxSizeEventList.cpp
 *
 * \brief       {insert brief description here}
 * 
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Mar 13, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */

// DIA_REQ CMD 0 C 01 00

#ifndef __INCLUDED_DIA_SERVICE_TRACKER__
#include "common/framework/platform/cca/dia_ServiceTracker.h"
#endif

#ifndef DIA_TRACECMDCHANGEMAXSIZEEVENTLIST_H_
#include "common/framework/trace/dia_TraceCmdChangeMaxSizeEventList.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_LOGGER__
#include "common/framework/application/dia_EventLogger.h"
#endif

#define DIA_EXPECTED_MESSAGE_LENGTH (6)
#define DIA_NEW_SIZE_OF_LIST_INDX   (5)

   // p = pMessage
   //              p0 p1 p2 p3 p4  p5 p6
   //                       |   |  |   |
   // (2 bytes) cmdID     --|-+-|  |   |
   //                              |   |
   // (2 bytes) newListSize      --|-+-|

void dia_TraceCmdChangeMaxSizeEventList::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdChangeMaxSizeEventList::execute");

   if (DIA_EXPECTED_MESSAGE_LENGTH!=pMessage[0])
   {
      DIA_TR_ERR("######## Incorrect message length. Act len=%d, Exp len=%d ########", pMessage[0], DIA_EXPECTED_MESSAGE_LENGTH);
      return;
   }

   tU32 newSizeOfList = ((pMessage[DIA_NEW_SIZE_OF_LIST_INDX]<<8) + pMessage[DIA_NEW_SIZE_OF_LIST_INDX + 1]);

   DIA_TR_INF("dia_TraceCmdChangeMaxSizeEventList::execute New size of event list = %d (dec)", newSizeOfList);

   dia_EventLogger* pEventLogger = getInstanceOfEventLogger();
   if (NULL!=pEventLogger)
   {
      pEventLogger->SetMaxSizeOfList(newSizeOfList);
   }
   else
   {
      DIA_TR_ERR("dia_TraceCmdChangeMaxSizeEventList::execute NULL ptr");
   }
}



