/*
 * dia_TraceCmdInjectCCAMessage.cpp
 *
 *  Created on: 14.12.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_TRACE_CMD_INJECTCCAMESSAGE__
#include <common/framework/trace/cmd/dia_TraceCmdInjectCCAMessage.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGCLIENT__
#include "common/interfaces/dia_IDiagClient.h"
#endif

#define DIA_MESSAGE_LEN (7)

// p = pMessage
//               p0 p1 p2 p3 p4 p5 p6 p7 p8
//                        |   | |   |  |  |
// (2 bytes) cmdID      --|-+-| |   |  |  |
// (2 bytes) CCAFuncID  --------|-+-|  |  |
// (1 byte ) CCAOpCode  ---------------|  |
// (0...n bytes) Payload -----------------|...


void dia_TraceCmdInjectCCAMessage::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdInjectCCAMessage::execute");

   if (pMessage[0] < DIA_MESSAGE_LEN)
   {
      DIA_TR_ERR("dia_TraceCmdInjectCCAMessage::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      DIA_TR_ERR("dia_TraceCmdInjectCCAMessage::execute Expected message length is at least 7.");
      DIA_TR_INF("dia_TraceCmdInjectCCAMessage::execute Usage #1: DIA_INJECT_CCA_MESSAGE MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM OPCODE_GET 0");
      DIA_TR_INF("dia_TraceCmdInjectCCAMessage::execute Usage #2: DIA_REQ CMD 0 F 0061 1 0");
      return;
   }

   dia_IDiagClient* pInterface = NULL;
   if ((DIA_SUCCESS == queryInterface<dia_IDiagClient>(&pInterface)) && pInterface )
   {
      tU16 u16FuncId = pMessage[5];
      u16FuncId = static_cast<tU16>((u16FuncId << 8) | pMessage[6]);
      tU8 u8OpCode = pMessage[7];

      DIA_TR_INF("dia_TraceCmdInjectCCAMessage::execute => Going to call dia_IDiagClient with FuncId=0x%x and OpCode=0x%x",
            u16FuncId, u8OpCode);

      std::vector<tU8> payload;
      for (int i = 0; i < (pMessage[0] - DIA_MESSAGE_LEN); i++)
      {
         payload.push_back(pMessage[i+1+DIA_MESSAGE_LEN]);
      }

      pInterface->sendMessage(u16FuncId, u8OpCode, payload);
   }

}

