/*
 * dia_TraceCmdExecutePDXFlashing.cpp
 *
 *  Created on: 05.12.2016
 *      Author: gib2hi
 */

/*
 * dia_TraceCmdExecuteRunIn.cpp
 *
 *  Created on: 08.01.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_CMD_EXECUTE_PDX_FLASHING__
#include <common/framework/trace/cmd/dia_TraceCmdExecutePDXFlashing.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__
#include "common/framework/factory/dia_FactoryPluginPDXFlashing.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_FLASH_PDX__
#include <common/framework/engine/dia_EngineFlash.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__
#include <common/framework/engine/dia_EngineFlashConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include <common/framework/test/dia_TestController.h>
#endif


#define DIA_MESSAGE_LEN (4)

namespace dia {

// p = pMessage
//               p0 p1 p2 p3 p4 p5
//                        |   |  |
// (2 bytes) cmdID      --|-+-|  |
// (1 byte)  sessionID  ---------|

void
TraceCmdExecutePDXFlashing::execute ( const tU8* pMessage ) const
{
   ScopeTrace oTrace("dia::TraceCmdExecutePDXFlashing::execute");

   if (DIA_MESSAGE_LEN != pMessage[0])
   {
      DIA_TR_ERR("dia::TraceCmdExecutePDXFlashing::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      DIA_TR_ERR("dia::TraceCmdExecutePDXFlashing::execute Expected message length is 4.");
      DIA_TR_INF("dia::TraceCmdExecutePDXFlashing::execute Usage #2: DIA_REQ CMD 0 16");
      return;
   }

   DIA_TR_ERR("############################################################");
   DIA_TR_ERR("#");
   DIA_TR_ERR("# START PDX-FLASHING");
   DIA_TR_ERR("#");
   DIA_TR_ERR("############################################################");

   (void) getInstanceOfTestController()->runTests(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_PDX_FLASHING);
}

}



