/**
 * \file      dia_TestService.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 26, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_TEST_SERVICE__
#define __INCLUDED_DIA_TEST_SERVICE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_TEST__
#include "common/framework/test/dia_Test.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

//-----------------------------------------------------------------------------

class dia_TestService
   : public dia_Test,
     public dia_ServiceHandlerUDS
{
public:
   //! class constructor
   dia_TestService ( tCString name );
   //! class constructor
   dia_TestService ( tCString name, tU8 sid, tU16 did );
   //! class destructor
   virtual ~dia_TestService ( void );

   virtual void  setEmbeddedMode ( tBool mode ) { mEmbeddedMode = mode; }
   virtual tBool getEmbeddedMode  ( void ) const { return mEmbeddedMode; }

   //! run the test (method has to be implemented by subclasses
   virtual tDiaResult run ( dia::UID condition );

   virtual void vOnTimeout ( void );
   //! response callback method used the post the confirmation event to the UDS state machine
   static  tVoid vTestServiceTxOk ( const tU8*, tU16, tCookieType );

protected:
   //! deprecated default class constructor
   dia_TestService ( void );

   //! overloaded base class method
   virtual void testTerminate ( void );

   virtual bool checkPreConditions ( void ) const;

protected:
   //! flag to indicate if the test is running as an embedded test function or as a separate service
   //! if true no new message will be sent to engine, if false new message will be sent to engine.
   tBool mEmbeddedMode;
   //!
   static std::map<tU16,dia_TestService*> mObjRep;
};

#endif /*__INCLUDED_DIA_TEST_SERVICE__*/
