/*
 * dia_TestPDXFlashing.cpp
 *
 *  Created on: 05.12.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_TEST_PDX_FLASHING__
#include <common/framework/test/dia_TestPDXFlashing.h>
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include <common/framework/test/dia_TestController.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include <common/framework/config/dia_ConfigManager.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__
#include <common/framework/factory/dia_FactoryPluginPDXFlashing.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_FLASH_PDX__
#include <common/framework/engine/dia_EngineFlash.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION_FLASH_PDX__
#include <common/framework/engine/dia_EngineFlashConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include <common/depricated/dia_main.h>
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__
#include <common/framework/factory/dia_FactoryPluginPDXFlashing.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

namespace dia {

//-----------------------------------------------------------------------------

TestPDXFlashing::TestPDXFlashing ( void )
   : dia_TestService("dia::TestPDXFlashing", DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_PDX_FLASHING)
{
   ScopeTrace oTrace("dia::TestPDXFlashing::TestPDXFlashing()");
}

//-----------------------------------------------------------------------------

TestPDXFlashing::~TestPDXFlashing ( void )
{
	_BP_TRY_BEGIN
	{
		(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlDisplayTestPatternAIVI::~dia_IOCtrlDisplayTestPatternAIVI !!!");
		DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
TestPDXFlashing::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   ScopeTrace oTrace("dia::TestPDXFlashing::vProcessRequest()");
   dia_IDisplayPatternAIVI* pInterface = 0;
   FactoryPluginPDXFlashing* pdxFlashingFactory = getInstanceOfFactoryPluginPDXFlashing();
   if ( pdxFlashingFactory )
   {
      const std::list<std::string>& pdxFiles = pdxFlashingFactory->getPDXContainers();

      if ( pdxFiles.size() == 0 )
      {
         DIA_TR_INF("TestPDXFlashing: NO PDX FILES FOUND FOR FLASHING !!!");
      }
      else
      {
         DIA_TR_ERR("############################################################");
         DIA_TR_ERR("#");
         DIA_TR_ERR("# START PDX FLASHING");
         DIA_TR_ERR("#");
         DIA_TR_ERR("############################################################");

         // run-in was not deactivated, so we have to start the run-in
         tDiaResult retCode = pdxFlashingFactory->setup();
         if ( retCode == DIA_SUCCESS )
         {
        	 DIA_TR_INF("### PDX-FLASH-ENGINE STARTED SUCCESSFULLY ###");
        	 if ( querySysAdapterInterface<dia_IDisplayPatternAIVI>(&pInterface) == DIA_SUCCESS )
        	 {
        		 if ( pInterface )
        		 {
        			 DIA_TR_INF("### setHMIBlockStatus1()###");
        			 (void) setSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
        			 pInterface->setHMIBlockStatus();
        		 }
        	 }
         }
         else if ( retCode == DIA_E_ALREADY_STARTED )
         {
        	 DIA_TR_ERR("### PDX-FLASH-ENGINE ALREADY STARTED. TRIGGER START OF FLASHING !!");
        	 pdxFlashingFactory->startFlashing();
         }
         else
         {
            DIA_TR_ERR("### FAILED TO START PDX-FLASH-ENGINE (ERRCODE = 0x%08x", retCode);
         }
      }
   } //if ( pdxFlashingFactory )

   testTerminate();
}

}

