/**
 * \file      dia_TestController.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 26, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#define __INCLUDED_DIA_TEST_CONTROLLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_TEST__
#include <common/framework/test/dia_defsTest.h>
#endif

// forward declarations
class dia_Test;

class dia_TestController
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_TestController);

public:
   //! add a new test to the test controller object
   virtual tDiaResult addTest ( dia_Test* testObj );
   //! remove a test
   virtual tDiaResult removeTest ( dia_UID id );
   //! return number of registered tests
   tU16 numberOfTests ( void ) const;
   //! run the specified test
   virtual tDiaResult runTest ( dia_UID testID );
   //! run all tests available for the specified test conditions (used as trigger)
   virtual tDiaResult runTests ( dia::UID condition );

   //! retrieve pointer to the specified test object
   virtual tDiaResult queryTest ( dia_UID testID, dia_Test** ppTest );
   //! retrieve pointers to all test objects associated with the given test condition
   virtual tDiaResult queryTests ( dia::UID condition, std::list<dia_Test*>& testList );

   //! the specified test is done
   virtual void setTestDone ( dia_UID testID );

protected:
   //! default class constructor
   dia_TestController ( void );
   //! class destructor
   virtual ~dia_TestController ( void );

   virtual tBool canTestsBeStarted ( dia::UID condition ) const;
   //! destroy objects in the repository
   virtual void destroy ( void );

protected:
   //! repository of test objects controlled by this manager class
   std::map<dia_UID,dia_Test*> mTestRep;
};

void releaseInstanceOfTestController (void);
dia_TestController* getInstanceOfTestController ( void );

#endif /*__INCLUDED_DIA_TEST_CONTROLLER__*/
