/**
 * \file      dia_TestController.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 26, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#include <string.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include "common/framework/application/dia_AppController.h"
#endif
#endif

DIA_IMPL_SINGLETON(dia_TestController)

#ifndef __DIA_UNIT_TESTING__
dia_TestController*
getInstanceOfTestController ( void )
{
   return dia_TestController::getInstance();
}

void
releaseInstanceOfTestController ( void )
{
   return dia_TestController::deleteInstance();
}
#endif

//------------------------------------------------------------------------------

dia_TestController::dia_TestController ( void )
{}

//------------------------------------------------------------------------------

dia_TestController::~dia_TestController ( void )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_TestController::addTest ( dia_Test* pTestObj )
{
   dia_tclFnctTrace oTrace("dia_TestController::addTest()");

   if ( !pTestObj ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.find(pTestObj->getTestUID());
   if ( iter == mTestRep.end() )
   {
      mTestRep[pTestObj->getTestUID()] = pTestObj;
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("### TEST WITH UID 0x%08X ALREADY EXISTS. THE TEST WILL BE SKIPPED. ###", pTestObj->getTestUID() );
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_TestController::removeTest ( dia_UID id )
{
   dia_tclFnctTrace oTrace("dia_TestController::removeTest()");

   tDiaResult retCode = DIA_E_NOT_FOUND;

   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.find(id);
   if ( iter != mTestRep.end() )
   {
      dia_Test* pTest = mTestRep[id];
      mTestRep.erase(id);
      OSAL_DELETE pTest;
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tU16
dia_TestController::numberOfTests ( void ) const
{
   return (tU16) mTestRep.size();
}


//------------------------------------------------------------------------------

tDiaResult
dia_TestController::runTests ( dia::UID condition )
{
   dia_tclFnctTrace oTrace("dia_TestController::runTests(condition)");

   tDiaResult retCode = DIA_SUCCESS;

   if ( !canTestsBeStarted(condition) )
   {
      DIA_TR_ERR("### RUN TEST FAILED condition=%u ###", condition );
      return DIA_FAILED;
   }

   // at this point we know that we can run all tests
   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.begin();
   for ( ; iter != mTestRep.end(); iter++ )
   {
      if ( iter->second && iter->second->isTestConditionSupported(condition) )
      {
         DIA_TR_INF("### STARTING TEST UID=0x%08X NAME=%s ###", iter->second->getTestUID(), iter->second->getTestName());
         if ( iter->second->execute(condition) != DIA_SUCCESS )
         {
            DIA_TR_INF("### DIA_E_TEST_EXECUTION_FAILED NAME=%s ###", iter->second->getTestName());
            retCode = DIA_E_TEST_EXECUTION_FAILED;
         }
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_TestController::runTest ( dia_UID testID )
{
   tDiaResult retCode = DIA_FAILED;

   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.find(testID);
   if ( (iter != mTestRep.end()) && iter->second )
   {
      retCode = iter->second->execute(DIA_EN_TESTCONDITION_FORCE_TEST);
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_TestController::setTestDone ( dia_UID testID )
{
   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.find(testID);
   if ( iter != mTestRep.end() )
   {
      iter->second->testDone();
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_TestController::queryTest ( dia_UID testID, dia_Test** ppTest )
{
   if ( !ppTest ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_FAILED;

   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.find(testID);
   if ( iter != mTestRep.end() )
   {
      (*ppTest) = iter->second;
      retCode   = DIA_SUCCESS;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_TestController::queryTests ( dia::UID condition, std::list<dia_Test*>& testList )
{
   tDiaResult retCode = DIA_FAILED;
   DIA_DBG_TR_INF("mTestRep.size() = %zu", mTestRep.size());

   std::map<dia_UID,dia_Test*>::iterator iter = mTestRep.begin();
   for ( ; iter != mTestRep.end(); iter++ )
   {
      if ( iter->second && iter->second->isTestConditionSupported(condition) )
      {
         testList.push_back(iter->second);
         retCode = DIA_SUCCESS;

         DIA_DBG_TR_INF("dia_TestController::queryTests Found Test \"%s\"", iter->second->getTestName());
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tBool
dia_TestController::canTestsBeStarted ( dia::UID /*condition*/ ) const
{
#ifndef __DIA_UNIT_TESTING__
   tBool bRetCode = FALSE;

   // check power level (tests will not be started in low power mode
   dia_AppController* pAppCtrl = getInstanceOfAppController();
   if ( pAppCtrl )
   {
      if ( pAppCtrl->getResetMode() == eResetMode_Active )
      {
         DIA_TR_INF("TESTS NOT STARTED --> PERFORMING ECU RESET !!!");
         return bRetCode;
      }

      switch ( pAppCtrl->getPowerLevel() )
      {
      case ePowerLow:
      case ePowerLowCritical:
         DIA_TR_INF("TESTS NOT STARTED --> LOW POWER !!!");
         break;

      case ePowerHigh:
      case ePowerHighCritical:
         DIA_TR_INF("TESTS NOT STARTED --> HIGH POWER !!!");
         break;

      default:
         bRetCode = TRUE;
         break;
      } //lint !e788: not all items intentionally used within defaulted switch
   }

   return bRetCode;
#else
   return TRUE;
#endif
}

//-----------------------------------------------------------------------------

void
dia_TestController::destroy ( void )
{
   std::map<dia_UID,dia_Test*>::iterator mapIter = mTestRep.begin();
   for ( ; mapIter != mTestRep.end(); mapIter++ ) OSAL_DELETE mapIter->second;
   mTestRep.clear();
}

