/**
 * \file      dia_TestConfigHash.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Jul 21, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_TEST_CONFIG_HASH_H_
#define __INCLUDED_DIA_TEST_CONFIG_HASH_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#endif



class dia_TestConfigHash
    : public dia_TestService,
      public dia_IErrorLogListenerImpl,
	  public dia_IDisplayPatternAIVIListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_TestConfigHash);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_TestConfigHash);

public:

   dia_TestConfigHash(tU32 propRefConfFingerprintShortFormat, tU32 propResultFingerprintLongFormat, tU16 itc);

   virtual ~dia_TestConfigHash(void);

   //
   // overloaded methods from dia_IErrorLogListenerImpl
   //

   //
   // overloaded methods from dia_TestService
   //

   //! @brief   Process the received service:
   //!          1. Read set of configuration data.
   //!          2. Calculate SHA-1.
   //!          3. Compare calculated fingerprint to reference fingerprint.
   //!          4. Set ITC according to comparison result.
   //!          5. Write calculated fingerprint to registry in ascii format "{AABBCCDD-...-EEFFAABB}"
   //!             if actual and reference fingerprints are equal,
   //!             otherwise write zeros {00000000-...-00000000}.
   //!          In case of errors, please write zeros to the registry.
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   virtual void vOnTimeout ( void );

   //! Set property data vector
   virtual void setPropData(std::vector<tU32>& scrVect);

   //! Set property data vector
   virtual void setPropData(const dia_FingerprintInfo* setPropData, tU16 arraySize);

   virtual tU16 getItc() const { return mITC; }

protected:
   std::vector<tU32> mVectPropData;

   //! @brief     Set itc (see mITC) according to input result:
   //!            (Failed) when calculated hash is different than a value stored
   //!            in KDS (calculated offline by Opeth), otherwise Passed.
   //! @param[in] result
   virtual void setITC(bool result);

   //! @brief     Compare both fingerprints: calculated fingerprint and reference fingerprint
   //! @return    true if both fingerprints are equal, otherwise false.
   virtual bool compareBothFingerprints(std::vector<tU8>& calculatedHash);

   //! @brief     Method to be overloaded in project specific part
   //!            Check some condition(s) and change given result of fingerprint comparison.
   virtual bool checkAdditionalConditionForFPComparison(const std::vector<tU8> calculatedCDHash, bool origComparisonResult);

   //! Property ID for reading of 20 bytes reference fingerprint
   tU32 mPropertyReferenceConfFingerprintShortFormat;

   //! Property ID for writing of 47-bytes fingerprint result
   tU32 mPropertyResultFingerprintLongFormat;

   //! ITC to be set/unset after fingerprint comparison
   tU16 mITC;
};

#endif /*__INCLUDED_DIA_TEST_CONFIG_HASH_H_*/
