/**
 * \file      dia_TestCalcHashUpdateRegistry.h
 *
 * \brief     Test class for calculation of configuration hash and writing result in long format to registry.
 *
 * \details
 *
 * \author    kaa1hi
 * \date      Nov 12, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_TEST_CALC_HASH_UPDATE_REGISTRY_H_
#define __INCLUDED_DIA_TEST_CALC_HASH_UPDATE_REGISTRY_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

class dia_TestCalcHashUpdateRegistry
    : public dia_TestService
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_TestCalcHashUpdateRegistry);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_TestCalcHashUpdateRegistry);

public:

   dia_TestCalcHashUpdateRegistry( tCString name, tU16 testID, tU32 propResultHashLongFormat );

   virtual ~dia_TestCalcHashUpdateRegistry(void);

   //
   // overloaded methods from dia_TestService
   //

   //! @brief   Process the received service:
   //!          1. Read set of configuration data.
   //!          2. Calculate SHA-1.
   //!          3. Write calculated fingerprint to registry in ascii format "{AABBCCDD-...-EEFFAABB}"
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //! Set property data vector
   virtual void setPropData(const dia_FingerprintInfo* setPropData, tU16 arraySize);

   virtual void vOnTimeout ( void );

protected:
   std::vector<tU32> mVectPropData;

   //! Property ID for writing of 47-bytes hash result
   tU32 mPropResultHashLongFormat;
};

#endif /*__INCLUDED_DIA_TEST_CALC_HASH_UPDATE_REGISTRY_H_ */
