/**
 * \file      dia_Test.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 26, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_TEST__
#define __INCLUDED_DIA_TEST__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_TEST__
#include "common/framework/test/dia_defsTest.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_PROJECT_TEST__
#include "project/framework/test/dia_defsProjectTest.h"
#endif

class dia_Predicate;

class dia_Test
{
public:
   //! class constructor
   dia_Test ( tCString name, dia_enTestType=DIA_EN_TEST_TYPE_SIMPLE );
   //! class destructor
   virtual ~dia_Test ( void );

   //! retrieve the name of the test
   virtual tCString getTestName ( void ) const { return mTestName.c_str(); }
   //! Set the name
   virtual void setTestName ( std::string name ) { mTestName = name; }
   //! retrieve the identifier of the test
   virtual dia_UID getTestUID ( void ) const { return mUID; }
   //! retrieve the type of test
   virtual dia_enTestType getTestType ( void ) const { return mType; }

   //! add a new condition to the test object
   virtual tDiaResult addTestCondition ( dia::UID condition );
   //! add a new condition to the test object
   virtual tDiaResult addTestCondition ( const std::string&  conditionName );
   //! remove a test condition from the test object
   virtual tDiaResult removeTestCondition ( dia::UID condition );
   //! remove a test condition from the test object
   virtual tDiaResult removeTestCondition ( const std::string&  conditionName );
   //! remove a test condition from the test object
   virtual size_t sizeTestConditions ( void ) const { return mTestConditionRep.size(); }
   //! check if the specified condition is supported by the test
   virtual tBool isTestConditionSupported ( dia::UID condition ) const;

   //! add a predicate to the command
   virtual tDiaResult addPredicate ( dia_Predicate* pPredicate );

   //! run the test (level 1; called by test controller; setup of test environment; calls run method)
   virtual tDiaResult execute ( dia::UID condition );
   //! run the test (method has to be implemented by concrete subclasses)
   virtual tDiaResult run ( dia::UID condition ) = 0;

   //! return the state of the dirty flag. the dirty flag is used to prevent triggering the same test multiple times
   virtual void setDirty ( void ) { mDirty = TRUE; }
   //! return the state of the dirty flag. the dirty flag is used to prevent triggering the same test multiple times
   virtual tBool isDirty ( void ) const { return mDirty; }
   //! return the state of the dirty flag
   virtual void testDone ( void ) { mDirty = FALSE; }

protected:
   //! deprecated default constructor
   dia_Test ( void );

   //! termination method that can be overloaded by subclasses
   virtual void testTerminate ( void ) { testDone(); }

protected:
   //! name of the test object
   std::string  mTestName;
   //! test type of the test object
   dia_enTestType mType;
   //! unique test identifier
   dia_UID mUID;
   //! repository of supported test conditions
   std::list<dia::UID> mTestConditionRep;
   //! dirty flag to indicate if the test was already started, but not yet executed
   tBool mDirty;
   //! list of predicates attached to this command
   std::list<dia_Predicate*> mpPredicateRep;
};

#endif /*__INCLUDED_DIA_TEST__*/
