/**
 * \file      dia_Test.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 26, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_TEST__
#include <common/framework/test/dia_Test.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE__
#include <common/framework/application/dia_Predicate.h>
#endif

//------------------------------------------------------------------------------

dia_Test::dia_Test (tCString name, dia_enTestType type )
   : mTestName(std::string(name)),
     mType(type),
     mUID(dia_getHashCodeFromString(name)),
     mDirty(FALSE)
{
   mpPredicateRep.clear();
}

//------------------------------------------------------------------------------

dia_Test::~dia_Test ( void )
{
   _BP_TRY_BEGIN
   {
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_Predicate,mpPredicateRep)
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_Test::~dia_Test !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_Test::addTestCondition ( dia::UID condition )
{
   dia::ScopeTrace oTrace("dia_Test::addTestCondition()");

   tDiaResult retCode = DIA_FAILED;

   std::list<dia::UID>::iterator iter = std::find(mTestConditionRep.begin(), mTestConditionRep.end(), condition);
   if ( iter == mTestConditionRep.end() )
   {
      mTestConditionRep.push_back(condition);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_Test::addTestCondition ( const std::string&  conditionName )
{
   dia::ScopeTrace oTrace("dia_Test::addTestCondition(const std::string&)");

   return addTestCondition(dia_getHashCodeFromString(conditionName));
}

//------------------------------------------------------------------------------

tDiaResult
dia_Test::removeTestCondition ( dia::UID condition )
{
   dia::ScopeTrace oTrace("dia_Test::addTestCondition()");

   tDiaResult retCode = DIA_FAILED;

   std::list<dia::UID>::iterator iter = std::find(mTestConditionRep.begin(), mTestConditionRep.end(), condition);
   if ( iter != mTestConditionRep.end() )
   {
      mTestConditionRep.erase(iter);
      retCode = DIA_SUCCESS;
   }
   else
   {
      retCode = DIA_E_NOT_FOUND;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_Test::removeTestCondition ( const std::string&  conditionName )
{
   dia::ScopeTrace oTrace("dia_Test::removeTestCondition(const std::string&)");

   return removeTestCondition(dia_getHashCodeFromString(conditionName));
}

//------------------------------------------------------------------------------

tBool
dia_Test::isTestConditionSupported ( dia::UID condition ) const
{
   tBool bRetCode = FALSE;

   // return TRUE immediately in case that test execution is enforced
   if ( condition == DIA_EN_TESTCONDITION_FORCE_TEST ) return TRUE;

   std::list<dia::UID>::const_iterator iter = std::find(mTestConditionRep.begin(), mTestConditionRep.end(), condition);
   if ( iter != mTestConditionRep.end() ) {
      bRetCode = TRUE;
   }

   return bRetCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_Test::execute ( dia::UID condition )
{
   dia::ScopeTrace oTrace("dia_Test::execute()");

   tDiaResult retCode = DIA_FAILED;

   // only trigger the test if it was not already triggered before and execution is still pending
   if ( !isDirty() )
   {
      if ( condition != DIA_EN_TESTCONDITION_FORCE_TEST ) mDirty = TRUE;
      retCode = run(condition);
   }
   else
   {
      DIA_TR_INF("TEST mUID=0x%08X mName=%s NOT STARTED --> TEST ALREADY STARTED !!!", mUID, mTestName.c_str());
      retCode = DIA_E_ALREADY_STARTED;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Test::addPredicate ( dia_Predicate* pPredicate )
{
   dia::ScopeTrace trc("dia_Test::addPredicate()");

   tDiaResult retCode = DIA_FAILED;

   if ( pPredicate )
   {
//    std::list<dia_Predicate*>::iterator iter = std::find(mpPredicateRep.begin(), mpPredicateRep.end(), condition);
      std::list<dia_Predicate*>::iterator iter = mpPredicateRep.begin();
      for ( ; iter != mpPredicateRep.end(); iter++ )
      {
         if ( (*iter) && ((*iter)->getUID() == pPredicate->getUID()) ) break;
      }

      if ( iter == mpPredicateRep.end() )
      {
         mpPredicateRep.push_back(pPredicate);
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}


