/*!
 * \file       dia_SystemSettingsPluginDummy.h
 *
 * \brief      dummy plugin for system-setting to enable feature-tests of system-setting framework
 *
 * \details    arguments of contructor define the behavior of the plugin.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSystemSettings
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_DUMMY__
#define __INCLUDED_DIA_SYSTEMSET_PLUGIN_DUMMY__

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/framework/application/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN__
#include "common/framework/sysset/dia_SystemSettingsPlugin.h"
#endif

class dia_SystemSettingsPluginDummy :
   public dia_SystemSettingsPlugin
{
public:
   //! default class constructor
   dia_SystemSettingsPluginDummy (
                                  tCString name, 
                                  uint32_t retryCounter,
                                  dia_enSystemSettingLevel level,
                                  tDiaResult errorCode
                                  );
   //! class destructor
   virtual ~dia_SystemSettingsPluginDummy (  );

   //! prepare for the upcoming system setting
   virtual tDiaResult prepare ( dia_UID sysSetTypeUID );
   //! perform the system set operation
   virtual tDiaResult execute ( dia_UID sysSetTypeUID );
   //! finalize the system set operation
   virtual tDiaResult finalize ( dia_UID sysSetTypeUID );

   

protected:
   tDiaResult getResult(dia_enSystemSettingLevel level);
   uint32_t mRetryCounter;
   dia_enSystemSettingLevel mLevel;
   tDiaResult mErrorCode;
};

#endif
