/*!
 * \file       dia_SystemSettingsPluginDummy.cpp
 *
 * \brief      dummy plugin for system-setting to enable feature-tests of system-setting framework
 *
 * \details    see header
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSystemSettings
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include "dia_SystemSettingsPluginDummy.h"

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

static const tU32 DIA_C_U32_DEFAULT_PROCESSING_TIMEOUT = 300;

dia_SystemSettingsPluginDummy::dia_SystemSettingsPluginDummy (
                                                              tCString name,
                                                              uint32_t retryCounter,
                                                              dia_enSystemSettingLevel level,
                                                              tDiaResult errorCode
                                                    ):
   dia_SystemSettingsPlugin(name),
   mRetryCounter(retryCounter),
   mLevel(level),
   mErrorCode(errorCode)
 {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::CTOR() %s retryCounter=%u, level=%u, errorCode=0x%08x", 
              getName(), mRetryCounter, mLevel, mErrorCode );
    addSupportedSysSetType(DIA_C_STR_SYSTEM_SETTING_TYPE_TEST);

 }

dia_SystemSettingsPluginDummy::~dia_SystemSettingsPluginDummy (  ) {
}


   //! prepare the module for the system setting
tDiaResult dia_SystemSettingsPluginDummy::prepare ( dia_UID /*sysSetTypeUID*/ ) {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::prepare() %s", getName());
   return getResult(DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE);
}
   //! execute the system setting
tDiaResult dia_SystemSettingsPluginDummy::execute ( dia_UID /*sysSetTypeUID*/ ) {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::execute() %s", getName());
   return getResult(DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE);
}
   //! finalize the system setting
tDiaResult dia_SystemSettingsPluginDummy::finalize ( dia_UID /*sysSetTypeUID*/ ) {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::finalize() %s", getName());
   return getResult(DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE);
}

tDiaResult dia_SystemSettingsPluginDummy::getResult(dia_enSystemSettingLevel level) {
   dia_SystemSettingsManager* systemSettingsManager=getInstanceOfSystemSettingsManager();
   uint16_t retryCounter=systemSettingsManager->getRetryCounter();
   tDiaResult errorCode=DIA_SUCCESS;
   if (retryCounter == mRetryCounter) {
      if (level == mLevel) {
         errorCode=mErrorCode;
      }
   }
   DIA_TR_INF("dia_SystemSettingsModuleDummy::getResult() mErrorCode=0x%08x", errorCode);
   return errorCode;
}
