/*!
 * \file       dia_SystemSettingsModuleDummy.h
 *
 * \brief      dummy module for system-setting to enable feature-tests of system-setting framework
 *
 * \details    arguments of contructor define the behavior of the module.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSystemSettings
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTING_MDOULE_DUMMY__
#define __INCLUDED_DIA_SYSTEM_SETTING_MDOULE_DUMMY__

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif



class dia_SystemSettingsModuleDummy :
   public dia_SystemSettingsModule,
   public dia_ITimerListener
{
public:
dia_SystemSettingsModuleDummy (
      tCString name,
      uint32_t retryCounter,
      dia_enSystemSettingLevel level,
      tDiaResult errorCode
      );

   // destructor
   virtual ~dia_SystemSettingsModuleDummy ( void );

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemSettingsModule
   //--------------------------------------------------------------------------

   //! prepare the module for the system setting
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! finalize the system setting
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

protected:
   // constructor
   dia_SystemSettingsModuleDummy ( void ); // Not implemented, do not use

   void startTimer();

   uint32_t mRetryCounter;
   dia_enSystemSettingLevel mLevel;
   tDiaResult mErrorCode;

   dia_enSystemSettingLevel mCurLevel;

   //! timer used to trigger sending of result
   dia_Timer mTimer;

};

#endif
