/*!
 * \file       dia_SystemSettingsModuleDummy.cpp
 *
 * \brief      dummy module for system-setting to enable feature-tests of system-setting framework
 *
 * \details    see header
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSystemSettings
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif


#include "dia_SystemSettingsModuleDummy.h"

static const tU32 DIA_C_U32_DEFAULT_PROCESSING_TIMEOUT = 300;

static const dia_SystemSettingsModuleTypeInfo arSystemSettingsModuleTypeInfo[] = {
      { DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_TEST,  DIA_C_STR_SYSTEM_SETTING_TYPE_TEST,   0 }
};


dia_SystemSettingsModuleDummy::dia_SystemSettingsModuleDummy (
                                                              tCString name,
                                                              uint32_t retryCounter,
                                                              dia_enSystemSettingLevel level,
                                                              tDiaResult errorCode
                                                              ):
   dia_SystemSettingsModule(name),
   mRetryCounter(retryCounter),
   mLevel(level),
   mErrorCode(errorCode),
   mCurLevel(DIA_EN_SYSTEM_SETTING_LEVEL_UNKNOWN)
 {
    mTimer.s32Create();
   loadSystemSettingsModuleTypeInfo(arSystemSettingsModuleTypeInfo,(tU16) (sizeof(arSystemSettingsModuleTypeInfo)/sizeof(dia_SystemSettingsModuleTypeInfo)));
   DIA_TR_INF("dia_SystemSettingsModuleDummy::CTOR() %s retryCounter=%u, level=%u, errorCode=0x%08x", 
              getName(), mRetryCounter, mLevel, mErrorCode );

 }

dia_SystemSettingsModuleDummy::~dia_SystemSettingsModuleDummy ( void ) {
   mTimer.s32Delete();
   mTimer.removeTimerListener(this);
}

void dia_SystemSettingsModuleDummy::startTimer() {
   mTimer.addTimerListener(this);
   mTimer.s32SetTime(0,0);
   mTimer.s32SetTime(DIA_C_U32_DEFAULT_PROCESSING_TIMEOUT , 0);
}

   //! prepare the module for the system setting
tDiaResult dia_SystemSettingsModuleDummy::prepareSystemSetting ( dia_UID /*sysSetTypeUID*/, const dia_SystemSettingExtendedData& /*extData*/ ) {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::prepareSystemSetting() %s", getName());

   mCurLevel=DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE;
   startTimer();
   return DIA_SUCCESS;   
}
   //! execute the system setting
tDiaResult dia_SystemSettingsModuleDummy::executeSystemSetting ( dia_UID /*sysSetTypeUID*/, const dia_SystemSettingExtendedData& /*extData*/ ) {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::executeSystemSetting() %s", getName());
   mCurLevel=DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE;
   startTimer();
   return DIA_SUCCESS;   
}
   //! finalize the system setting
tDiaResult dia_SystemSettingsModuleDummy::finalizeSystemSetting ( dia_UID /*sysSetTypeUID*/, const dia_SystemSettingExtendedData& /*extData*/ ) {
   DIA_TR_INF("dia_SystemSettingsModuleDummy::finalizeSystemSetting() %s", getName());
   mCurLevel=DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE;
   startTimer();
   return DIA_SUCCESS;   
}

void dia_SystemSettingsModuleDummy::vOnTimerElapsed(dia_TimerID /* id */ ) {
   dia_SystemSettingsManager* systemSettingsManager=getInstanceOfSystemSettingsManager();
   uint16_t retryCounter=systemSettingsManager->getRetryCounter();
   tDiaResult errorCode=DIA_SUCCESS;
   if (retryCounter == mRetryCounter) {
      if (mCurLevel == mLevel) {
         errorCode=mErrorCode;
      }
   }
   if (mErrorCode == DIA_E_TIMEOUT) {
      return;
      // do nothing
   }
   DIA_TR_INF("dia_SystemSettingsModuleDummy::vOnTimerElapsed() %s errorCode=0x%08x", getName(), mErrorCode);

   
   systemSettingsManager->onSystemSettingsModuleUpdate(*this, dia_getHashCodeFromString(DIA_C_STR_SYSTEM_SETTING_TYPE_TEST), mCurLevel, errorCode);
}
