#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

// system adapters
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__
#include "common/framework/sysadapters/dia_SystemAdapterServicePlugin.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_MAIN__
#include "../../depricated/dia_main.h"
#endif

/*#define C_U16_CMDCOUNT_SETGETMSG    0*/
#define C_U16_CMDCOUNT_UPREGMSG     1
#define C_U16_CMDCOUNT_RELUPREGMSG  2
/*#define C_U16_CMDCOUNT_METHODSTART  3*/

using namespace std;

//-----------------------------------------------------------------------------

dia_SystemAdapterFeature::dia_SystemAdapterFeature (
      tCString name,
      dia_SystemAdapterServicePlugin& srvPlugin,
      dia_enSAFeatureType type
   )
   : mName(name),
     mpSrvPlugin(&srvPlugin),
     _bFidReg(FALSE),
     mAppID(DIA_USED_APP_ID),
     mType(type)
{
}

//-----------------------------------------------------------------------------

dia_SystemAdapterFeature::~dia_SystemAdapterFeature ( tVoid )
{
   mName = OSAL_NULL;
   mpSrvPlugin = OSAL_NULL;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterFeature::dispatchMessage ( amt_tclBaseMessage *pMessage )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterFeature::vDispatchMessage");
   ahl_tclBaseWork::vDispatchMessage(pMessage);
   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterFeature::registerFunction ( tU16 u16FID )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterFeature::registerFunction");

   tDiaResult retCode = DIA_FAILED;

   diagnostics_tclApp* pApp = diagnostics_tclApp::getInstance();

   // Check that the registration Id is valid
   if ( pApp && ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID ) )
   {
      // create message with upreg - request
      gm_tclEmptyMessage oUpRegMessage (
            mAppID,                         // AppID of this application
            mpSrvPlugin->getClientID(),       // AppID of the Server
            mpSrvPlugin->getRegistrationID(), // RegId for the service (see bRegisterForService )
            0,              // always 0
            mpSrvPlugin->getServiceID(),     // SID of the service
            u16FID,         // FID to register for
            AMT_C_U8_CCAMSG_OPCODE_UPREG
      );

      oUpRegMessage.vSetCmdCounter(C_U16_CMDCOUNT_UPREGMSG);

      if ( pApp->enPostMessage(&oUpRegMessage) == AIL_EN_N_NO_ERROR )
      {
         // message send success - set the return value to TRUE
         retCode = DIA_SUCCESS;
      }
      else
      {
      }
   }
   else
   {
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterFeature::unregisterFunction ( tU16 u16FID )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterFeature::unregisterFunction");

   tDiaResult retCode = DIA_FAILED;

   diagnostics_tclApp* pApp = diagnostics_tclApp::getInstance();

   // registration invalid?
   if ( pApp && ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID ) )
   {
      /* create message with relupreg - request */
      gm_tclEmptyMessage oRelupRegMessage (
            mAppID,        // AppID of this application
            mpSrvPlugin->getClientID(),   // AppID of the Server
            mpSrvPlugin->getRegistrationID(),      // RegId for the service (see bRegisterForService )
            0,              // always 0
            mpSrvPlugin->getServiceID(),     // SID of the service
            u16FID,         // FID to register for
            AMT_C_U8_CCAMSG_OPCODE_RELUPREG
      );

      oRelupRegMessage.vSetCmdCounter(C_U16_CMDCOUNT_RELUPREGMSG);

      if ( pApp->enPostMessage(&oRelupRegMessage) == AIL_EN_N_NO_ERROR )
      {
         // message send success - set the return value to TRUE
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterFeature::getFunctionIDs ( list<tU16>& results ) const
{
   const mm_tMsgMap* pMessageMap = GetMsgMap();
   if(pMessageMap == nullptr)
   {
      DIA_TR_ERR("##### dia_SystemAdapterFeature: NO MESSAGE MAP AVAILABLE !!!!! ##### ");
      return DIA_FAILED;
   }
   const mm_tMsgMapEntry* pEntry = pMessageMap->pEntries;

   if (pEntry )
   {
      for ( ; pMessageMap != NULL; pMessageMap=pMessageMap->pBaseMap)
      {
         while ( (pEntry->u16FunctionID) != 0 )
         {
            results.push_back(pEntry->u16FunctionID);
            pEntry++;
         }
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterFeature::startMonitoring ( tVoid )
{
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterFeature::stopMonitoring ( tVoid )
{
   return DIA_SUCCESS;
}
