/*!
 * \file       dia_SystemAdapter.h
 *
 * \brief      System adapter class
 *
 * \details    System adapter class that is assembled with Service plugins and features
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSysAdapters
 *
 * \copyright  (c) 2011-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER__
#define __INCLUDED_DIA_SYSTEM_ADAPTER__

//
// includes
//

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_APPSTATE_LISTENER__
#include <common/interfaces/dia_IAppStateListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_CCA__
#include <common/depricated/SystemAdapter/dia_ISystemCCA.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__
#include <common/framework/sysadapters/dia_SystemAdapterServicePlugin.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include <common/framework/sysadapters/dia_SystemAdapterFeature.h>
#endif

#include <common/framework/fsm/generated/dia_SystemAdapterFSM.h>

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#ifndef __INCLUDED_DIA_CONDVAR__
#include <common/framework/application/dia_CondVar.h>
#endif

// declaration of owner class
class dia_SystemAdapterServicePlugin;

//----------------------------------------------------------------------------------------

class dia_SystemAdapter
#ifndef __DIA_UNIT_TESTING__
   : public ahl_tclBaseWork,
     public dia_IAppStateListener,
#else
   : public dia_IAppStateListener,
#endif
     protected dia_SystemAdapterFSM::FsmBehaviour
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SystemAdapter);

public:
   static dia_SystemAdapter* create ( tCString name, tU16 clientAppID );

   //! class destructor
   virtual ~dia_SystemAdapter ( void );

   //! overloaded methods from dia_IAppStateListener
   virtual void onApplicationStateChangePrepare ( dia::ApplicationStateID srcStateID, dia::ApplicationStateID destStateID );
   virtual void onApplicationStateChange ( dia::ApplicationStateID srcStateID, dia::ApplicationStateID destStateID );
   virtual void onApplicationStateChangeFinalize ( dia::ApplicationStateID destStateID );
   virtual bool isApplicationStateChanging ( void ) const { return mIsApplicationStateChangeInProgress; }

   //! called from framework to log registration details
   virtual void vLogRegistrationID ( tU16 u16RegID, tU16 u16AppID, tU16 u16SrvID, tU16 u16SrcSubID );

   //! overwritten method of ahl_tclBaseWork, called from diagnostics_tclApp::vOnServiceState()
   virtual void vOnServiceState ( tU16 u16SrvID, tU16 u16AppID, tU16 u16RegID, tU8 u8SrvState, tU16 u16SubId);

   //! overwritten method of ahl_tclBaseWork, dispatcher for incoming messages
   virtual void vDispatchMessage(amt_tclBaseMessage *pBaseMessage);

   //! add a plugin for a given service of the associated application
   tDiaResult addServicePlugin ( dia_SystemAdapterServicePlugin& pPlugin );

   tU16 getClientID ( void ) const { return mClientAppID; }

protected:
   //! default constructor
   dia_SystemAdapter ( tCString name, tU16 clientAppID );
   //! deprecated default constructor
   dia_SystemAdapter ( void );

   //!
   tDiaResult setup ( void );

   //! overwritten method of ahl_tclBaseWork
   virtual void vOnUnknownMessage ( amt_tclBaseMessage* poMessage );
   virtual void vOnErrorMessage ( amt_tclServiceData* poMessage ) const;

   //! post a trigger state machine event to the state machine
   virtual void acceptEvent ( dia_SystemAdapterFSM::FsmEvent event, void* pArg );

   //! system state NORMAL reached
   virtual void vFsmNormalModeReached ( void* /*pArg*/ );
   //! system state PAUSE reached
   virtual void vFsmPauseModeReached ( void* /*pArg*/ );
   //! system state OFF reached
   virtual void vFsmOffModeReached ( void* /*pArg*/ );
   //! process the received message
   virtual void vFsmProcessMessage ( void* pArg );
   //! process unknown message
   virtual void vFsmUnknownMessage ( void* pArg );
   //! register all services controlled by this system adapter
   virtual void vFsmRegisterServices ( void* pArg );
   //! unregister all services controlled by this system adapter
   virtual void vFsmUnregisterServices ( void* pArg );
   //! check if an application state change is requested and all conditions are fulfilled
   virtual void vFsmEvaluateRegistrationIDs ( void* pArg );
   //! check if all registration requests are pending
   virtual bool bFsmAreNoRegistrationsPending ( void* pArg );

protected:
   tCString mName;

   // synchronization lock object.
   dia::Lock mSyncObj;

   //! application ID of the concrete client handler
   tU16   mAppID;
   tU16   mClientAppID;

   dia::ApplicationStateID mApplicationStateRequested;

   std::map<tU16,dia_SystemAdapterServicePlugin*> mPluginRep;

   //! pointer to the FSM object
   dia_SystemAdapterFSM::Fsm* mpFSM;

   bool mIsApplicationStateChangeInProgress;
   bool mIsRegistrationInProgress;
};

#endif /* DIA_SYSADAPTER_H_ */
