/**
 * \file      dia_SAFeatureTestPattern.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    abe6kor
 * \date      June 12, 2017
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef DIA_SAFEATURETESTPATTERN_H_
#define DIA_SAFEATURETESTPATTERN_H_


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYTEST__
#include "common/interfaces/dia_IDisplayTest.h"
#endif

#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#define DIAGNOSTICS_S_IMPORT_INTERFACE_MSG
#include "fc_diagnosis_if.h"

#include "common/interfaces/dia_IDisplayTestListener.h"
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureTestPattern
   : public dia_SystemAdapterFeature,
     public dia_IDisplayTest

{
	  DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureTestPattern);
public:
	//! default class constructor
   dia_SAFeatureTestPattern( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
   //! destructor
   virtual ~dia_SAFeatureTestPattern ( void );

   //! Set Test Pattern
   virtual tDiaResult setDisplayPatternID (dia_eDisplayPatternID ePatternID );

protected:
   //! handle the result of a message
   void vSetDisplay       ( amt_tclServiceData* poMessage );
   bool  bUpreg(amt_tclServiceData const* poMessage);
   bool  bRelUpreg(amt_tclServiceData const* poMessage);
   DECLARE_MSG_MAP(dia_SAFeatureTestPattern)

private:
   diagnostics_tclApp* m_poGWMain;
  // dia_tclService* potclService;
   tVoid vNotifyAllClients(fi_tclTypeBase const&, tU16);

   tVoid vSendStatusMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
   tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8) const;
   // declare message map data structures

};

#endif /* DIA_SAFEATURETESTPATTERN_H_ */
