 /*
 * dia_SAFeatureTestPattern.cpp
 *
 *  Created on: 23.06.2017
 *      Author: abe6kor
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef DIA_SAFEATURETESTPATTERN_H_
#include "common/framework/sysadapters/dia_SAFeatureTestPattern.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

BEGIN_MSG_MAP( dia_SAFeatureTestPattern, dia_SystemAdapterFeature )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY,vSetDisplay )
END_MSG_MAP()


dia_SAFeatureTestPattern::dia_SAFeatureTestPattern (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureTestPattern::dia_SAFeatureTestPattern");
   m_poGWMain = diagnostics_tclApp::getInstance();
}

dia_SAFeatureTestPattern::~dia_SAFeatureTestPattern()
{}

tDiaResult
dia_SAFeatureTestPattern::setDisplayPatternID ( dia_eDisplayPatternID ePatternID )
{
	dia_tclFnctTrace trc("dia_SAFeatureTestPattern::setDisplayPatternID");

	static midw_fi_tcl_e8_TestScreens::tenType displayTestPatternMapping[DIA_EN_DISPLAY_PATTERN_COUNT] = {
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_UNKNOWN
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_NONE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINWHITE,          // DIA_EN_DISPLAY_PATTERN_WHITE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINBLACK,          // DIA_EN_DISPLAY_PATTERN_BLACK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINRED,            // DIA_EN_DISPLAY_PATTERN_RED
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINGREEN,          // DIA_EN_DISPLAY_PATTERN_GREEN
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PLAINBLUE,           // DIA_EN_DISPLAY_PATTERN_BLUE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_COLOURED,            // DIA_EN_DISPLAY_PATTERN_COLOURED
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_COLOURGRADIATION,    // DIA_EN_DISPLAY_PATTERN_COLOURED_GRADIATION
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_DIAGNOSISMASK,       // DIA_EN_DISPLAY_PATTERN_DIAGNOSIS_MASK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_LATTICE,             // DIA_EN_DISPLAY_PATTERN_LATTICE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_LEFTWHITERIGHTBLACK, // DIA_EN_DISPLAY_PATTERN_WHITE_BLACK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_LEFTBLACKRIGHTWHITE, // DIA_EN_DISPLAY_PATTERN_BLACK_WHITE
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_PIXELWISECHESSBOARD, // DIA_EN_DISPLAY_PATTERN_CHESSBOARD
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_CHESSBOARD_INVERT
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_STRIPS
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_GRAY64
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_SCREEN_7,            // DIA_EN_DISPLAY_PATTERN_FLICKER_TEST,
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_SCREEN_8,            // DIA_EN_DISPLAY_PATTERN_TEST_MARK,
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_NOTESTSCREEN,        // DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_TEFSPECIAL1,         // DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL1
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_TEFSPECIAL2,          // DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL2
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_RGB_NOK,            //DIA_EN_DISPLAY_PATTERN_RGB_NOK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_RGB_OK,            //DIA_EN_DISPLAY_PATTERN_RGB_OK
	      (midw_fi_tcl_e8_TestScreens::tenType) midw_fi_tcl_e8_TestScreens::FI_EN_RGB_REPDARK            //DIA_EN_DISPLAY_PATTERN_RGB_REPDARK
	   };

	   tDiaResult retVal = DIA_FAILED;
	   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
	   {
	   if (ePatternID < DIA_EN_DISPLAY_PATTERN_COUNT)
	   {
	      midw_diagnosticsfi_tclMsgSetDisplayStatus oStatusData;
	      oStatusData.DisplayData.TestScreen.enType = displayTestPatternMapping[ePatternID];

	      midw_fi_tclString oFiString;
	      oStatusData.DisplayData.DisplayStrings.StringList.resize(6);

	      if (midw_fi_tcl_e8_TestScreens::FI_EN_DIAGNOSISMASK == displayTestPatternMapping[ePatternID]) {
	         tCString szLine1 = "Best ";
	         tCString szLine2 = "Wishes ";
	         tCString szLine3 = "From ";
	         tCString szLine4 = "Dynamic ";
	         tCString szLine5 = "Diagnostics ";
	         tCString szLine6 = "Team";
	         oStatusData.DisplayData.DisplayStrings.StringList[0].bSet(szLine1, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[1].bSet(szLine2, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[2].bSet(szLine3, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[3].bSet(szLine4, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[4].bSet(szLine5, midw_fi_tclString::FI_EN_UTF8);
	         oStatusData.DisplayData.DisplayStrings.StringList[5].bSet(szLine6, midw_fi_tclString::FI_EN_UTF8);
	      }

	      vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY);
	      retVal = DIA_SUCCESS;

	   }
	   }
	   else {
	          DIA_TR_INF("dia_SAFeatureTestPattern - getRegistrationID failed.");
	          DIA_TR_INF("dia_SAFeatureTestPattern - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	       }

	   return retVal;
}

void dia_SAFeatureTestPattern::vSetDisplay(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc( "dia_SAFeatureTestPattern::vSetDisplay" );

   if( poMessage )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
        	       case AMT_C_U8_CCAMSG_OPCODE_UPREG:
        	        DIA_TR_INF( "vSetDisplay --> AMT_C_U8_CCAMSG_OPCODE_UPREG !!");
        	 //         vTraceSimple(I_DIA_HMI_SETDISPLAY_02);
        	          if (!bUpreg(poMessage)) {
        	             //vTraceSimple(I_DIA_HMI_SETDISPLAY_03);
        	             // create and send error  message
        	             amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
        	             m_poGWMain->enPostMessage(&oErrorMessage);
        	             DIA_ASSERT_ALWAYS();
        	          } else {
        	             // Upreg successful : send a status message.
        	             midw_diagnosticsfi_tclMsgSetDisplayStatus oStatusData;
        	             // send dummy status data
        	             vSendStatusMsg(poMessage, oStatusData);
        	          }
        	          (tVoid) poMessage->bDelete();
        	          break;
        	       case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        	        DIA_TR_INF( "vSetDisplay --> AMT_C_U8_CCAMSG_OPCODE_RELUPREG !!");
        	          //vTraceSimple(I_DIA_HMI_SETDISPLAY_04);
        	          if (!bRelUpreg(poMessage)) {
        	             //vTraceSimple(I_DIA_HMI_SETDISPLAY_05);
        	             // Relupreg failed: send an error message
        	             amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
        	             m_poGWMain->enPostMessage(&oErrorMessage);
        	             DIA_ASSERT_ALWAYS();
        	          } else {
        	             // Relupreg successful : no action
        	          }
        	          (tVoid) poMessage->bDelete();
        	          break;
        	       case AMT_C_U8_CCAMSG_OPCODE_SET: {
        	          DIA_TR_INF("vSetDisplay --> AMT_C_U8_CCAMSG_OPCODE_SET !!");
        	          //vTraceSimple(I_DIA_HMI_SETDISPLAY_06);

        	          dia_IDisplayTestListener* pListener = OSAL_NULL;
        	          querySysAdapterListener<dia_IDisplayTestListener>(&pListener);
        	          if (pListener) {
        	             DIA_TR_INF(" A valid listener exists for SetDisplay");

        	             // Get method result data into fi type
        	             fi_tclVisitorMessage oMsg(poMessage);
        	             midw_diagnosticsfi_tclMsgSetDisplaySet oData;
        	             (tVoid) oMsg.s32GetData(oData);

        	             tDiaResult SetDisplayResult = (oData.DisplayTestSuccess == TRUE ) ? DIA_SUCCESS : DIA_FAILED;

        	             DIA_TR_INF("vSetDisplay --- result = %0x08x", SetDisplayResult);

        	             // inform all interested listeners
        	             pListener->vOnSetDisplayTestPatternDone(SetDisplayResult);
        	          }
        	       }
        	          break;
        	       default:
        	          // unknown opcode: just delete message
        	          (tVoid) poMessage->bDelete();
        	          break;
        	    }
        	 }
         }

tVoid
dia_SAFeatureTestPattern::vNotifyAllClients(fi_tclTypeBase const& oFIData, tU16 u16FuncId)
{
	DIA_TR_INF(("--> dia_SAFeatureTestPattern::vNotifyAllClients"));

	//potclService->vUpdateAllClients(oFIData, u16FuncId);

	if (m_poGWMain && m_poGWMain->m_poNotTable)
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		m_poGWMain->m_poNotTable->vTraceTable(TR_CLASS_DIAGNOSTICS_BASE);

		// Run through the table to find all registered clients
		ahl_tNotification* pNot = m_poGWMain->m_poNotTable->poGetNotificationList(u16FuncId);

		DIA_TR_INF("--> dia_SAFeatureTestPattern::vNotifyAllClients pNot %p",pNot);

		for (; pNot != OSAL_NULL; pNot = pNot->pNext) {
			// construct result message
			fi_tclVisitorMessage oResultMsg(oFIData);
			// initialise result message
			oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
				pNot->u16AppID, // Target
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
				0, // StreamCounter
				pNot->u16RegisterID, // RegisterID
				pNot->u16CmdCounter, // nCmdCounter,
				DIA_USED_SRV_ID, // nServiceID,
				u16FuncId, // function ID
				AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL, pNot->u16SubID);

			if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR) {
				(tVoid) oResultMsg.bDelete();
			}
		}
		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}
	else
	{
		DIA_TR_INF(("!!! dia_SAFeatureTestPattern::vNotifyAllClients => ERROR: Null pointer - m_poGWMain or m_poNotTable"));
	}
	DIA_TR_INF(("<-- dia_SAFeatureTestPattern::vNotifyAllClients"));
}

bool
dia_SAFeatureTestPattern::bUpreg(amt_tclServiceData const* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureTestPattern::bUpreg");

   if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

   tBool bRegOpStatus = FALSE;

	if(poMessage->u16GetFunctionID())
   {

         ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

         // Add the client to notification table
            bRegOpStatus = m_poGWMain->m_poNotTable->bAddNotification (
                  poMessage->u16GetFunctionID(),
                  poMessage->u16GetSourceAppID(),
                  poMessage->u16GetRegisterID(),
                  1,
                  poMessage->u16GetCmdCounter(),
               poMessage->u16GetSourceSubID());

         ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
      }

   return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//
// FUNCTION:   dia_SAFeatureTestPattern::bRelUpreg
//
// DESCRIPTION:   Removes the sender of the message from the NotifcationTable
//
// PARAMETER:  Relupreg request message
//
// RETURNVALUE:   true  : Client dereqistration successful
//                false : Client deregistration failed
//
///////////////////////////////////////////////////////////////////////////
//
bool
dia_SAFeatureTestPattern::bRelUpreg(amt_tclServiceData const* poMessage)
{
   if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

   tBool bRegOpStatus = FALSE;

   if ( (MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY != poMessage->u16GetFunctionID()) || (MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM != poMessage->u16GetFunctionID()) )
   {
       ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

   // Delete the client from notification table
      bRegOpStatus = m_poGWMain->m_poNotTable->bRemoveNotification (
            poMessage->u16GetFunctionID(),
            poMessage->u16GetSourceAppID(),
            poMessage->u16GetRegisterID(),
            1,
            poMessage->u16GetCmdCounter(),
            poMessage->u16GetSourceSubID()
            );

   ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
   }
   return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureTestPattern::vSendStatusMsg
//
//  DESCRIPTION: sends a CCA Status message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//

tVoid
dia_SAFeatureTestPattern::vSendStatusMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData) const
{

   if (NULL == poMessage) {
      return;
   }
   vSendMsg(poMessage, oFIData, AMT_C_U8_CCAMSG_OPCODE_STATUS);
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureTestPattern::vSendMsg
//
//  DESCRIPTION: sends a CCA message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//                u8OpCode - CCA op code
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//
tVoid
dia_SAFeatureTestPattern::vSendMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData, tU8 u8OpCode) const
{
   if (NULL == poMessage) {
      return;
   }
   // construct result message
   fi_tclVisitorMessage oResultMsg(oFIData);
   // initialise result message
   oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
         poMessage->u16GetSourceAppID(), // Target
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
         0, // StreamCounter
         poMessage->u16GetRegisterID(), // RegisterID
         poMessage->u16GetCmdCounter(), // nCmdCounter,
         DIA_USED_SRV_ID, // nServiceID,
         poMessage->u16GetFunctionID(), // function ID
         u8OpCode, AMT_C_U16_DEFAULT_NULL, poMessage->u16GetSourceSubID());
   // send it
   if (NULL != m_poGWMain) {
      if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR)
      {
         (tVoid) oResultMsg.bDelete();
      }
   }
}

