/*
 * dia_SAFeatureSystemSettings.cpp
 *
 *  Created on: 30.08.2011
 *      Author: gib2hi
 */


#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include "common/framework/sysadapters/dia_SAFeatureSystemSettings.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

//-----------------------------------------------------------------------------

dia_SAFeatureSystemSettings::dia_SAFeatureSystemSettings (
   tCString name,
   tU32 u32SystemSetId,
   tU32 u32SystemSetTypes,
   dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin),
      dia_SystemSettingsModule(name,u32SystemSetTypes),
      mSystemSettingTypeUID(0),
      mu32SystemSetId(u32SystemSetId),
      mu32SystemSetTypes(u32SystemSetTypes)
{}

//-----------------------------------------------------------------------------

dia_SAFeatureSystemSettings::~dia_SAFeatureSystemSettings ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(mu32SystemSetId);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::dispatchMessage ( amt_tclBaseMessage* poMessage )
{
//   dia_tclFnctTrace oTrace( DIA_FILE_CURRENT, DIA_FUNC_ACCEPT_MESSAGE);
   tDiaResult retCode = DIA_FAILED;
   amt_tclServiceData oMsg( poMessage );

   if ( TRUE == dia_SAFeatureDiaglib::bIsSysSetMessage(&oMsg) )
   {
      if (dia_SAFeatureDiaglib::u32EvalSysSetMessage ( &oMsg, this ) != DIA_SUCCESS)
      {
         // Trace message handled but error
      }

      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::prepareSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettings::prepareSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("Prepare system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) )
   {
      retCode = (dia_SAFeatureDiaglib::bPrepareForSysSet(mu32SystemSetId, convertType(typeUID), mpSrvPlugin) == TRUE) ? DIA_SUCCESS : DIA_FAILED;
   }
   else
   {
      DIA_TR_INF("System setting type is not supported !!!");
      tDiaglibParamVector oVector;
      vOnSystemSetPrepareResult(EN_SYSTEMSET_OK, oVector);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::executeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettings::executeSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("Execute system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) )
   {
      retCode = (dia_SAFeatureDiaglib::bExecuteSysSet(mu32SystemSetId, convertType(typeUID), mpSrvPlugin) == TRUE) ? DIA_SUCCESS : DIA_FAILED;
   }
   else
   {
      DIA_TR_INF("System setting type is not supported !!!");
      tDiaglibParamVector oVector;
      vOnSystemSetResult(mu32SystemSetId, convertType(typeUID), EN_SYSTEMSET_OK, oVector);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::finalizeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettings::finalizeSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("Finalize system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) )
   {
      retCode = (dia_SAFeatureDiaglib::bEndOfSysSet(mu32SystemSetId, convertType(typeUID), mpSrvPlugin) == TRUE) ? DIA_SUCCESS : DIA_FAILED;
   }
   else
   {
      DIA_TR_INF("System setting type is not supported !!!");
      vOnSystemSetFinished();
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureSystemSettings::vOnSystemSetResult ( tU32 /*u32SysSetId*/, tenSystemSetType /*enSysSetType*/, tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList )
{
//   dia_tclFnctTrace oTrace( DIA_FILE_CURRENT, DIA_FUNC_ON_SYSSET_RESULT);
   tDiaResult retCode = ( enSystemSetResult == EN_SYSTEMSET_OK ) ? DIA_SUCCESS : convertErrorCode(oErrorList);
   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,retCode);
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureSystemSettings::vOnSystemSetPrepareResult ( tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList )
{
//   dia_tclFnctTrace oTrace( DIA_FILE_CURRENT, DIA_FUNC_ON_SYSSET_PREPARE_RESULT);
   tDiaResult retCode = ( enSystemSetResult == EN_SYSTEMSET_OK ) ? DIA_SUCCESS : convertErrorCode(oErrorList);
   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,retCode);
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureSystemSettings::vOnSystemSetFinished ( tVoid )
{
//   dia_tclFnctTrace oTrace( DIA_FILE_CURRENT, DIA_FUNC_ON_SYSSET_FINISHED);
   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,DIA_SUCCESS);
}

//-----------------------------------------------------------------------------

tenSystemSetType
dia_SAFeatureSystemSettings::convertType ( dia_UID typeUID ) const
{
   tenSystemSetType convertedType = EN_TYPE_DEFAULT_HMI; // unfortunalely no unknown type was defined, but type is checked before this method is called

   switch ( typeUID )
   {
   case DIA_C_UID_SYSTEM_SETTING_TYPE_HMI:                  convertedType = EN_TYPE_DEFAULT_HMI;      break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION:           convertedType = EN_TYPE_DEFAULT_TEF;      break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT:            convertedType = EN_TYPE_CODING;           break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_CALIBRATION:          convertedType = EN_TYPE_CALIBRATION;      break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_CUSTOMER:             convertedType = EN_TYPE_DEFAULT_CUSTOMER; break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_ALL:    convertedType = EN_TYPE_UM_RESET_ALL;     break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_USER:   convertedType = EN_TYPE_UM_RESET_USER;    break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_BANK:   convertedType = EN_TYPE_UM_RESET_BANK;    break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_USER:  convertedType = EN_TYPE_UM_SWITCH_USER;   break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_BANK:  convertedType = EN_TYPE_UM_SWITCH_BANK;   break;
   case DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SAVE_BANK:    convertedType = EN_TYPE_UM_SAVE_BANK;     break;
   default: break;
   }

   return convertedType;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::convertErrorCode(const tDiaglibParamVector& oList) const
{
//   dia_tclFnctTrace oTrace( DIA_FILE_CURRENT, DIA_FUNC_GET_ERROR);
   tDiaResult enError = DIA_SUCCESS;

   if(oList.size() >= 1 && oList[0].enType == EN_PARAMETER_TYPE_U8ERROR)
   {
      switch ( oList[0].u8ErrorValue )
      {
      case EN_ERROR_ID_NOT_SUPPORTED:
      case EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE:
      case EN_ERROR_ROUTINE_NOT_RUNNING:
      case EN_ERROR_WRITE_NOT_SUPPORTED:
      case EN_ERROR_READ_NOT_SUPPORTED:
      case EN_ERROR_ROUTINE_NEVER_RAN:
      case EN_ERROR_ROUTINE_STILL_RUNNING:
      case EN_ERROR_DEFSET_IN_PROGRESS:
      case EN_ERROR_FATAL_INTERNAL:
      case EN_ERROR_IOCONTROL_NOT_SUPPORTED:
      case EN_ERROR_IOCONTROL_ACTIONID_NOT_SUPPORTED:
      case EN_ERROR_NO_DATA:
      case EN_ERROR_DATA_LENGTH_INCORRECT:
      case EN_ERROR_NOT_DEFINED:
         enError = DIA_FAILED; // concrete assignment might be done later
         break;
      default:
         enError = DIA_FAILED;
         break;
      }
   }

   return enError;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettings::getFunctionIDs ( std::list<tU16>& results ) const
{
   results.push_back(MIDW_DIAGLIBFI_C_U16_SYSTEMSETPREPARE);
   results.push_back(MIDW_DIAGLIBFI_C_U16_SYSTEMSETFINISHED);
   results.push_back(MIDW_DIAGLIBFI_C_U16_SYSTEMSET);
   return DIA_SUCCESS;
}


