/*
 * dia_SAFeatureSwUpdate.cpp
 *
 *  Created on: 28.12.2015
 *      Author: nbs3kor
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif
#ifndef DIA_SAFEATURESWUPDATE_H_
#include <common/framework/sysadapters/dia_SAFeatureSwUpdate.h>
#endif


//------------------------------------------------------------------------------

dia_SAFeatureSwUpdate::dia_SAFeatureSwUpdate(
      dia_SystemAdapterServicePluginASF<FcSwUpdateSrvProxy>& pSrvPlugin
   )
    : dia_SystemAdapterFeatureASF(pSrvPlugin)
{
}
//-----------------------------------------------------------------------------

dia_SAFeatureSwUpdate::~dia_SAFeatureSwUpdate()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSwUpdate::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSwUpdate::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSwUpdate::enterRecoveryMode ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::enterRecoveryMode");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendEnterRecoveryModeRequest(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("enterRecoveryMode mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("enterRecoveryMode returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSwUpdate::getSwUpdateInfo ( const dia_tHistoryScope& historyScope )
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::getSwUpdateInfo");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      retCode = mpSrvPlugin->executeServiceFunctor(std::unique_ptr<dia_Functor>(new FunctorSendRequest<GetUpdateHistoryScopedCallbackIF, dia_tHistoryScope>(
            [this](){ return this->mpSrvPlugin->getProxy(); }, this, historyScope)));
   }

   DIA_TR_INF("dia_SAFeatureSwUpdate::getSwUpdateInfo returned 0x%08X.", retCode );

   return retCode;
}

//-----------------------------------------------------------------------------

template<> template<> //... as often as there are nested template specializations
tDiaResult
dia_SAFeatureSwUpdate::FunctorSendRequest<GetUpdateHistoryScopedCallbackIF, dia_tHistoryScope>::operator() (void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::FunctorSendRequest<GetUpdateHistoryScopedCallbackIF, dia_tHistoryScope>::operator()");

   FcSwUpdateSrvProxy* proxy = mGetProxy();
   if (!proxy || !mpCallbackIF)
   {
      return DIA_E_INVALID_POINTER;
   }

   tDiaResult retCode = DIA_FAILED;

   const dia_tHistoryScope& historyScope = std::get<0>(mArgs);

   tenHistoryScope enSwUpdateHistoryScope = tenHistoryScope__All;

   switch(historyScope.mHistoryScope)
   {
      case DIA_EN_UPDATE_HISTORY_SCOPE_ALL:
         enSwUpdateHistoryScope = tenHistoryScope__All;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_USB:
         enSwUpdateHistoryScope = tenHistoryScope__FirstUsb;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_OTA:
         enSwUpdateHistoryScope = tenHistoryScope__FirstOta;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_USB_SINCE_FACTORY:
         enSwUpdateHistoryScope = tenHistoryScope__FirstUsbSinceFactory;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_OTA_SINCE_FACTORY:
         enSwUpdateHistoryScope = tenHistoryScope__FirstOtaSinceFactory;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_INITIAL:
         enSwUpdateHistoryScope = tenHistoryScope__Initial;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_INITIAL_SINCE_FACTORY:
         enSwUpdateHistoryScope = tenHistoryScope__InitialSinceFactory;
         break;

      case DIA_EN_UPDATE_HISTORY_SCOPE_ALL_SINCE_FACTORY:
         enSwUpdateHistoryScope = tenHistoryScope__AllSinceFactory;
         break;

      default:
         DIA_ASSERT_ALWAYS();
         break;
   }

   DIA_TR_INF("GetUpdateHistoryScoped: enSwUpdateHistoryScope = 0x%0X, IndexStart = %u, MaxEntries = %u",
         enSwUpdateHistoryScope, historyScope.mIndexStart, historyScope.mMaxEntries);

   act_t token = proxy->sendGetUpdateHistoryScopedRequest(*mpCallbackIF, enSwUpdateHistoryScope, historyScope.mIndexStart, historyScope.mMaxEntries);
   if (0!=token)
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("sendGetUpdateHistoryScopedRequest: ERROR - token is zero!");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult 
dia_SAFeatureSwUpdate::updateAllSubModules (  )
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::updateAllSubModules");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      tU8 strMountPoint[128];
      tU8 strPath[128];
      tU8 strFile[128];
      if (
         (DIA_SUCCESS != dia_getProperty(DIA_PROP_SWUPDATE_MOUNT_POINT, strMountPoint, sizeof(strMountPoint)))
         ||
         (DIA_SUCCESS != dia_getProperty(DIA_PROP_SWUPDATE_PATH, strPath, sizeof(strPath)))
         ||
         (DIA_SUCCESS != dia_getProperty(DIA_PROP_SWUPDATE_FILE, strFile, sizeof(strFile)))
         )
      {
         DIA_TR_ERR("dia_SAFeatureSwUpdate::updateAllSubModules: ERROR - property not found!");
         return retCode;
      }
      trReleaseAccess releaseAccess;
      releaseAccess.setMountPoint((const char*) strMountPoint); //"/var/opt/bosch/persistent");
      releaseAccess.setPath((const char*) strPath); //"fcswupdate");
      releaseAccess.setFile((const char*) strFile); //"bosch.xml");      
      trReleaseFilter releaseFilter;
      releaseFilter.setEnUpgradeDirectionFilter(tenUpdOptions__Any); //2
#ifdef VARIANT_S_FTR_ENABLE_AI_SW_UPDATE_COMMON_15_P1_INT_56
	  releaseAccess.setUseExtendedOptions(true);
      releaseAccess.setReleaseFilter(releaseFilter);
      releaseAccess.setUpdateOption(tenUpdOptions__Any); //2
      releaseAccess.setDoApply(true);
      releaseAccess.setPostImageInstallationMode(true);
#endif
	  
      act_t token = mpSrvPlugin->getProxy()->sendUpdateSelectReleaseByFileRequest(*this, releaseAccess);
      if (0!=token)
      {
         DIA_TR_INF("getSwUpdateInfo : token is different than zero.");
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSwUpdate::updateAllSubModules: ERROR - token is zero!");
      }
   }   
   
   return retCode;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::onGetUpdateHistoryScopedError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/,
                                                     const ::boost::shared_ptr< GetUpdateHistoryScopedError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onGetUpdateHistoryScopedError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}
//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::onGetUpdateHistoryScopedResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/,
                                                        const ::boost::shared_ptr< GetUpdateHistoryScopedResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onGetUpdateHistoryScopedResponse");

   std::vector<dia_tProgramHistory> progInfo;

   tU32 numberofupdates              = response->getNumberOfUpdates();
   tU32 numberOfUpdatesSinceDelivery = response->getNumberOfUpdatesSinceDelivery();
   tU32 numberOfUpateLogs            = response->getNumberOfUpateLogs();
   tU32 enScopeRes                   = response->getEnScopeRes();
   tBool bOK                         = response->getBOk();

   DIA_TR_INF("onGetUpdateHistoryResponse : numberofupdates is = %d", numberofupdates);
   DIA_TR_INF("onGetUpdateHistoryResponse : numberOfUpdatesSinceDelivery is = %d", numberOfUpdatesSinceDelivery);
   DIA_TR_INF("onGetUpdateHistoryResponse : numberOfUpateLogs is = %d", numberOfUpateLogs);
   DIA_TR_INF("onGetUpdateHistoryResponse : enScopeRes is = %d", enScopeRes);
   DIA_TR_INF("onGetUpdateHistoryResponse : bOK is = %d", bOK);

   trUpdLogs updLogs = response->getLogs();
   std::vector< trUpdLog > updLog = updLogs.getUpdateLogs();
   size_t updateLogSize = updLogs.getUpdateLogs().size();

   DIA_TR_INF("onGetUpdateHistoryResponse : UpdateLog size is = %zu", updateLogSize);

   progInfo.clear();

   for (std::vector < trUpdLog >::const_iterator iter_upLog_data = updLog.begin();
            iter_upLog_data != updLog.end(); ++iter_upLog_data)
   {
      dia_tProgramHistory programhistory;

      trUpdLog upLogEntry = *iter_upLog_data;
      programhistory.mSwVersionName = upLogEntry.getName();
      DIA_TR_INF("onGetUpdateHistoryResponse: versionName =%s", upLogEntry.getName().c_str());

      programhistory.mProgStatus = upLogEntry.getSuccess();
      DIA_TR_INF("onGetUpdateHistoryResponse: mProgStatus =%d", programhistory.mProgStatus);

      trTimeDate timeDate = upLogEntry.getTimeDate();

      programhistory.mYear   = (tU16)timeDate.getYear();
      programhistory.mMonth  = (tU8)timeDate.getMonth();
      programhistory.mDay    = (tU8)timeDate.getDay();

      programhistory.mHour   = (tU8)timeDate.getHour();
      programhistory.mMinute = (tU8)timeDate.getMinute();
      programhistory.mSecond = (tU8)timeDate.getSeconds();

      DIA_TR_INF("onGetUpdateHistoryResponse : mYear is = %d", programhistory.mYear);
      DIA_TR_INF("onGetUpdateHistoryResponse : mMonth is = %d", programhistory.mMonth);
      DIA_TR_INF("onGetUpdateHistoryResponse : mDay is = %d", programhistory.mDay);
      DIA_TR_INF("onGetUpdateHistoryResponse : mHour is = %d", programhistory.mHour);
      DIA_TR_INF("onGetUpdateHistoryResponse : mMinute is = %d", programhistory.mMinute);
      DIA_TR_INF("onGetUpdateHistoryResponse : mSecond is = %d", programhistory.mSecond);

      // Fill the vector
      progInfo.push_back(programhistory);
   }

   // force thread context switch to context of diagnosis worker thread to inform the listeners
   getInstanceOfApplication()->postMessage (
         DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorOneTemplateArgNoReturnValue<dia_SAFeatureSwUpdate,dia_tProgramHistory,std::vector > (this,&dia_SAFeatureSwUpdate::vOnSwUpdateInfo,progInfo)
         )
   );

   getInstanceOfApplication()->postMessage (
         DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSwUpdate,tU32 > (this,&dia_SAFeatureSwUpdate::vOnNoOfSwReUpdate,numberOfUpateLogs)
         )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::vOnSwUpdateInfo(const std::vector<dia_tProgramHistory>& progInfo)
{
   dia::ScopeTrace trc("dia_SAFeatureSwUpdate::vOnSwUpdateInfo");

   dia_ISwUpdateListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISwUpdateListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnSwUpdateInfo(progInfo);
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISwUpdateListener NULL");
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::vOnNoOfSwReUpdate(tU32 numberOfUpateLogs)
{
   dia::ScopeTrace trc("dia_SAFeatureSwUpdate::vOnNoOfSwReUpdate");

   dia_ISwUpdateListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISwUpdateListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnNoOfSwReUpdate((tU16)numberOfUpateLogs);
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISwUpdateListener NULL");
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::onEnterRecoveryModeError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/, const ::boost::shared_ptr< EnterRecoveryModeError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onEnterRecoveryModeError");

   DIA_TR_ERR( "=> ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::onEnterRecoveryModeResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/, const ::boost::shared_ptr< EnterRecoveryModeResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onEnterRecoveryModeResponse");

   //Recovery Mode was set: true or false
   tBool bRecoveryMode = response->getBOk();

   DIA_TR_INF("onEnterRecoveryModeResponse : bRecoveryMode is = %s", (bRecoveryMode? "TRUE": "FALSE") );

   getInstanceOfApplication()->postMessage (
        DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
           DIA_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSwUpdate,bool > (this,&dia_SAFeatureSwUpdate::onEnterRecoveryModeResponse,bRecoveryMode)
        )
        );
}

//-----------------------------------------------------------------------------
void
dia_SAFeatureSwUpdate::onEnterRecoveryModeResponse(bool bRecoveryMode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onEnterRecoveryModeResponse");

   dia_ISwUpdateListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISwUpdateListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnRecoveryMode(bRecoveryMode);
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISwUpdateListener NULL");
   }
}

//-----------------------------------------------------------------------------

void 
dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/,
                                                        const ::boost::shared_ptr< UpdateSelectReleaseByFileError >& /*error*/)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileError");
	
}

//-----------------------------------------------------------------------------

void 
dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/,
                                                           const ::boost::shared_ptr< UpdateSelectReleaseByFileResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileResponse");

   bool bOK = false;
   if (response->hasBOk())
   {
      bOK = response->getBOk();
      DIA_TR_INF("response: bOk = %d", bOK);
   }

   dia_eSwUpdateError eError = DIA_EN_UPDATE_ERROR_UNKNOWN;
   if (response->hasEnErrorId())
   {
      DIA_TR_INF("response: enErrorId = %d", response->getEnErrorId());
      switch (response->getEnErrorId())
      {
      case tenErrorId__SWL_OK:
         eError = DIA_EN_UPDATE_ERROR_OK;
         break;
#if 0
      tenErrorId__SWL_ECU_TO_BE_UPDATED = 1u,
      tenErrorId__SWL_ERROR_DOWNLOAD_MRG_BUSY = 2u,
      tenErrorId__SWL_ERROR_ERG_WRITE = 3u,
      tenErrorId__SWL_ERROR_ERG_READ = 4u,
      tenErrorId__SWL_ERROR_NOT_ENOUGH_MEMORY = 5u,
      tenErrorId__SWL_ERROR_SUMMARY_SCREENS = 6u,
      tenErrorId__SWL_ERROR_INVALID_SOURCE_SET = 7u,
#endif
      case tenErrorId__SWL_ERROR_UNKNOWN:
         eError = DIA_EN_UPDATE_ERROR_UNKNOWN;
         break;
#if 0
      tenErrorId__SWL_ERROR_METAINFO_NOT_FOUND = 9u,
      tenErrorId__SWL_ERROR_METAINFO_READ = 10u,
      tenErrorId__SWL_ERROR_METAINFO_CHECKSUM = 11u,
      tenErrorId__SWL_ERROR_METAINFO_PARSE = 12u,
      tenErrorId__SWL_ERROR_METAINFO_SECTION_COMMON_NOT_FOUND = 13u,
      tenErrorId__SWL_ERROR_METAINFO_SECTION_SIGNATURE_NOT_FOUND = 14u,
      tenErrorId__SWL_ERROR_METAINFO_MANDATORY_TAG_NOT_FOUND = 15u,
      tenErrorId__SWL_ERROR_METAINFO_DUPLICATE_SECTION = 16u,
      tenErrorId__SWL_ERROR_METAINFO_SECTION_NOT_FOUND = 17u,
      tenErrorId__SWL_ERROR_METAINFO_UNEXPECTED_SUBSECTION = 18u,
      tenErrorId__SWL_ERROR_METAINFO_INVALID_SUBSECTION_PATH = 19u,
      tenErrorId__SWL_ERROR_METAINFO_REGION_CONFLICT = 20u,
      tenErrorId__SWL_ERROR_METAINFO_VARIANT_CONFLICT = 21u,
      tenErrorId__SWL_ERROR_METAINFO_INVALID_TRAIN_NAME = 22u,
      tenErrorId__SWL_ERROR_IMAGE_SIZE = 23u,
      tenErrorId__SWL_ERROR_IMAGE_CHECKSUM = 24u,
      tenErrorId__SWL_ERROR_IMAGE_INVALID_SECTORHEADER = 25u,
      tenErrorId__SWL_ERROR_IMAGE_INCOMPATIBLE_VERSION = 26u,
      tenErrorId__SWL_ERROR_IMAGE_READ = 27u,
      tenErrorId__SWL_ERROR_IMAGE_FLASHING = 28u,
      tenErrorId__SWL_ERROR_IMAGE_DEVICE_NOT_SUPPORTED = 29u,
      tenErrorId__SWL_ERROR_IMAGE_DEVICE_NOT_READY = 30u,
      tenErrorId__SWL_ERROR_IMAGE_DEVICE_NOT_SELECTED = 31u,
      tenErrorId__SWL_ERROR_IMAGE_DEVICE_INCOMPATIBLE_DM_VERSION = 32u,
      tenErrorId__SWL_ERROR_SIGNATURE_CHECK_FAILED = 33u,
      tenErrorId__SWL_ERROR_CHANGE_BOOTMODE_NOT_POSSIBLE = 34u,
      tenErrorId__SWL_ERROR_NO_RELEASE_FOUND = 35u,
      tenErrorId__SWL_ERROR_MEDIA_UNAVAILABLE = 36u,
      tenErrorId__SWL_ERROR_MEDIUM_REMOVED = 37u,
      tenErrorId__SWL_ERROR_OTP_READ_FAILED = 38u,
      tenErrorId__SWL_ERROR_IMAGE_INCOMPATIBLE_DOWNGRADE = 39u,
      tenErrorId__SWL_ERROR_IMAGE_INCOMPATIBLE_SAME_VERSION = 40u
#endif
      default:
         break;
      }
   }
	
   getInstanceOfApplication()->postMessage (
         DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorTwoArgsNoReturnValue<dia_SAFeatureSwUpdate,bool,dia_eSwUpdateError > (this,&dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileResponse,bOK,eError)
         )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileResponse(bool bOk, dia_eSwUpdateError eError)
{
   dia_tclFnctTrace trc("dia_SAFeatureSwUpdate::onUpdateSelectReleaseByFileResponse");

   dia_ISwUpdateListener* pListener = 0;
   if ((querySysAdapterListener<dia_ISwUpdateListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnUpdateAllSubModules(bOk, eError);
   }
   else
   {
      DIA_TR_INF("querySysAdapterListener dia_ISwUpdateListener NULL");
   }
}

//-----------------------------------------------------------------------------

