/*
 * dia_SAFeatureSensorPV.cpp
 *
 *  Created on: 10.09.2015
 *      Author: wgl2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_SERVICEINFO
#include "sensor_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "dia_SAFeatureSensorPV.h"

BEGIN_MSG_MAP(dia_SAFeatureSensorPV,dia_SystemAdapterFeature)
ON_MESSAGE(SENSOR_PVFI_C_U16_VELOCITY, vHandleSensorSpeed)
ON_MESSAGE(SENSOR_PVFI_C_U16_POSITION, vHandleSensorPosition)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureSensorPV::dia_SAFeatureSensorPV (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureSensorPV::dia_SAFeatureSensorPV");
}

//-----------------------------------------------------------------------------

dia_SAFeatureSensorPV::~dia_SAFeatureSensorPV ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensorPV::getSensorSpeed ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSensorPV::getSensorSpeed");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureSensor::getSensorSpeed - send message.");

      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         SENSOR_PVFI_C_U16_VELOCITY,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureSensor::getSensorSpeed - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureSensor::getSensorSpeed - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSensor::getSensorPosition - getRegistrationID failed.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensorPV::getSensorPosition ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSensorPV::getSensorPosition");

   tDiaResult retCode = DIA_FAILED;

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSensorPV::vHandleSensorSpeed ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSensorPV::vHandleSensorSpeed");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_STATUS)
   {
      fi_tclVisitorMessage oStatusMessage(poMessage);
      sensor_pvfi_tclMsgvelocityStatus oStatusMsgData;
      (void) oStatusMessage.s32GetData(oStatusMsgData);

      DIA_TR_INF("dia_SAFeatureSensorPV::vHandleSensorSpeed - Receive speed message.");

      dia_ISensorSpeedListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_ISensorSpeedListener>(&pListener);
      if ( pListener )
      {
         tU16 u16Speed = oStatusMsgData.velocityValue;
         tU16 eSource = static_cast<tU16>(oStatusMsgData.velocitiySource.enType);

         DIA_TR_INF("dia_SAFeatureSensorPV::vHandleSensorSpeed - speed=%d source=%d", u16Speed, eSource);
         if (eSource == sensor_fi_tcl_e8_velocity_source::FI_EN_SRC_V_INVALID) {
            DIA_TR_INF("dia_SAFeatureSensorPV::vHandleSensorSpeed - source=%d FI_EN_SRC_V_INVALID!", eSource);
            u16Speed = SENSOR_SPEED_INVALID;
         }
         pListener->vOnSensorSpeed(u16Speed);
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureSensor::vHandleSensorSpeed - Message with unhandled/unknown opcode received:");
   }

   // Delete the message we are unable process it at this time
   (void) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSensorPV::vHandleSensorPosition ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSensorPV::vHandleSensorLocation");
}
