/*
 * dia_SAFeatureSensor.h
 *
 *  Created on: 11.01.2011
 *      Author: gib2hi
 */

#ifndef DIA_SAFEATURESENSOR_H_
#define DIA_SAFEATURESENSOR_H_

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

// implemented interfaces
#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#include "common/interfaces/dia_ISensorListener.h"
#endif

#define DIA_GPS_FIX_TIME   0x01
#define DIA_GPS_2D_FIX     0x02
#define DIA_GPS_3D_FIX     0x03
#define DIA_GPS_COLDSTART  0x04
#define DIA_GPS_NO_FIX     0x05


class amt_tclServiceData;

class dia_SAFeatureSensor
    : public dia_SystemAdapterFeature,
      public dia_ISensor
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureSensor);

public:
    //! default class constructor
    dia_SAFeatureSensor ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
    //! class destructor
    virtual ~dia_SAFeatureSensor ();

    //
    // implementation of the dia_ISensor interface
    //
    virtual tDiaResult bGetSensor3dGyroValue();
    virtual tDiaResult bGetSensor3dAccValue();
#if 0 //STC2HI: Obsolete, please implement a SystemAdapter for dia_IGNSS::getGNSSData
    virtual tDiaResult bGetSensorGpsDataValue();
#endif
#if 0 //STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component
    virtual tDiaResult bGetSensorAntennaCurrentValue();
#endif
    virtual tDiaResult getSensorSpeed ();
    virtual tDiaResult getOdometerCount ();
    virtual tDiaResult vGyroSelfTest   ();
    virtual tDiaResult vAccSelfTest    ();

protected:
#if 0 //STC2HI: Obsolete, please implement a SystemAdapter handler function for SENSOR_LOCATIONFI_C_U16_GNSSDATA
    tVoid vHandleSensorGpsData(amt_tclServiceData* poMessage)const;
#endif
#if 0 //STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component
    tVoid vHandleSensorAntennaCurrent(amt_tclServiceData* poMessage)const;
#endif
    tVoid vHandleSensor3dAccStatus(amt_tclServiceData* poMessage)const;
    tVoid vHandleSensor3dGyroUpdateStatus(amt_tclServiceData* poMessage)const;

#if 0 //STC2HI: Obsolete?
    tVoid vHandleGalaSpeed ( amt_tclServiceData* poMessage ) const;
#endif
    tVoid vHandleOdometerCount ( amt_tclServiceData* poMessage ) const;

    tVoid vHandleGyroSelfTest ( amt_tclServiceData* poMessage ) const;
    tVoid vHandleAccSelfTest ( amt_tclServiceData* poMessage ) const;

    //! overloaded to register for all needed FIDs when the service is available
   // virtual tBool bOnServiceStateAvailable ( tU16 u16SrvID, tU16 u16SubId );

    tBool bSendMessage (
            const tU8  u8MessageType,
            const tU16 u16FID,
            const tU8  u8Opcode,
            const tU16 u16MsgLength,
            const tU8  u8MsgBuffer[]
            );

    // declare message map data structures
    DECLARE_MSG_MAP(dia_SAFeatureSensor)
};

#endif /* DIA_SAFEATURESENSOR_H_ */
