/*
 * dia_SAFeatureSensor.cpp
 *
 *  Created on: 13.08.2012
 *      Author:
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_FUNCTIONIDS
#include "sensor_fi_if.h"

#else

#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_STDVISITORS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_FUNCTIONIDS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "cmb_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

#include "dia_SAFeatureSensor.h"

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
// map used to convert Gyro status code (defined in sensor) to internal DIA Gyro status code
std::map<sensor_fi_tcl_e16_GyroStatus::tenType, dia_eGyroStatus> dia_InternalGyroStatusMapping;

// map used to convert Acc status code (defined in sensor) to internal DIA Acc status code
std::map<sensor_fi_tcl_e16_AccStatus::tenType, dia_eAccStatus> dia_InternalAccStatusMapping;
#endif

// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

BEGIN_MSG_MAP(dia_SAFeatureSensor, dia_SystemAdapterFeature)
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_ACC3DDATA_UPDATE,        vHandleSensor3dAccStatus)
ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_GYRO3DDATA_UPDATE,       vHandleSensor3dGyroUpdateStatus)
ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_GYROSELFTEST,            vHandleGyroSelfTest)
ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_ACCSELFTEST,             vHandleAccSelfTest)
ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_ODOMETERDATA_UPDATE,     vHandleOdometerCount)
#else
ON_MESSAGE(CMB_SENSORFI_C_U16_ACC3DDIAGDATA,        vHandleSensor3dAccStatus)
ON_MESSAGE(CMB_SENSORFI_C_U16_GYRO3DDATA_UPDATE,    vHandleSensor3dGyroUpdateStatus)
#if 0 //STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component
ON_MESSAGE(CMB_SENSORFI_C_U16_ANTENNACURRENT,       vHandleSensorAntennaCurrent)
#endif
#if 0 //STC2HI: Obsolete, please implement a SystemAdapter handler function for SENSOR_LOCATIONFI_C_U16_GNSSDATA
ON_MESSAGE(CMB_SENSORFI_C_U16_GPSEXTDATA,           vHandleSensorGpsData)
#endif
#if 0 //STC2HI: Obsolete?
ON_MESSAGE(CMB_SENSORFI_C_U16_GALASPEED,              vHandleGalaSpeed)
#endif
ON_MESSAGE(CMB_SENSORFI_C_U16_ODOMETERDATA_UPDATE,      vHandleOdometerCount)
#endif

END_MSG_MAP()


//------------------------------------------------------------------------------

dia_SAFeatureSensor::dia_SAFeatureSensor (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::dia_SAFeatureSensor");

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
   // Gyro
    dia_InternalGyroStatusMapping[sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL]        = DIA_EN_GYRO_STATUS_CONNECTED_NORMAL;
    dia_InternalGyroStatusMapping[sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_OUT_OF_ORDER]            = DIA_EN_GYRO_STATUS_OUT_OF_ORDER;
    dia_InternalGyroStatusMapping[sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_OVERHEAT]                = DIA_EN_GYRO_STATUS_OVERHEAT;
    dia_InternalGyroStatusMapping[sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_SENSOR_NOT_PRESENT]      = DIA_EN_GYRO_STATUS_SENSOR_NOT_PRESENT;
    dia_InternalGyroStatusMapping[sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_DATA_INVALID]  = DIA_EN_GYRO_STATUS_CONNECTED_DATA_INVALID;
    dia_InternalGyroStatusMapping[sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_INTERNALERROR] = DIA_EN_GYRO_STATUS_CONNECTED_INTERNALERROR;

    // Acc
    dia_InternalAccStatusMapping[sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_CONNECTED_NORMAL]        = DIA_EN_ACC_STATUS_CONNECTED_NORMAL;
    dia_InternalAccStatusMapping[sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_OUT_OF_ORDER]            = DIA_EN_ACC_STATUS_OUT_OF_ORDER;
    dia_InternalAccStatusMapping[sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_OVERHEAT]                = DIA_EN_ACC_STATUS_OVERHEAT;
    dia_InternalAccStatusMapping[sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_SENSOR_NOT_PRESENT]      = DIA_EN_ACC_STATUS_SENSOR_NOT_PRESENT;
    dia_InternalAccStatusMapping[sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_CONNECTED_DATA_INVALID]  = DIA_EN_ACC_STATUS_CONNECTED_DATA_INVALID;
    dia_InternalAccStatusMapping[sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_CONNECTED_INTERNALERROR] = DIA_EN_ACC_STATUS_CONNECTED_INTERNALERROR;
#endif
}

//-----------------------------------------------------------------------------

dia_SAFeatureSensor::~dia_SAFeatureSensor ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensor::getSensorSpeed()
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::getSensorSpeed");

   tDiaResult retCode = DIA_FAILED;

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensor::getOdometerCount ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureSensor::getOdometerCount()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureSensor::getOdometerCount - send message.");
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
       sensor_locationfi_tclMsgOdometerData_UpdateGet oMsgData; //lint !e1502 Auto generated code, class is a parameter itself
       fi_tclVisitorMessage oMessage(oMsgData);
       mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_ODOMETERDATA_UPDATE, AMT_C_U8_CCAMSG_OPCODE_GET);
#else
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          CMB_SENSORFI_C_U16_ODOMETERDATA_UPDATE,
          CCA_C_U8_OPCODE_GET
       );
#endif
         if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureSensor::getOdometerCount - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureSensor::getOdometerCount - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureSensor::getOdometerCount - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureSensor::getOdometerCount - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
   return retCode;
}

//-----------------------------------------------------------------------------

#if 0 //STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component

tDiaResult
dia_SAFeatureSensor::bGetSensorAntennaCurrentValue()
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSensor::bGetSensorAntennaCurrentValue"));

   tDiaResult retCode = DIA_FAILED;

   //construct MethodStart message
   cmb_sensorfi_tclMsgAntennaCurrentGet oMsgData;
   fi_tclVisitorMessage oTestMsg(oMsgData);
   oTestMsg.vInitServiceData (
                               mAppID,
                               mpSrvPlugin->getClientID(),
                               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                               0,
                               mpSrvPlugin->getRegistrationID(),
                               0,
                               mpSrvPlugin->getServiceID(),
                               CMB_SENSORFI_C_U16_ANTENNACURRENT,
                               AMT_C_U8_CCAMSG_OPCODE_GET
                               );

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureSensor::bGetSensorAntennaCurrentValue => post the message to SENSOR"));

   if ( mpSrvPlugin->bTransmitMessage(&oTestMsg) == TRUE )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSensor::bGetSensorAntennaCurrentValue => ERROR: transmitMessage failed."));
   }
   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSensor::bGetSensorAntennaCurrentValue (%x)",retCode));
   return retCode;
}

#endif

//-----------------------------------------------------------------------------

#if 0 //STC2HI: Obsolete, please implement a SystemAdapter for dia_IGNSS::getGNSSData

tDiaResult
dia_SAFeatureSensor::bGetSensorGpsDataValue()
{
   ETG_TRACE_USR3_THR(("--> dia_SAFeatureSensor::bGetSensorGpsDataValue"));

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      ETG_TRACE_USR4_THR(("--- dia_SAFeatureSensor::bGetSensorGpsDataValue => post the message to SENSOR"));

      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         CMB_SENSORFI_C_U16_GPSEXTDATA,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSensor::bGetSensorGpsDataValue => ERROR: transmitMessage failed."));
      }
   }
   else
   {
      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureSensor::bGetSensorGpsDataValue => ERROR: getRegistrationID failed."));
   }


   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureSensor::bGetSensorGpsDataValue (%x)",retCode));
   return retCode;
}

#endif

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensor::bGetSensor3dAccValue()
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::bGetSensor3dAccValue");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureSensor::bGetSensor3dAccValue => post the message to SENSOR");

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
      sensor_locationfi_tclMsgAcc3dData_UpdateGet oMsgData;  //lint !e1502 Auto generated code, class is a parameter itself
      fi_tclVisitorMessage oMessage(oMsgData);
      mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_ACC3DDATA_UPDATE, AMT_C_U8_CCAMSG_OPCODE_GET);
#else
      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         CMB_SENSORFI_C_U16_ACC3DDIAGDATA,
         CCA_C_U8_OPCODE_GET
      );
#endif

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("!!! dia_SAFeatureSensor::bGetSensor3dAccValue => ERROR: transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_SAFeatureSensor::bGetSensor3dAccValue => ERROR: getRegistrationID failed.");
   }

   DIA_TR_INF("dia_SAFeatureSensor::bGetSensor3dAccValue retCode=0x%08X", retCode);
   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensor::bGetSensor3dGyroValue()
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::bGetSensor3dGyroValue");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("--- dia_SAFeatureSensor::bGetSensor3dGyroValue => post the message to SENSOR");

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
      sensor_locationfi_tclMsgGyro3dData_UpdateGet oMsgData;   //lint !e1502 Auto generated code, class is a parameter itself
      fi_tclVisitorMessage oMessage(oMsgData);
      mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_GYRO3DDATA_UPDATE, AMT_C_U8_CCAMSG_OPCODE_GET);
#else
      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         CMB_SENSORFI_C_U16_GYRO3DDATA_UPDATE,
         CCA_C_U8_OPCODE_GET
      );
#endif

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("!!! dia_SAFeatureSensor::bGetSensor3dGyroValue => ERROR: transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_SAFeatureSensor::bGetSensor3dGyroValue => ERROR: getRegistrationID failed.");
   }

   DIA_TR_INF("dia_SAFeatureSensor::bGetSensor3dGyroValue retCode=%x",retCode);
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSensor::vGyroSelfTest( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::vGyroSelfTest()");

   tDiaResult retCode = DIA_FAILED;

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureSensor::vGyroSelfTest - send message.");

      sensor_locationfi_tclMsgGyroSelfTestMethodStart oMsgData;   //lint !e1502 Auto generated code, class is a parameter itself
      fi_tclVisitorMessage oMessage(oMsgData);
      mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_GYROSELFTEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureSensor::vGyroSelfTest - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureSensor::vGyroSelfTest - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureSensor::vGyroSelfTest - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureSensor::vGyroSelfTest - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }
#endif

   return retCode;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureSensor::vAccSelfTest( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::vAccSelfTest()");

   tDiaResult retCode = DIA_FAILED;

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureSensor::vAccSelfTest - send message.");

      sensor_locationfi_tclMsgAccSelfTestMethodStart oMsgData; //lint !e1502 Auto generated code, class is a parameter itself
      fi_tclVisitorMessage oMessage(oMsgData);
      mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_ACCSELFTEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureSensor::vAccSelfTest - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureSensor::vAccSelfTest - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureSensor::vAccSelfTest - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureSensor::vAccSelfTest - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }
#endif

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_SAFeatureSensor::vHandleSensor3dAccStatus(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::vHandleSensor3dAccStatus()");

   if(poMessage != NULL)
   {
      // Msg must come from a server
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      // Extract the op code of the message called
      tU8 u8OpCode = poMessage->u8GetOpCode();

      dia_ISensorListener* pListener = OSAL_NULL;

      if((querySysAdapterListener<dia_ISensorListener>(&pListener) == DIA_SUCCESS) && (pListener != OSAL_NULL))
      {
         // Switch on the opCode received
         switch (u8OpCode)
         {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dAccStatus => AMT_C_U8_CCAMSG_OPCODE_STATUS");

               fi_tclVisitorMessage oResultMsg(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
               sensor_locationfi_tclMsgAcc3dData_UpdateStatus oCompResp;
               tS32 s32Result = oResultMsg.s32GetData(oCompResp);
               if (s32Result)
               {
                  DIA_TR_ERR("!!! dia_SAFeatureSensor::vHandleSensor3dAccStatus => ERROR: s32GetData = %d", s32Result);
               }
               else
               {
                  tU32 u32RAxis  = 0;
                  tU32 u32SAxis  = 0;
                  tU32 u32TAxis  = 0;
                  tU32 acc3dDataSize = oCompResp.Acc3dData.size();

                  dia_eAccStatus eRAxisStatus = DIA_EN_ACC_STATUS_UNKNOWN;
                  dia_eAccStatus eSAxisStatus = DIA_EN_ACC_STATUS_UNKNOWN;
                  dia_eAccStatus eTAxisStatus = DIA_EN_ACC_STATUS_UNKNOWN;

                  DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dAccStatus => Acc3dData.size = %d", acc3dDataSize);

                  if (acc3dDataSize>0)
                  {
                     tU32 i = acc3dDataSize - 1;

                     std::vector<sensor_fi_tcl_3dAccData, std::allocator<sensor_fi_tcl_3dAccData> >::reverse_iterator rit
                        = oCompResp.Acc3dData.rbegin();

                     for( ; rit!=oCompResp.Acc3dData.rend(); ++rit )
                     {
                        DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dAccStatus => Acc3dData[%d].TimeStamp3dAcc = %d, .RVal = %d, .SVal = %d, .TVal = %d",
                              i, (*rit).TimeStamp3dAcc, (*rit).RVal, (*rit).SVal, (*rit).TVal);

                        DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dAccStatus => Acc3dData[%d].RStatus = %d, .SStatus = %d, .TStatus = %d",
                              i, (*rit).RStatus.enType, (*rit).SStatus.enType, (*rit).TStatus.enType);

                        eRAxisStatus = dia_InternalAccStatusMapping[(*rit).RStatus.enType];
                        eSAxisStatus = dia_InternalAccStatusMapping[(*rit).SStatus.enType];
                        eTAxisStatus = dia_InternalAccStatusMapping[(*rit).TStatus.enType];

                        if (  ((*rit).RStatus.enType == sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_CONNECTED_NORMAL) &&
                              ((*rit).SStatus.enType == sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_CONNECTED_NORMAL) &&
                              ((*rit).TStatus.enType == sensor_fi_tcl_e16_AccStatus::FI_EN_ACCSTATE_CONNECTED_NORMAL))
                        {
                           u32RAxis = (*rit).RVal;
                           u32SAxis = (*rit).SVal;
                           u32TAxis = (*rit).TVal;
                           break;
                        }
                     }
                  }

                  pListener->vOnAccelerometer3DStatus(eRAxisStatus, eSAxisStatus, eTAxisStatus);
                  pListener->vOnAccelerometer3DGetResult(u32RAxis,u32SAxis,u32TAxis);
               }
#else
               cmb_sensorfi_tclMsgAcc3dDiagDataStatus oCompResp;

               (void) oResultMsg.s32GetData(oCompResp);

               tU32 u32XAxis  = oCompResp.x_axis;
               tU32 u32YAxis  = oCompResp.y_axis;
               tU32 u32ZAxis  = oCompResp.z_axis;

               pListener->vOnAccelerometer3DGetResult(u32XAxis,u32YAxis,u32ZAxis);
#endif
               break;
            }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

            case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dAccStatus => AMT_C_U8_CCAMSG_OPCODE_ERROR");
               pListener->vOnAccelerometer3DGetError(EN_ERROR_FATAL_INTERNAL);

               break;
            }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

            case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
            case AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT:
            default:
            {
               DIA_TR_ERR( "!!! dia_SAFeatureSensor::vHandleSensor3dAccStatus => ERROR: unsupported u8OpCode %x",u8OpCode);
               // unkown opcode: enter error handling here ( trace or assert )
               break;
            }
         }// switch (u8OpCode)
      }// if(pListener != OSAL_NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      poMessage->bDelete();
   }
}

void
dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus()");

   if(poMessage != NULL)
   {
      // Msg must come from a server
       DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

       // Extract the op code of the message called
       tU8 u8OpCode = poMessage->u8GetOpCode();

       dia_ISensorListener* pListener = OSAL_NULL;

       if((querySysAdapterListener<dia_ISensorListener>(&pListener) == DIA_SUCCESS) && (pListener != OSAL_NULL))
       {
          // Switch on the opCode received
          switch (u8OpCode)
          {
              case AMT_C_U8_CCAMSG_OPCODE_STATUS:
              {
                  DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => AMT_C_U8_CCAMSG_OPCODE_STATUS");

                  fi_tclVisitorMessage oResultMsg(poMessage);

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
                  sensor_locationfi_tclMsgGyro3dData_UpdateStatus oCompResp;
#else
                  cmb_sensorfi_tclMsgGyro3dData_UpdateStatus oCompResp;
#endif

                  tS32 s32Result = oResultMsg.s32GetData(oCompResp);

                  if (s32Result == OSAL_OK)
                  {
                     tU32 u32GyroRAxis  = 0;
                     tU32 u32GyroSAxis  = 0;
                     tU32 u32GyroTAxis  = 0;
                     size_t Gyro3dDataVectorSize = oCompResp.Gyro3dData.size();

                     dia_eGyroStatus eRAxisStatus = DIA_EN_GYRO_STATUS_UNKNOWN;
                     dia_eGyroStatus eSAxisStatus = DIA_EN_GYRO_STATUS_UNKNOWN;
                     dia_eGyroStatus eTAxisStatus = DIA_EN_GYRO_STATUS_UNKNOWN;

                     DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => Gyro3dData.size = %zu", Gyro3dDataVectorSize );

                     if (Gyro3dDataVectorSize>0)
                     {
                        size_t i = Gyro3dDataVectorSize - 1;

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
                        std::vector<sensor_fi_tcl_3dGyroData, std::allocator<sensor_fi_tcl_3dGyroData> >::reverse_iterator rit
#else
                        std::vector<cmb_fi_tcl_3dGyroData, std::allocator<cmb_fi_tcl_3dGyroData> >::reverse_iterator rit
#endif
                           = oCompResp.Gyro3dData.rbegin();

                        for( ; rit!=oCompResp.Gyro3dData.rend(); ++rit )
                        {
                           DIA_TR_INF( "dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => Gyro3dData[%zu].TimeStamp3dGyro=%d,RVal=%d,SVal=%d,TVal=%d",
                                 i, (*rit).TimeStamp3dGyro, (*rit).RVal, (*rit).SVal, (*rit).TVal);

                           DIA_TR_INF( "dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => Gyro3dData[%zu].RStatus = %d, .SStatus = %d, .TStatus = %d",
                                 i, (*rit).RStatus.enType, (*rit).SStatus.enType, (*rit).TStatus.enType);

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
                           eRAxisStatus = dia_InternalGyroStatusMapping[(*rit).RStatus.enType];
                           eSAxisStatus = dia_InternalGyroStatusMapping[(*rit).SStatus.enType];
                           eTAxisStatus = dia_InternalGyroStatusMapping[(*rit).TStatus.enType];

                           if (  ((*rit).RStatus.enType == sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL) &&
                                 ((*rit).SStatus.enType == sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL) &&
                                 ((*rit).TStatus.enType == sensor_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL))
#else
                           if (  ((*rit).RStatus.enType == cmb_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL) &&
                                 ((*rit).SStatus.enType == cmb_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL) &&
                                 ((*rit).TStatus.enType == cmb_fi_tcl_e16_GyroStatus::FI_EN_GYROSTATE_CONNECTED_NORMAL))
#endif
                           {
                              u32GyroRAxis = (*rit).RVal;
                              u32GyroSAxis = (*rit).SVal;
                              u32GyroTAxis = (*rit).TVal;
                              break;
                           }
                        }
                     }

                     pListener->vOnGyro3DStatus(eRAxisStatus, eSAxisStatus, eTAxisStatus);
                     pListener->vOnGyro3DGetResult(u32GyroRAxis,u32GyroSAxis,u32GyroTAxis);
                  }// if ( s32Result == OSAL_OK )
                  else
                  {
                     DIA_TR_ERR( "!!! dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => ERROR: oResultMsg.s32GetData() s32Result 0x%x",s32Result);
                  }
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

              case AMT_C_U8_CCAMSG_OPCODE_ERROR:
              {
                 DIA_TR_ERR( "--- dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => AMT_C_U8_CCAMSG_OPCODE_ERROR");
                 pListener->vOnGyro3DGetError(EN_ERROR_FATAL_INTERNAL);

                 break;
              }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

              case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
              case AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT:
              default:
              {
                 DIA_TR_ERR( "!!! dia_SAFeatureSensor::vHandleSensor3dGyroUpdateStatus => ERROR: unsupported u8OpCode %x",u8OpCode);
                 // unkown opcode: enter error handling here ( trace or assert )
                 break;
              }
          }// switch (u8OpCode)
       }// if(pListener != OSAL_NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      poMessage->bDelete();
   }
}

#if 0 //STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component

void
dia_SAFeatureSensor::vHandleSensorAntennaCurrent(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR3_THR(( "--> dia_SAFeatureSensor::vHandleSensorAntennaCurrent"));

   if(poMessage != NULL)
   {
      // Msg must come from a server
       DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

       // Extract the op code of the message called
       tU8 u8OpCode = poMessage->u8GetOpCode();

      dia_ISensorListener* pListener = OSAL_NULL;

       if ((querySysAdapterListener<dia_ISensorListener>(&pListener) == DIA_SUCCESS) && (pListener != OSAL_NULL))
       {
          // Switch on the opCode received
          switch (u8OpCode)
          {
              case AMT_C_U8_CCAMSG_OPCODE_STATUS:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSensor::vHandleSensorAntennaCurrent => AMT_C_U8_CCAMSG_OPCODE_STATUS"));

                  fi_tclVisitorMessage oResultMsg(poMessage);
                  cmb_sensorfi_tclMsgAntennaCurrentStatus oCompResp;

                  tS32 s32Result = oResultMsg.s32GetData(oCompResp);

                  if ( s32Result == OSAL_OK )
                  {
                     tU32 u32Current  = static_cast<tU32>(oCompResp.AntennaCurrent * 1000);
                     pListener->vOnGPSAntennaStatusGetResult(u32Current);
                  }
                  else
                  {
                     ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureSensor::vHandleSensorAntennaCurrent => ERROR: oResultMsg.s32GetData() s32Result 0x%x",s32Result));
                  }
                  break;
              }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

              case AMT_C_U8_CCAMSG_OPCODE_ERROR:
              {
                  ETG_TRACE_COMP_THR(( "--- dia_SAFeatureSensor::vHandleSensorAntennaCurrent => AMT_C_U8_CCAMSG_OPCODE_ERROR"));
                  pListener->vOnGPSAntennaStatusGetError(EN_ERROR_FATAL_INTERNAL);

                 break;
              }// case AMT_C_U8_CCAMSG_OPCODE_ERROR:

              case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
              case AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT:
              default:
              {
                  ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureSensor::vHandleSensorAntennaCurrent => ERROR: unsuported u8OpCode %x",u8OpCode));
                  // unkown opcode: enter error handling here ( trace or assert )
                  break;
              }
          }// switch (u8OpCode)
       }// if(pListener != OSAL_NULL)
   }// if(poMessage != NULL)

   if(poMessage != NULL)
   {
      poMessage->bDelete();
      poMessage = NULL;
   }

   ETG_TRACE_USR3_THR(( "<-- dia_SAFeatureSensor::vHandleSensorAntennaCurrent"));
}

#endif

#if 0 //STC2HI: Obsolete?

void
dia_SAFeatureSensor::vHandleGalaSpeed ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureSensor::vHandleGalaSpeed");
    tU8 u8OpCode = poMessage->u8GetOpCode();
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
            cmb_sensorfi_tclMsgGalaSpeedStatus oStatusMsgData;
            (void) oStatusMessage.s32GetData(oStatusMsgData);
            DIA_TR_INF(("dia_SAFeatureSensor::vHandleGalaSpeed - Received Gala Speed"));
            dia_ISensorListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_ISensorListener>(&pListener);
            if ( pListener )
            {
                pListener->vOnSensorSpeed((tU16) oStatusMsgData.Speed); // current speed in km/h
                pListener->vOnGalaCounter((tU16) oStatusMsgData.Speed); // current speed in km/h
                DIA_TR_INF("dia_SAFeatureSensor::vHandleGalaSpeed - speed (%f) forwarded to listener",oStatusMsgData.Speed);
            }
        }
        break;
    default:
        {
           DIA_TR_INF(("dia_SAFeatureSensor::vHandleGalaSpeed - Message with unhandled/unknown opcode received:"));
        }
        break;
    }
    (void) poMessage->bDelete();
}

#endif

//-----------------------------------------------------------------------------

void
dia_SAFeatureSensor::vHandleOdometerCount ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSensor::vHandleOdometerCount");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgOdometerData_UpdateStatus oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);
            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureSensor::vHandleOdometerCount => ERROR: s32GetData = %d", s32Result);
            }
            else
            {
               DIA_TR_INF("dia_SAFeatureSensor::vHandleOdometerCount - Receive OdometerData_Update.");

               dia_ISensorListener* pListener = 0;
               if ( (querySysAdapterListener<dia_ISensorListener>(&pListener) == DIA_SUCCESS) && pListener )
               {
                  tU16 u16OdometerCount = 0;
                  tU32 odometerDataSize = oStatusMsgData.OdometerData.size();

                  DIA_TR_INF("--- dia_SAFeatureSensor::vHandleOdometerCount => OdometerData.size = %d", odometerDataSize);

                  if (odometerDataSize>0)
                  {
                     tU32 i = odometerDataSize - 1;

                     std::vector<sensor_fi_tcl_OdometerData, std::allocator<sensor_fi_tcl_OdometerData> >::reverse_iterator rit
                        = oStatusMsgData.OdometerData.rbegin();

                     for( ; rit!=oStatusMsgData.OdometerData.rend(); ++rit )
                     {
                        DIA_TR_INF( "--- dia_SAFeatureSensor::vHandleOdometerCount => OdometerData[%d].Timestamp = %d, .Count = %d, .Status = %d, .Direction = %d",
                                    i, (*rit).Timestamp, (*rit).OdometerCount, (*rit).OdometerStatus.enType, (*rit).OdometerCount_Direction.enType);

                        if ((*rit).OdometerStatus.enType == sensor_fi_tcl_e8_OdometerStatus::FI_EN_ODOMSTATE_CONNECTED_NORMAL)
                        {
                           u16OdometerCount = (*rit).OdometerCount;
                           break;
                        }
                     }
                  }

                  pListener->vOnGalaCounter(u16OdometerCount);
               }
            }
#else
         cmb_sensorfi_tclMsgOdometerData_UpdateStatus oStatusMsgData;
         (void) oStatusMessage.s32GetData(oStatusMsgData);

         DIA_TR_INF("dia_SAFeatureSensor::vHandleOdometerCount - Receive OdometerData_Update.");

         dia_ISensorListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISensorListener>(&pListener);
         if ( pListener )
         {
            DIA_TR_INF("dia_SAFeatureSensor::vHandleOdometerCount - counter pos=%zu val=0x%x forwarded to listener",oStatusMsgData.OdometerData.size(),oStatusMsgData.OdometerData[oStatusMsgData.OdometerData.size()-1].OdometerCount);
            pListener->vOnGalaCounter((tU16) oStatusMsgData.OdometerData[oStatusMsgData.OdometerData.size()-1].OdometerCount);
         }
#endif
      }
      break;

      default:
      {
         DIA_TR_INF("dia_SAFeatureSensor::vHandleOdometerCount - Message with unhandled/unknown opcode received:");
      }
      break;
   }

   // Delete the message we are unable process it at this time
   (void) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSensor::vHandleGyroSelfTest ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureSensor::vHandleGyroSelfTest");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgGyroSelfTestMethodResult oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);

            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureSensor::vHandleGyroSelfTest => ERROR: %d", s32Result);
            }
            else
            {
               DIA_TR_INF(("dia_SAFeatureSensor::vHandleGyroSelfTest - Received gyro self test state"));
               DIA_TR_INF("gyro selftest result = %d",oStatusMsgData.bSuccess);

               dia_ISensorListener* pListener = 0;
               if ( (querySysAdapterListener<dia_ISensorListener>(&pListener) == DIA_SUCCESS) && pListener )
               {
                   DIA_TR_INF(("dia_SAFeatureSensor::vHandleGyroSelfTest - state forwarded to listener"));
                  if (oStatusMsgData.bSuccess == TRUE )
                  {
                     pListener->vOnGyroSelfTestDone((tDiaResult)DIA_SUCCESS);
                  }else {
                     pListener->vOnGyroSelfTestDone((tDiaResult)DIA_FAILED);
                  }
               }
            }
#endif
        }
        break;
    default:
        {
         DIA_TR_INF(("dia_SAFeatureSensor::vHandleGyroSelfTest - OpCode not ok"));
        }
        break;
    }

    // Delete the message we are unable process it at this time
    (void) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSensor::vHandleAccSelfTest ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureSensor::vHandleAccSelfTest");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgAccSelfTestMethodResult oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);

            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureSensor::vHandleAccSelfTest => ERROR: %d", s32Result);
            }
            else
            {
               DIA_TR_INF(("dia_SAFeatureSensor::vHandleAccSelfTest - Received acc self test state"));
               DIA_TR_INF("acc selftest result = %d",oStatusMsgData.bSuccess);

               dia_ISensorListener* pListener = 0;
               if ( (querySysAdapterListener<dia_ISensorListener>(&pListener) == DIA_SUCCESS) && pListener )
               {
                   DIA_TR_INF(("dia_SAFeatureSensor::vHandleAccSelfTest - state forwarded to listener"));
                  if (oStatusMsgData.bSuccess == TRUE )
                  {
                     pListener->vOnAccSelfTestDone((tDiaResult)DIA_SUCCESS);
                  }else {
                     pListener->vOnAccSelfTestDone((tDiaResult)DIA_FAILED);
                  }
               }
            }
#endif
        }
        break;
    default:
        {
         DIA_TR_INF(("dia_SAFeatureSensor::vHandleAccSelfTest - OpCode not ok"));
        }
        break;
    }

    // Delete the message we are unable process it at this time
    (void) poMessage->bDelete();
}

