/*
 * dia_SAFeatureRemoteControl.cpp
 *
 *  Created on: 11.01.2013
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#include "dia_SAFeatureRemoteControl.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureRemoteControl,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

//-----------------------------------------------------------------------------

dia_SAFeatureRemoteControl::dia_SAFeatureRemoteControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin )
   : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin),
     dia_RemoteControlPlugin(name),
     mDiagLibIOCtrlID(IOCONTROLID_DIAG_REMOTE_CONTROL)
{
   dia_tclFnctTrace trc("dia_SAFeatureRemoteControl::dia_SAFeatureRemoteControl");
}

//-----------------------------------------------------------------------------

dia_SAFeatureRemoteControl::~dia_SAFeatureRemoteControl ( tVoid )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRemoteControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(mDiagLibIOCtrlID);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureRemoteControl::requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings /*settings*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureRemoteControl::requestRemoteControlMode()");

   tDiaResult retCode = DIA_FAILED;

   if ( mode == DIA_EN_REMOTE_CONTROL_MODE_ACTIVE || mode == DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE )
   {
      // create and setup diaglib parameter
      trParameter paramRemCtrlMode;
      paramRemCtrlMode.enType  = static_cast<tenParameterType>(IOCONTROLID_DIAG_REMOTE_CONTROL_SET_PARAM1);
      paramRemCtrlMode.u8Value = ( mode == DIA_EN_REMOTE_CONTROL_MODE_ACTIVE ) ? 0x01 : 0x00;

      // add the diaglib parameter to the parameter vector
      tDiaglibParamVector vecRequest;
      vecRequest.push_back(paramRemCtrlMode);

      if ( dia_SAFeatureDiaglib::bIOControlStart(mDiagLibIOCtrlID, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureRemoteControl::requestRemoteControlMode - bIOControl - Start - SUCCESS.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureRemoteControl::requestRemoteControlMode - bIOControlStart - FAILED.");
      }
   }

  return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureRemoteControl::vOnIoCtrlResult ( tU32 ioctrlID, tenIoCtrlResult enResult, tenIoControlAction actionId, const tDiaglibParamVector& data )
{
   dia_tclFnctTrace trc("dia_SAFeatureRemoteControl::vOnIoCtrlResult()");

   switch ( actionId )
   {
   case EN_ACTION_SET:
      if ( enResult == EN_IO_CONTROL_OK )
      {
         const trParameter resultParam = data.at(0);
         if ( resultParam.enType == static_cast<tenParameterType>(IOCONTROLID_DIAG_REMOTE_CONTROL_SET_PARAM1) )
         {
            dia_eRemoteCtrlMode mode = ( resultParam.u8Value == 0x01 ) ? DIA_EN_REMOTE_CONTROL_MODE_ACTIVE : DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE;
            vOnRemoteControlUpdate(mode);
         }
      }
      else
      {
         DIA_TR_INF("##### FAILED TO ACTIVATE REMOTE CONTROL MODE (APP=0x%04x, DIAGLIBID=0x%08x) #####", mpSrvPlugin->getClientID(), ioctrlID );
      }
      break;

   case EN_ACTION_UNFREEZE:
      if ( enResult == EN_IO_CONTROL_OK )
      {
         vOnRemoteControlUpdate(DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE);
      }
      else
      {
         DIA_TR_INF("##### FAILED TO DEACTIVATE REMOTE CONTROL MODE (APP=0x%04x, DIAGLIBID=0x%08x) #####", mpSrvPlugin->getClientID(), ioctrlID );
      }
      break;

   default:
      if ( enResult != EN_IO_CONTROL_OK )
      {
         DIA_TR_INF("##### FAILED TO FREEZE REMOTE CONTROL MODE (APP=0x%04x, DIAGLIBID=0x%08x) #####", mpSrvPlugin->getClientID(), ioctrlID );
      }
      break;
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureRemoteControl::vHandleIOControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureRemoteControl::vHandleIOControl()");

   if ( poMessage )
   {
      dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );

      // we are done and it is safe to delete the CCA message now
      (tVoid) poMessage->bDelete();
   }
}
