/**
 * \file      dia_SAFeatureKDSEntry.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    abe6kor
 * \date      June 27, 2017
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef dia_SAFeatureKDSEntry_H_
#define dia_SAFeatureKDSEntry_H_


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#include "common/framework/config/dia_IKDS.h"
#endif

#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#define DIAGNOSTICS_S_IMPORT_INTERFACE_MSG
#include "fc_diagnosis_if.h"

#ifndef __INCLUDED_DIA_NATIVE_KDS_LISTENER_INTERFACE__
#include "common/framework/config/dia_IKDSListener.h"
#endif

#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"

struct TNotificationKds
{
	tU16 u16AppID;
	tU16 u16CmdCounter;
	tU16 u16RegisterID;
	tU32 u32CcaSubId;
};

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureKDSEntry
: public dia_SystemAdapterFeature,
  public dia_IKDSListener

{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureKDSEntry);
public:
	//! default class constructor
	dia_SAFeatureKDSEntry( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
	//! destructor
	virtual ~dia_SAFeatureKDSEntry ( void );

	//! direct read access to KDS
	virtual tVoid vOnKDSUpdate ( tU16 kdsKey, tU8 kdsData[], tU16 length );



protected:
	std::map<tU32,TNotificationKds> tMapKdsEntryNotify;

	//! handle the result of a message
	tVoid vHandleKdsEntryProperty ( amt_tclServiceData* poMessage );
	tVoid vSendKdsStatusEntry ( amt_tclServiceData* poMessage );
	tVoid vSendKdsStatusEntry ( const ahl_tNotification* pNot, tU32 u32KdsEntry );
	tVoid vSendKdsStatusEntry ( const ahl_tNotification* pNot, tU32 u32KdsEntry, const tU8 kdsData[], tU16 length );
	bool  bUpreg(amt_tclServiceData const* poMessage);
	bool  bRelUpreg(amt_tclServiceData const* poMessage);
	tVoid vSendError ( tU16 u16TargetID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16Fid );

	DECLARE_MSG_MAP(dia_SAFeatureKDSEntry)

private:
	diagnostics_tclApp* m_poGWMain;

	tVoid vNotifyAllClients(fi_tclTypeBase const&, tU16);
	tVoid vSendStatusMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
	tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8) const;


};

#endif /* dia_SAFeatureKDSEntry_H_ */
