/*
 * dia_SAFeatureKDSEntry.cpp
 *
 *  Created on: 27.06.2017
 *      Author: abe6kor
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef dia_SAFeatureKDSEntry_H_
#include "common/framework/sysadapters/dia_SAFeatureKDSEntry.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

BEGIN_MSG_MAP( dia_SAFeatureKDSEntry, dia_SystemAdapterFeature )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY, vHandleKdsEntryProperty)
END_MSG_MAP()


dia_SAFeatureKDSEntry::dia_SAFeatureKDSEntry (
		tCString name,    // feature name
		dia_SystemAdapterServicePlugin& pSrvPlugin
)
: dia_SystemAdapterFeature(name,pSrvPlugin)
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::dia_SAFeatureKDSEntry");
	m_poGWMain = diagnostics_tclApp::getInstance();
}

dia_SAFeatureKDSEntry::~dia_SAFeatureKDSEntry()
{}

bool
dia_SAFeatureKDSEntry::bUpreg(amt_tclServiceData const* poMessage)
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::bUpreg");

	if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

	tBool bRegOpStatus = FALSE;

	switch(poMessage->u16GetFunctionID())
	{
	case MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY:
	{
		fi_tclVisitorMessage oInVisitorMsg((amt_tclServiceData*) const_cast<amt_tclServiceData*>(poMessage));
		midw_diagnosticsfi_tclMsgKdsEntryUpReg oKdsEntryUpreg;
		(void) oInVisitorMsg.s32GetData(oKdsEntryUpreg);

		tU32 u32CcaKdsType = (tU32) oKdsEntryUpreg.KdsEntry;

		tU32 u32Key = ((tU32)poMessage->u16GetSourceAppID() << 16) | (0x0000FFFF & u32CcaKdsType);

		tMapKdsEntryNotify[u32Key].u16AppID      = poMessage->u16GetSourceAppID();
		tMapKdsEntryNotify[u32Key].u16CmdCounter = poMessage->u16GetCmdCounter();
		tMapKdsEntryNotify[u32Key].u16RegisterID = poMessage->u16GetRegisterID();
		tMapKdsEntryNotify[u32Key].u32CcaSubId   = u32CcaKdsType;

		dia_IKDS* pKDS = 0;
		if (queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS)
		{
			pKDS->addKDSListener((tU16) u32CcaKdsType,this);
		}

		bRegOpStatus = TRUE;
		break;
	}

	default:
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		// Add the client to notification table
		bRegOpStatus = m_poGWMain->m_poNotTable->bAddNotification (
				poMessage->u16GetFunctionID(),
				poMessage->u16GetSourceAppID(),
				poMessage->u16GetRegisterID(),
				1,
				poMessage->u16GetCmdCounter(),
				poMessage->u16GetSourceSubID());

		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
		break;
	}
	}

	return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//
// FUNCTION:   dia_SAFeatureKDSEntry::bRelUpreg
//
// DESCRIPTION:   Removes the sender of the message from the NotifcationTable
//
// PARAMETER:  Relupreg request message
//
// RETURNVALUE:   true  : Client dereqistration successful
//                false : Client deregistration failed
//
///////////////////////////////////////////////////////////////////////////
//
bool
dia_SAFeatureKDSEntry::bRelUpreg(amt_tclServiceData const* poMessage)
{
	//   vTraceSimple(I_DIA_HMI_RELUPREG_01);

	if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

	tBool bRegOpStatus = FALSE;
	if(MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY == poMessage->u16GetFunctionID())
	{
		fi_tclVisitorMessage oInVisitorMsg((amt_tclServiceData*) const_cast<amt_tclServiceData*>(poMessage));
		midw_diagnosticsfi_tclMsgKdsEntryRelUpReg oKdsEntryRelUpreg;
		(void) oInVisitorMsg.s32GetData(oKdsEntryRelUpreg);

		tU32 u32CcaKdsType = (tU32) oKdsEntryRelUpreg.KdsEntry;
		tU32 u32Key = ((tU32)poMessage->u16GetSourceAppID() << 16) | (0x0000FFFF & u32CcaKdsType);
		tMapKdsEntryNotify.erase(u32Key);

		dia_IKDS* pKDS = 0;
		if (queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS)
		{
			pKDS->removeKDSListener((tU16) u32CcaKdsType,this);
		}

		bRegOpStatus = TRUE;
	}
	return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureKDSEntry::vSendStatusMsg
//
//  DESCRIPTION: sends a CCA Status message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//

tVoid
dia_SAFeatureKDSEntry::vSendStatusMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData) const
{
	// Check the validity of incoming data
	if (NULL == poMessage) {
		return;
	}
	// initialise result message
	vSendMsg(poMessage, oFIData, AMT_C_U8_CCAMSG_OPCODE_STATUS);
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureKDSEntry::vSendMsg
//
//  DESCRIPTION: sends a CCA message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//                u8OpCode - CCA op code
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//
tVoid
dia_SAFeatureKDSEntry::vSendMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData, tU8 u8OpCode) const
{
	if (NULL == poMessage) {
		return;
	}
	// construct result message
	fi_tclVisitorMessage oResultMsg(oFIData);
	// initialise result message
	oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
			poMessage->u16GetSourceAppID(), // Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
			0, // StreamCounter
			poMessage->u16GetRegisterID(), // RegisterID
			poMessage->u16GetCmdCounter(), // nCmdCounter,
			DIA_USED_SRV_ID, // nServiceID,
			poMessage->u16GetFunctionID(), // function ID
			u8OpCode, AMT_C_U16_DEFAULT_NULL, poMessage->u16GetSourceSubID());
	// send it
	if (NULL != m_poGWMain) {
		if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR)
		{
			(tVoid) oResultMsg.bDelete();
		}
	}
}


tVoid
dia_SAFeatureKDSEntry::vOnKDSUpdate ( tU16 kdsKey, tU8 kdsData[], tU16 length )
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::vOnKDSUpdate()");

	DIA_TR_INF("INFORM REGISTERED LISTENERS ABOUT UPDATE OF KDS KEY 0x%04x", kdsKey);

	if ( tMapKdsEntryNotify.size() )
	{
		std::map<tU32,TNotificationKds>::iterator iter = tMapKdsEntryNotify.begin();
		for ( ; iter != tMapKdsEntryNotify.end(); iter++)
		{
			if ( kdsKey == ((tU16) iter->first) )
			{
				ahl_tNotification keyNotification;
				keyNotification.u16AppID = iter->second.u16AppID;
				keyNotification.u16RegisterID = iter->second.u16RegisterID;
				keyNotification.u16CmdCounter = iter->second.u16CmdCounter;
				vSendKdsStatusEntry(&keyNotification, iter->second.u32CcaSubId, kdsData, length);
			}
		}
	}
	else
	{
		DIA_TR_INF("NO KDS LISTENERS REGISTERED !!!");
	}
}

tVoid
dia_SAFeatureKDSEntry::vHandleKdsEntryProperty ( amt_tclServiceData* poMessage )
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::vHandleKdsEntryProperty()");

	if ( m_poGWMain )
	{
		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
		{
			if( !bUpreg(poMessage) )
			{
				// create and send error  message
				amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
				m_poGWMain->enPostMessage(&oErrorMessage);
			}
			else
			{

				if ( poMessage->u16GetFunctionID() == MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY )
				{
					vSendKdsStatusEntry(poMessage);
				}
			}
		}
		break;

		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: /* ---   upreg: unregister client  --- */
		{
			if( !bRelUpreg(poMessage) )
			{
				// create and send error  message
				amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
				m_poGWMain->enPostMessage(&oErrorMessage);
			}
		}
		break;

		case AMT_C_U8_CCAMSG_OPCODE_GET: /* --- the client asks for some data --- */
		{
			if ( poMessage->u16GetFunctionID() == MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY )
			{
				vSendKdsStatusEntry(poMessage);
			}
		}
		break;

		case AMT_C_U8_CCAMSG_OPCODE_SET: /* --- the client wants to set a value --- */
			break;

		default:
		{
			// create and send error  message
			amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_INVALID_OPCODE);
			m_poGWMain->enPostMessage(&oErrorMessage);
		}
		break;
		}
	}

	if ( poMessage ) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureKDSEntry::vSendKdsStatusEntry ( amt_tclServiceData* poMessage )
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::vSendKdsStatusEntry(poMessage)");

	if (m_poGWMain != NULL)
	{
		fi_tclVisitorMessage oInVisitorMsg(poMessage);
		midw_diagnosticsfi_tclMsgKdsEntryGet oKdsEntryGet;
		(void) oInVisitorMsg.s32GetData(oKdsEntryGet);

		tU32 u32CcaKdsType = (tU32) oKdsEntryGet.KdsEntry;

		ahl_tNotification notification;
		notification.u16AppID = poMessage->u16GetSourceAppID();
		notification.u16RegisterID = poMessage->u16GetRegisterID();
		notification.u16CmdCounter = poMessage->u16GetCmdCounter();
		notification.u16SubID = poMessage->u16GetSourceSubID();

		vSendKdsStatusEntry(&notification, u32CcaKdsType);
	}

}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureKDSEntry::vSendKdsStatusEntry ( const ahl_tNotification* pNot, tU32 u32KdsEntry )
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::vSendKdsStatusEntry(const ahl_tNotification*,tU32)");

	if (m_poGWMain != NULL)
	{
		midw_diagnosticsfi_tclMsgKdsEntryStatus  oMyData;

		// Reading Data from KDS
		tU32 u32CcaKdsType = u32KdsEntry;
		tU16 u16Entry      = (tU16)(0x0000ffff & u32CcaKdsType); //get lower 16bit
		tU8  ku8datalength = (tU8) (u32CcaKdsType >> 16); //get higher 16bit

		if ( !ku8datalength )
		{
			vSendError(pNot->u16AppID, pNot->u16RegisterID, pNot->u16CmdCounter, MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY);
			return;
		}

		tU8 au8KdsData[256] = {0};
		(tVoid) ::memset(au8KdsData, 0, 256);

		dia_IKDS* pKDS = 0;
		if (queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS)
		{
			DIA_TR_INF("dia_SAFeatureKDSEntry::vSendKdsStatusEntry - Trying to read KDS entry 0x%x with length 0x%x", u16Entry, ku8datalength);
			if (pKDS->readKDS(u16Entry, au8KdsData, ku8datalength) == DIA_SUCCESS)
			{
				DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest - Start reading Data.");

				for ( tU8 i=0; i<ku8datalength; i++ ) {
					oMyData.KdsDataList.itemList.push_back(au8KdsData[i]);
				}
				oMyData.KdsEntry = u32CcaKdsType;

				//Create some sender message.
				fi_tclVisitorMessage oMyStatusMessage(oMyData);

				//Now add targetting data
				oMyStatusMessage.vInitServiceData(
						CCA_C_U16_APP_DIAGDEBUG,
						pNot->u16AppID,
						AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
						0,                                  // StreamCounter
						pNot->u16RegisterID ,
						pNot->u16CmdCounter,
						CCA_C_U16_SRV_DIAGDEBUG,
						MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY,
						AMT_C_U8_CCAMSG_OPCODE_STATUS
				);

				// Reply to requester
				if( AIL_EN_N_NO_ERROR != m_poGWMain->enPostMessage(&oMyStatusMessage))
				{
					// Error in sending the message
					if (!oMyStatusMessage.bDelete())
					{
						// Error in deleting the message
					}
				}
			}
			else
			{
				vSendError(pNot->u16AppID,pNot->u16RegisterID,pNot->u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY);
			}
		}
		else
		{
			DIA_TR_ERR("dia_SrvHandler_ReadDataByMemory::vProcessRequest - Requesting ConfigManager queryConfMgrInterface FAILED.");
			vSendError(pNot->u16AppID,pNot->u16RegisterID,pNot->u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY);
		}
	}
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureKDSEntry::vSendKdsStatusEntry ( const ahl_tNotification* pNot, tU32 u32KdsEntry, const tU8 kdsData[], tU16 length )
{
	dia_tclFnctTrace trc("dia_SAFeatureKDSEntry::vSendKdsStatusEntry(const ahl_tNotification*,tU32, tU8[], tU16)");

	if (m_poGWMain != NULL)
	{
		midw_diagnosticsfi_tclMsgKdsEntryStatus  oMyData;

		// Reading Data from KDS
		tU32 u32CcaKdsType = u32KdsEntry;
		tU8  ku8datalength = (tU8) (u32CcaKdsType >> 16); //get higher 16bit

		if ( !ku8datalength )
		{
			vSendError(pNot->u16AppID, pNot->u16RegisterID, pNot->u16CmdCounter, MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY);
			return;
		}

		if ( length == ku8datalength )
		{
			for ( tU8 i=0; i<length; i++ ) oMyData.KdsDataList.itemList.push_back(kdsData[i]);
		}
		oMyData.KdsEntry = u32CcaKdsType;

		//Create some sender message.
		fi_tclVisitorMessage oMyStatusMessage(oMyData);

		//Now add targetting data
		oMyStatusMessage.vInitServiceData(
				CCA_C_U16_APP_DIAGDEBUG,
				pNot->u16AppID,
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
				0,                                  // StreamCounter
				pNot->u16RegisterID ,
				pNot->u16CmdCounter,
				CCA_C_U16_SRV_DIAGDEBUG,
				MIDW_DIAGNOSTICSFI_C_U16_KDSENTRY,
				AMT_C_U8_CCAMSG_OPCODE_STATUS
		);

		// Reply to requester
		if( AIL_EN_N_NO_ERROR != m_poGWMain->enPostMessage(&oMyStatusMessage))
		{
			// Error in sending the message
			if (!oMyStatusMessage.bDelete())
			{
				// Error in deleting the message
			}
		}
	}
}


tVoid dia_SAFeatureKDSEntry::vSendError (
		tU16 u16TargetID,
		tU16 u16RegisterID,
		tU16 u16CmdCounter,
		tU16 u16Fid
)
{
	if ( m_poGWMain )
	{
		gm_tclU8Message oErrorMsg (
				CCA_C_U16_APP_DIAGDEBUG,
				u16TargetID,
				u16RegisterID,
				u16CmdCounter,
				CCA_C_U16_SRV_DIAGDEBUG,
				u16Fid,
				AMT_C_U8_CCAMSG_OPCODE_ERROR
		);
		m_poGWMain->enPostMessage(&oErrorMsg);
	}
}

tVoid
dia_SAFeatureKDSEntry::vNotifyAllClients(fi_tclTypeBase const& oFIData, tU16 u16FuncId)
{
	DIA_TR_INF(("--> dia_SAFeatureKDSEntry::vNotifyAllClients"));

	//potclService->vUpdateAllClients(oFIData, u16FuncId);

	if (m_poGWMain && m_poGWMain->m_poNotTable)
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		m_poGWMain->m_poNotTable->vTraceTable(TR_CLASS_DIAGNOSTICS_BASE);

		// Run through the table to find all registered clients
		ahl_tNotification* pNot = m_poGWMain->m_poNotTable->poGetNotificationList(u16FuncId);

		DIA_TR_INF("--> dia_SAFeatureKDSEntry::vNotifyAllClients pNot %p",pNot);

		for (; pNot != OSAL_NULL; pNot = pNot->pNext) {
			// construct result message
			fi_tclVisitorMessage oResultMsg(oFIData);
			// initialise result message
			oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
					pNot->u16AppID, // Target
					AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
					0, // StreamCounter
					pNot->u16RegisterID, // RegisterID
					pNot->u16CmdCounter, // nCmdCounter,
					DIA_USED_SRV_ID, // nServiceID,
					u16FuncId, // function ID
					AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL, pNot->u16SubID);


			// send it
			//vTraceSimple(I_DIA_HMI_UPDATEALLCLIENTS_03);
			if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR) {
				(tVoid) oResultMsg.bDelete();
			}
		}
		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}
	else
	{
		DIA_TR_INF(("!!! dia_SAFeatureKDSEntry::vNotifyAllClients => ERROR: Null pointer - m_poGWMain or m_poNotTable"));
	}
	DIA_TR_INF(("<-- dia_SAFeatureKDSEntry::vNotifyAllClients"));
}


