////////////////////////////////////////////////////////////////////////////////
//
// FILE:         dia_SAFeatureIPOD.h
// PROJECT:
// SW-COMPONENT:
//
//------------------------------------------------------------------------------
//
// DESCRIPTION: Header File for IPOD system adapter
//
//------------------------------------------------------------------------------
//
// COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author             | Modification
// 15.10.08  | gib2hi             | initial version
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _DIA_SYSTEM_ADAPTER_IPOD_H_
#define _DIA_SYSTEM_ADAPTER_IPOD_H_

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAIPOD_LISTENER__
#include <common/interfaces/dia_IMediaIPODListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibDiagnosisDataListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "dia_SystemAdapterFeatureDiaglib.h"
#endif

class dia_SAFeatureIPOD
    : public dia_SystemAdapterFeatureDiaglib,
      public dia_IMediaIPOD,
      public dia_IDiaglibRoutineControlListener,
      public dia_IDiaglibDiagnosisDataListener
{
public:
    //! class constructor
    dia_SAFeatureIPOD ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );
    //! class destructor
    virtual ~dia_SAFeatureIPOD ( tVoid );

    //! return the diaglib IDs managed by this feature
    virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

    //
    // implementation of the dia_IMediaIPOD interface
    //
    virtual tDiaResult vSelfTest ( tVoid );
    virtual tDiaResult vGetVersion ( tVoid );

    virtual tVoid vOnRoutineCtrlResult ( tU32 u32RoutineId,
                                         tenRoutineCtrlResult enRoutineStatus, 
                                         const tDiaglibParamVector& oStartResult);

    virtual tVoid vOnDiagnosisDataResult (
                                          tU32 u32DiagnosisDataId,
                                          tenDiagDataResult enResult,
                                          const tDiaglibParamVector& oResult
                                        );

    virtual tVoid vOnGetRoutineResult ( tU32 ,
                                        tenRoutineCtrlResult , 
                                        const tDiaglibParamVector& ){};


protected:

    //! deprecated default constructor
    dia_SAFeatureIPOD ( tVoid );

    //! handle the result of a defset message
    tVoid vHandleRoutineControl ( amt_tclServiceData* poMessage );
    tVoid vHandleDiagnosisData ( amt_tclServiceData* poMessage ) ;

protected:
    // declare message map data structures
    DECLARE_MSG_MAP(dia_SAFeatureIPOD)
};

#endif
