/*
 * dia_SAFeatureErrorLog.h
 *
 *  Created on: 09.01.2012
 *      Author: gib2hi
 */

#ifndef DIA_SAFEATUREERRORLOG_H_
#define DIA_SAFEATUREERRORLOG_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#include <midw_fi_if.h> //lint !e451 !e537 repeatedly included header file without standard include guard

using namespace std;

#define DIAGLOG_CH_LOCKED_WRITE_MP_DTC          (DIA_DRV_TEST_ROUTINE_MAX + 1) // DiagLog CL locked while writing microphone failure DTCs

class dia_ErrorLogConfiguration
{
public:
   dia_ErrorLogConfiguration(): activeDTCListSupport(false){}
   dia_ErrorLogConfiguration(bool activeDTCList): activeDTCListSupport(activeDTCList){}
private:
   bool  activeDTCListSupport;
public:
   bool isActiveDTCListSupported() const {return activeDTCListSupport;}
   void setActiveDTCListSupported(bool b)  {activeDTCListSupport = b;}
};
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureErrorLog
   : public dia_SystemAdapterFeature,
     public dia_IErrorLog
{
public:
   // constructor
   dia_SAFeatureErrorLog ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   // destructor
   virtual ~dia_SAFeatureErrorLog();
   void  setConfiguration(dia_ErrorLogConfiguration const& cfg) {this->config = cfg;};
   //
   // Implementation for the dia_IErrorLog methods
   //
   virtual tDiaResult u32TestDTCStart ( const tU8* au8TestResultData );
   //! New common diagnostics in Gen3g
   virtual tDiaResult clearDTC ( tU8 u8Group, tU32 u32GroupOfDtc );
   virtual tDiaResult getStatusByDTC ( tU8 u8Group, tU32 u32DTCMask );
   virtual tDiaResult getStatusByITC ( tU8 u8Group, tU32 u32ITCMask );
   virtual tDiaResult getDTCbyStatusMask ( tU8 u8Group, tU8 u8Mask );
   virtual tDiaResult getNumberOfDTCbyStatusMask ( tU8 u8Group, tU8 u8Mask );
   virtual tDiaResult getSupportedDTC ( tU8 u8Group );
   virtual tDiaResult getLastConfirmedDTC ( tU8 u8Group );
   virtual tDiaResult getExtendedData ( tU8 group, tU32 dtc, tU8 recordNumber );
   virtual tDiaResult getSnapShotId ( tU8 group);
   virtual tDiaResult getSnapShotData ( tU8 group, tU32 dtc , tU8 recordNumber);
   //! report the test result for the given ITC
   virtual tDiaResult reportTestResult ( tU16 u16Itc, dia_enTestResult status );
   //! report the test results for the list of given ITCs
   virtual tDiaResult reportTestResults ( const std::map<tU16,dia_enTestResult>& testResults );
   virtual tDiaResult controlDTCSetting(const dia_tenControlType eMode);
   virtual tDiaResult startMonitoring(tVoid);
   virtual tDiaResult getItcInformation ( tU8 u8Group, const std::vector<tU16>& ItcList );
   virtual tDiaResult registerForActiveDtc ( void );
   virtual tDiaResult unregisterForActiveDtc ( void );

private:
   void handleActiveDTCStatus(amt_tclServiceData* poMessage, dia_IErrorLogListener* pListener) const;
   dia_ErrorLogConfiguration  config;
protected:
   //! deprecated default constructor
   dia_SAFeatureErrorLog ( void );

   //result handle function to react on result messages for save DTC
   void vHandleTestResult(amt_tclServiceData* poMessage) const;
   //result handle function to react on result messages for Control DTC
   void vHandleControlResult(amt_tclServiceData* poMessage) const;

   //result handle function to react on result messages for clear DTC
   void vHandleClearResult(amt_tclServiceData* poMessage) const;
   void vHandleReadDTCbyStatusMaskResult(amt_tclServiceData* poMessage) const;
   void vHandleReadStatusByDTCResult(amt_tclServiceData* poMessage) const;
   void vHandleReadStatusByITCResult(amt_tclServiceData* poMessage) const;
   void vHandleReadNumberOfDTCbyStatusMaskResult(amt_tclServiceData* poMessage) const;
   void vHandleReadSupportedDTCResult(amt_tclServiceData* poMessage) const;
   void vHandleReadLastConfirmedDTCResult(amt_tclServiceData* poMessage) const;
   void vHandleGetExtendedDataByDTCResult(amt_tclServiceData* poMessage) const;
   void vHandleSendNextTestResult ( amt_tclServiceData* poMessage ) const;
   void vHandleGetItcInformationResult ( amt_tclServiceData* poMessage ) const;
   void vHandleSnapShotIdResult ( amt_tclServiceData* poMessage ) const;
   void vHandleSnapShotDataResult ( amt_tclServiceData* poMessage ) const;
   void vHandleActiveDTCListResult(amt_tclServiceData* poMessage) const;
protected:
   static const midw_fi_tcl_e8_TestResult::tenType mTestResultMapping[];

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureErrorLog)
};

#endif /* DIA_SAFEATUREERRORLOG_H_ */
