/*
 * dia_SAFeatureDiagInternalRequest.cpp
 *
 *  Created on: 17.08.2017
 *      Author: stc2hi
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INTERNALTESTER__
#include <common/interfaces/dia_IInternalTester.h>
#endif

#ifndef __INCLUDED_DIA_SA_FEATURE_DIAG_INTERNAL_REQUEST__
#include "common/framework/sysadapters/dia_SAFeatureDiagInternalRequest.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_TYPES
//#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


BEGIN_MSG_MAP( dia_SAFeatureDiagInternalRequest, dia_SystemAdapterFeature )
   ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST, vHandleDiagnosisRequest)
END_MSG_MAP()

//-----------------------------------------------------------------------------

dia_SAFeatureDiagInternalRequest::dia_SAFeatureDiagInternalRequest (tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin)
   : dia_SystemAdapterFeature(name,pSrvPlugin),
     m_u16ClientAppID(0),
     m_u16ClientSubAppID(0),
     m_u16RegisterID(0),
     m_u8ProtocolId(0),
     m_u16CmdCounter(0),
     m_u16SubID(0)
{
	dia_tclFnctTrace trc("dia_SAFeatureDiagInternalRequest::dia_SAFeatureDiagInternalRequest");
}

//-----------------------------------------------------------------------------

dia_SAFeatureDiagInternalRequest::~dia_SAFeatureDiagInternalRequest()
{}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDiagInternalRequest::vHandleDiagnosisRequest ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiagInternalRequest::vHandleDiagnosisRequest()");

   // Msg must come from a client
   OSAL_vAssert(poMessage->bIsServerMessage() == FALSE);

   // the opcode tells what we should do
   switch ( poMessage->u8GetOpCode() )
   {
      case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      case AMT_C_U8_CCAMSG_OPCODE_GET:
      case AMT_C_U8_CCAMSG_OPCODE_SET:
         {
            // create and send error  message
            amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
            if ( mpSrvPlugin->bTransmitMessage(&oErrorMessage) == TRUE ) {
            	DIA_TR_INF("dia_SAFeatureDiagInternalRequest::vHandleDiagnosisRequest() - transmitMessage success.");
            }
            else {
            	DIA_TR_ERR("dia_SAFeatureDiagInternalRequest::vHandleDiagnosisRequest() - transmitMessage failed.");
            }
         }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         {
            fi_tclVisitorMessage oMsg(poMessage);
            midw_diagnosticsfi_tclMsgDiagRequestMethodStart oRequestData;
            (tVoid) oMsg.s32GetData(oRequestData);

            // save info for reply (tbd: refactor to be able to support multiple clients -> require setup of lookup table)
            m_u16ClientAppID    = poMessage->u16GetSourceAppID();
            m_u16ClientSubAppID = poMessage->u16GetSourceSubID();
            m_u16RegisterID     = poMessage->u16GetRegisterID();
            m_u16CmdCounter     = poMessage->u16GetCmdCounter();
            m_u16SubID          = poMessage->u16GetSourceSubID();

            dia_IInternalTester* pInterface = OSAL_NULL;
            if ( (querySysAdapterInterface<dia_IInternalTester>(&pInterface) == DIA_SUCCESS) && pInterface )
            {
               // tbd: check protID

               if ( pInterface->processInternalTesterRequest(oRequestData.diagData.itemList,*this, (tCookieType)oRequestData.cookie) != DIA_SUCCESS )
               {
                  DIA_TR_ERR("FAILED TO FORWARD MESSAGE TO INTERNAL TESTER");
               }
            }
            else
            {
               // create and send error  message
               amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_INTERNAL_FAILURE);
               if ( mpSrvPlugin->bTransmitMessage(&oErrorMessage) == TRUE ) {
            	   DIA_TR_INF("dia_SAFeatureDiagInternalRequest::vHandleDiagnosisRequest() - transmitMessage success.");
               }
               else {
            	   DIA_TR_ERR("dia_SAFeatureDiagInternalRequest::vHandleDiagnosisRequest() - transmitMessage failed.");
               }
            }
         }
         break;

      default:
         // unkown opcode: just delete message
         break;
   }

   (void) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDiagInternalRequest::onInternalTesterResponse ( std::vector<tU8>& response, tCookieType cookie )
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagInternalRequest::onInternalTesterResponse");

   // create result object

   midw_diagnosticsfi_tclMsgDiagRequestMethodResult oResultData;
   oResultData.protID.enType = midw_fi_tcl_DiagProtocol::FI_EN_UDS;
   oResultData.diagData.itemList = response;
   oResultData.cookie = (tU32)dia::VoidCast<tU32>(cookie);

   fi_tclVisitorMessage oResultMsg(oResultData);
   oResultMsg.vInitServiceData (
         CCA_C_U16_APP_DIAGDEBUG,               // source
         m_u16ClientAppID,                      // Target
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
         0,                                     // StreamCounter
         m_u16RegisterID,                       // RegisterID
         m_u16CmdCounter,                       // nCmdCounter,
         CCA_C_U16_SRV_DIAGDEBUG,               // nServiceID,
         MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST,
         AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
         AMT_C_U16_DEFAULT_NULL,
         m_u16SubID
         );

   if ( mpSrvPlugin->bTransmitMessage(&oResultMsg) == TRUE )
   {
      DIA_TR_INF("ddia_SAFeatureDiagInternalRequest::onInternalTesterResponse - transmitMessage success.");
   }
   else
   {
      DIA_TR_ERR("ddia_SAFeatureDiagInternalRequest::onInternalTesterResponse - transmitMessage failed.");
      (void) oResultMsg.bDelete();
   }
}

