/*
 * dia_SAFeatureDefaultSettingsCompatible.cpp
 *
 *  Created on: 27.09.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__
#include <common/framework/sysadapters/dia_SystemAdapterServicePlugin.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#include "dia_SAFeatureDefaultSettingsCompatible.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP( dia_SAFeatureDefaultSettingsCompatible, dia_SystemAdapterFeature )
//    ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_SETFACTORYSETTINGSSTATUS,    vHandleDefsetMessage)
//    ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_SETFACTORYSETTINGS,          vHandleDefsetMessage)
END_MSG_MAP()

midw_fi_tcl_e8_DefSetMode::tenType convertToDefSetType ( dia_UID sysSetTypeUID );

//-----------------------------------------------------------------------------

dia_SAFeatureDefaultSettingsCompatible::dia_SAFeatureDefaultSettingsCompatible (
      tCString name,
      tU32 u32SystemSetId,
      tU32 u32SystemSetTypes,
      dia_SystemAdapterServicePlugin& pSrvPlugin,
      tU8  defsetGroup,
      tU16 u16MethodFunctionId,
      tU16 u16PropertyFunctionId
   )
   : dia_SystemAdapterFeature(name,pSrvPlugin),
     dia_SystemSettingsModule(name,u32SystemSetTypes),
     mSystemSettingTypeUID(0),
     mu32SystemSetId(u32SystemSetId),
     mu32SystemSetTypes(u32SystemSetTypes),
     mu8DefsetGroup(defsetGroup),
     mu16MethodFid(u16MethodFunctionId),
     mu16PropertyFid(u16PropertyFunctionId)
{
    //dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::dia_SAFeatureDefaultSettingsCompatible()"); // akn1kor:- procdiagnosis start up issue in G3G
}

//-----------------------------------------------------------------------------

dia_SAFeatureDefaultSettingsCompatible::~dia_SAFeatureDefaultSettingsCompatible ( void )
{}

//-----------------------------------------------------------------------------

//tU32
//dia_SAFeatureDefaultSettingsCompatible::u32GetSystemSetID()
//{
//   return mu32SystemSetId;
//}

//-----------------------------------------------------------------------------

//tVoid
//dia_SAFeatureDefaultSettingsCompatible::vHandleDefsetMessage ( amt_tclServiceData* poMessage )
//{
//    dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::vHandleDefsetMessage()");
//
//    if ( !poMessage ) return;
//
//    tU16 u16FuncId = poMessage->u16GetFunctionID();
//
//    if ( u16FuncId == mu16MethodFid )
//    {
//        vEvalMethodResponse(poMessage);
//    }
//    else if ( u16FuncId == mu16PropertyFid )
//    {
//        vEvalPropertyResponse(poMessage);
//    }
//    else
//    {
//    }
//}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDefaultSettingsCompatible::prepareSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::prepareSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("Prepare system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) )
   {
      if ( 0xFFFF != mu16PropertyFid )
      {
         // method/property based communication model used, therefore we need to register for the property
         if ( mpSrvPlugin != OSAL_NULL)
         {
            retCode = (mpSrvPlugin->bRegisterForFID(mu16PropertyFid) == TRUE) ? DIA_SUCCESS : DIA_FAILED;
         }
         else
         {
            DIA_ASSERT_ALWAYS();
         }
      }
      else
      {
         DIA_TR_INF("NO PREPARATION REQUIRED FOR SYSTEM SETTING !!!");
         getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,DIA_SUCCESS);
      }
   }
   else
   {
      DIA_TR_INF("System setting type is not supported !!!");
      //EM_TRACE Entry
      DIA_TR_ERRMEM("Prepare system setting (module = \"%s\")",getName());
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,DIA_SUCCESS);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDefaultSettingsCompatible::executeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::executeSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("Execute system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) )
   {
      retCode = ( bSendMethodStart(typeUID) ) ? DIA_SUCCESS : DIA_FAILED;
   }
   else
   {
      DIA_TR_INF("System setting type is not supported !!!");
      //EM_TRACE Entry
      DIA_TR_ERRMEM("Execute system setting (module = \"%s\")",getName());
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_SUCCESS);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDefaultSettingsCompatible::finalizeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/  )
{
   dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::finalizeSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("Finalize system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) )
   {
      if ( 0xFFFF != mu16PropertyFid )
      {
         // method/property based communication model used, therefore we need to register for the property
         if ( mpSrvPlugin != OSAL_NULL)
         {
            retCode = (mpSrvPlugin->bUnregisterForFID(mu16PropertyFid) == TRUE) ? DIA_SUCCESS : DIA_FAILED;
         }
         else
         {
            DIA_TR_INF("NO FINALIZATION REQUIRED FOR SYSTEM SETTING !!!");
            getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,DIA_SUCCESS);
         }
      }
   }
   else
   {
      DIA_TR_INF("System setting type is not supported !!!");
      //EM_TRACE Entry
      DIA_TR_ERRMEM("Finalize system setting (module = \"%s\")",getName());
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,DIA_SUCCESS);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

void
dia_SAFeatureDefaultSettingsCompatible::vEvalMethodResponse ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::vEvalMethodResponse()");

   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch ( u8OpCode )
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         if ( 0xFFFF == mu16PropertyFid )
         {
            gm_tclStreamMessage oStream(poMessage);
            const tChar* pData = oStream.pcocGetData();
            tU32 dataLength = oStream.u32GetDataSize();

            DIA_TR_INF("--- STREAM LENGTH = %d", dataLength);

            if ( dataLength > 2 )
            {
               if ( pData[2] == 0x01 ) // TRUE
               {
                  DIA_TR_INF("--- DEFSET SUCCESSFULLY PERFORMED (TRUE) !!!");
                  getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_SUCCESS);
               }
               else
               {
                  DIA_TR_INF("--- DEFSET FAILED !!!");
                  getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_E_SYSSET_INVALID_TYPE);
               }
            }
            else
            {
               if ( pData[1] == 0x00 ) // DEFSET_STATE_CONFIRMED
               {
                  DIA_TR_INF("--- DEFSET SUCCESSFULLY PERFORMED (DEFSET_STATE_CONFIRMED) !!!");
                  getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_SUCCESS);
               }
               else
               {
                  DIA_TR_INF("--- DEFSET NOT CONFIRMED !!!");
                  getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_E_SYSSET_INVALID_TYPE);
               }
            }
         }
         else
         {
         }
      }
      break;

   default:
      {
         DIA_TR_INF("dia_SAFeatureDefaultSettingsCompatible::vHandleConfiguration: Unexpected OpCode = %d", u8OpCode);
         DIA_ASSERT_ALWAYS();
         (tVoid) poMessage->bDelete();
      }
      break;
   }
}

//-----------------------------------------------------------------------------

//DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,
//DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,
//DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,

void
dia_SAFeatureDefaultSettingsCompatible::vEvalPropertyResponse ( amt_tclServiceData* poMessage )
{
    dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::vEvalPropertyResponse()");

    tU8 u8OpCode = poMessage->u8GetOpCode();

    switch ( u8OpCode )
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            DIA_TR_INF("--- OPCODE = AMT_C_U8_CCAMSG_OPCODE_STATUS");

            // Get method result data into fi type
            fi_tclVisitorMessage oMsg(poMessage);
            midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus oPropertyData;
            (tVoid) oMsg.s32GetData(oPropertyData);

            DIA_TR_INF("--- DefSetStateMode = %d", oPropertyData.DefSetStateMode.enType);

            switch (oPropertyData.DefSetStateMode.enType)
            {
            case midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_UPREG:
               DIA_TR_INF("--- DefSetStateMode = FI_EN_DEFSET_SRC_UPREG");
               getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,DIA_SUCCESS);
               break;

            case midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_RELUPREG:
               DIA_TR_INF("--- DefSetStateMode = FI_EN_DEFSET_SRC_RELUPREG");
               getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,DIA_SUCCESS);
               break;

            case midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_USER:
            case midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_TEF:
            case midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_GET:
               {
                  DIA_TR_INF("--- DefSetStateMode = FI_EN_DEFSET_SRC_SET_USER|FI_EN_DEFSET_SRC_SET_TEF|FI_EN_DEFSET_SRC_GET");

                  if ( oPropertyData.DefSetStateSuccessful == TRUE )
                  {
                     DIA_TR_INF("--- DefSetStateSuccessful == TRUE");
                     getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_SUCCESS);
                  }
                  else
                  {
                     DIA_TR_INF("--- DefSetStateSuccessful != TRUE");
                     getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_E_SYSSET_INVALID_TYPE);
                  }
               }
               break;

            default:
               break;
            } //lint !e788: not all items of oPropertyData.DefSetStateMode.enType used within defaulted switch
        }
        break;

    default:
        {
            DIA_TR_INF( "dia_SAFeatureDefaultSettingsCompatible::vHandleConfiguration: Unexpected OpCode = %d",u8OpCode);
            NORMAL_M_ASSERT_ALWAYS();
            (tVoid) poMessage->bDelete();
        }
        break;
    }
}

//-----------------------------------------------------------------------------

bool
dia_SAFeatureDefaultSettingsCompatible::bSendMethodStart ( dia_UID sysSetTypeUID )
{
    dia_tclFnctTrace trc("dia_SAFeatureDefaultSettingsCompatible::bSendMethodStart()");

    bool bRetVal = false;

    if(OSAL_NULL != mpSrvPlugin)
    {
        midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart oMethodStart;

        oMethodStart.DefSetStateGroup = mu8DefsetGroup; //u8ConvertToDefSetGroup(mu32SystemSetId);

        oMethodStart.DefSetStateMode.enType = convertToDefSetType(sysSetTypeUID);

        fi_tclVisitorMessage oResultMsg(oMethodStart);

        mpSrvPlugin->vInitServiceData(oResultMsg, mu16MethodFid, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
        bRetVal = ( mpSrvPlugin->bTransmitMessage(&oResultMsg) == TRUE ) ? true : false;
    }

    return bRetVal;
}

//-----------------------------------------------------------------------------

midw_fi_tcl_e8_DefSetMode::tenType
convertToDefSetType ( dia_UID sysSetTypeUID )
{
    midw_fi_tcl_e8_DefSetMode::tenType enReturn = midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_NOT_DEF;

    switch ( sysSetTypeUID )
    {
        case DIA_C_UID_SYSTEM_SETTING_TYPE_HMI:
            enReturn = midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_USER;
            break;
        case DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION:
            enReturn = midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_TEF;
            break;
        case DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT:
            enReturn = midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CODING;
            break;
        case DIA_C_UID_SYSTEM_SETTING_TYPE_CALIBRATION:
            enReturn = midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CALIBRATION;
            break;
        default:
            enReturn = midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_NOT_DEF;
            DIA_TR_INF("##### SYSTEM SETTING TYPE 0x%08x NOT SUPPORTED BY MIDDLEWARE DIAGNOSTICS CCA FI !!! #####", sysSetTypeUID);
            NORMAL_M_ASSERT_ALWAYS();
            break;
    } //lint !e788: intentionally not all items used within defaulted switch

    return enReturn;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDefaultSettingsCompatible::getFunctionIDs ( std::list<tU16>& results ) const
{
   results.push_back(mu16MethodFid);
   if ( mu16PropertyFid != 0xFFFF )
   {
      results.push_back(mu16PropertyFid);
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDefaultSettingsCompatible::dispatchMessage ( amt_tclBaseMessage *pMessage )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDefaultSettingsCompatible::vDispatchMessage");

   tDiaResult retCode = DIA_FAILED;

   // check if the received message is a AMT Service data message
   if ( pMessage && (pMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA) )
   {
      // cast the received message to a AMT Service data message so we can
      // access the standard members
      amt_tclServiceData oServiceData(pMessage);

      tU16 u16FunctionID = oServiceData.u16GetFunctionID();

      if ( u16FunctionID == mu16MethodFid )
      {
          vEvalMethodResponse(&oServiceData);
          retCode = DIA_SUCCESS;
      }
      else if ( u16FunctionID == mu16PropertyFid )
      {
          vEvalPropertyResponse(&oServiceData);
          retCode = DIA_SUCCESS;
      }
      else
      {
      }
   }

   return retCode;
}
