/*
 * dia_SAFeatureBTDeviceList.h
 *
 *  Created on: April 06, 2015
 *      Author: Bharath Kumar Yellikanti (RBEI/ECA4)
 */

#ifndef __INCLUDED_DIA_SAFEATUREBTDEVICELIST_H__
#define __INCLUDED_DIA_SAFEATUREBTDEVICELIST_H__

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BTDEVICELIST_LISTENER__
#include <common/interfaces/dia_IBTDeviceListListener.h>
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureBTDeviceList
   : public dia_SystemAdapterFeature,
     public dia_IBTDeviceList
{
public:
   //! constructor
   dia_SAFeatureBTDeviceList ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureBTDeviceList( void );

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IBTDeviceList methods
   //
   //-------------------------------------------------------------------------

   //! Request the BT module for the currently paired/connected device list.
   virtual tDiaResult getBTDeviceList ( void  );
   //! Request the BT module for the Device list notification.
   virtual tDiaResult startBTDeviceListNotification ( void  );
   //! Request the BT module to stop sending the Device list notification.
   virtual tDiaResult stopBTDeviceListNotification ( void  );

protected:
   //! deprecated default constructor
   dia_SAFeatureBTDeviceList ( void );

   //! get the dia_enum state
   dia_eBTDeviceStatus eGetDeviceStatus ( tU8 status ) const;

   //! returns Bluetooth device status string
   // string sGetBtDeviceStatusString ( most_fi_tcl_e8_BTSetDeviceStatus::tenType status ) const;

   //--------------------------------------------------------------------------
   // Handlers for incoming messages
   //--------------------------------------------------------------------------

   //! handle incoming CCA message
   void vHandleGetBTDeviceList ( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureBTDeviceList)
};

#endif /* __INCLUDED_DIA_SAFEATUREBTDEVICELIST_H__ */
