/*
 * dia_SAFeatureBTDeviceList.cpp
 *
 *  Created on: April 06, 2015
 *      Author: Bharath Kumar Yellikanti (RBEI/ECA4)
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ERROR_INFO__
#include "common/framework/errmgmt/dia_ErrorInfo.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#include "conn_most_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SAFEATUREBTDEVICELIST_H__
#include "dia_SAFeatureBTDeviceList.h"
#endif

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureBTDeviceList,dia_SystemAdapterFeature)
ON_MESSAGE(MOST_BTSETFI_C_U16_DEVICELISTEXTENDED, vHandleGetBTDeviceList)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureBTDeviceList::dia_SAFeatureBTDeviceList(
      tCString name,// feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
   : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::dia_SAFeatureBTDeviceList");
}

//-----------------------------------------------------------------------------

dia_SAFeatureBTDeviceList::~dia_SAFeatureBTDeviceList()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBTDeviceList::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::startMonitoring");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBTDeviceList::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::stopMonitoring");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

dia_eBTDeviceStatus
dia_SAFeatureBTDeviceList::eGetDeviceStatus ( tU8 status ) const
{
   dia_eBTDeviceStatus eDevSatus = DIA_EN_BT_DEVICE_STAUS_UNKNOWN;
   switch(status)
   {
      case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED:
            eDevSatus = DIA_EN_BT_DEVICE_STAUS_CONNECTED;
            break;
            
      case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED_OSD:
            eDevSatus = DIA_EN_BT_DEVICE_STAUS_CONNECTED_OSD;
            break;
            
      case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DISCONNECTED:
            eDevSatus = DIA_EN_BT_DEVICE_STAUS_DISCONNECTED;
            break;
            
      case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CHANGED_TO_OSD:
            eDevSatus = DIA_EN_BT_DEVICE_STAUS_CHANGED_TO_OSD;
            break;
            
      case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DELETED:
            eDevSatus = DIA_EN_BT_DEVICE_STAUS_DELETED;
            break;
            
      case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE:
            eDevSatus = DIA_EN_BT_DEVICE_STAUS_NO_CHANGE;
            break;
      default:
            break;
   }
   return eDevSatus;
}

//-----------------------------------------------------------------------------

// string
// dia_SAFeatureBTDeviceList::sGetBtDeviceStatusString ( most_fi_tcl_e8_BTSetDeviceStatus::tenType status ) const
// {
   // string deviceStatus("DEVICE_STAUS_UNKNOWN");
   // switch(status)
   // {
      // case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED:
            // deviceStatus = "DEVICE_STAUS_CONNECTED";
            // break;
            
      // case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED_OSD:
            // deviceStatus = "DEVICE_STAUS_CONNECTED_OSD";
            // break;
            
      // case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DISCONNECTED:
            // deviceStatus = "DEVICE_STAUS_DISCONNECTED";
            // break;
            
      // case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CHANGED_TO_OSD:
            // deviceStatus = "DEVICE_STAUS_CHANGED_TO_OSD";
            // break;
            
      // case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DELETED:
            // deviceStatus = "DEVICE_STAUS_DELETED";
            // break;
            
      // case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE:
            // deviceStatus = "DEVICE_STAUS_NO_CHANGE";
            // break;
      // default:
            // break;
   // }
   // return deviceStatus;
// }

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBTDeviceList::getBTDeviceList ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::getBTDeviceList");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureBTDeviceList::getBTDeviceList - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MOST_BTSETFI_C_U16_DEVICELISTEXTENDED,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureBTDeviceList::getBTDeviceList - transmitMessage success.");
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureBTDeviceList::getBTDeviceList - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureBTDeviceList::getBTDeviceList - getRegistrationID failed.");
   }

   return retCode;

}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBTDeviceList::startBTDeviceListNotification ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::startBTDeviceListNotification");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureBTDeviceList::startBTDeviceListNotification - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MOST_BTSETFI_C_U16_DEVICELISTEXTENDED,
            CCA_C_U8_OPCODE_UPREG
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureBTDeviceList::startBTDeviceListNotification - transmitMessage success.");
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureBTDeviceList::startBTDeviceListNotification - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureBTDeviceList::startBTDeviceListNotification - getRegistrationID failed.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBTDeviceList::stopBTDeviceListNotification ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::stopBTDeviceListNotification");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureBTDeviceList::stopBTDeviceListNotification - send message.");
      gm_tclEmptyMessage oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            MOST_BTSETFI_C_U16_DEVICELISTEXTENDED,
            CCA_C_U8_OPCODE_RELUPREG
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureBTDeviceList::stopBTDeviceListNotification - transmitMessage success.");
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureBTDeviceList::stopBTDeviceListNotification - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureBTDeviceList::stopBTDeviceListNotification - getRegistrationID failed.");
   }

   return retCode;
}

//==========================================================================================================================================
//==========================================================================================================================================

void
dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList()");
   
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      DIA_TR_INF("dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList --- poMessage OK.");
      
      dia_IBTDeviceListListener* pListener = OSAL_NULL;
      if ((querySysAdapterListener<dia_IBTDeviceListListener>(&pListener) == DIA_SUCCESS) && pListener)
      {
         if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            most_btsetfi_tclMsgDeviceListExtendedStatus oCompResp;
            (tVoid) oResultMsg.s32GetData(oCompResp);
            
            tU8 numOfPairedDevices = oCompResp.u8NumPairedDevices;
            dia_tBTDeviceListChange changedBTDeviceList = dia_tBTDeviceListChange( 
                                                                  oCompResp.oDeviceListChange.u8DeviceHandle,
                                                                  eGetDeviceStatus( oCompResp.oDeviceListChange.e8DeviceStatus.enType )
                                                            );
            DIA_TR_INF("oDeviceListChange.u8DeviceHandle = %d", oCompResp.oDeviceListChange.u8DeviceHandle);
            DIA_TR_INF("oDeviceListChange.e8DeviceStatus = %d", oCompResp.oDeviceListChange.e8DeviceStatus.enType);
            DIA_TR_INF("changedBTDeviceList.DeviceHandle = %d", changedBTDeviceList.DeviceHandle);
            DIA_TR_INF("changedBTDeviceList.DeviceStatus = %d", changedBTDeviceList.DeviceStatus);
            
            std::vector< most_fi_tcl_BTSetDeviceListExtendedResultItem > btDeviceListResult = oCompResp.oDeviceListExtendedResult.oItems;
            std::vector< dia_tBTDeviceList > btDeviceList;
            dia_tBTDeviceList btDeviceInfo;
            
            tU8 listNum = 0;
            std::vector< most_fi_tcl_BTSetDeviceListExtendedResultItem >::const_iterator it = btDeviceListResult.begin();
            for ( ; it != btDeviceListResult.end(); ++it )
            {
               DIA_TR_INF("dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList --- Accessing oDeviceListExtendedResult[%d]", listNum++);
               btDeviceInfo.DeviceHandle = (*it).u8DeviceHandle;
               btDeviceInfo.DeviceConnectedStatus = (*it).bDeviceConnectedStatus;
               btDeviceInfo.OutgoingSourceDeviceStatus = (*it).bOutgoingSourceDeviceStatus;
               btDeviceInfo.DeviceName = (*it).sDeviceName.szValue;
               btDeviceInfo.DateTimeStamp = dia_BTDateTimeStamp(  (*it).oDateTimeStamp.oDateStamp.sCldrYear.szValue,
                                                                  (*it).oDateTimeStamp.oDateStamp.sCldrMonth.szValue,
                                                                  (*it).oDateTimeStamp.oDateStamp.sCldrDay.szValue,
                                                                  (*it).oDateTimeStamp.oTimeStamp.sHours.szValue,
                                                                  (*it).oDateTimeStamp.oTimeStamp.sMinutes.szValue,
                                                                  (*it).oDateTimeStamp.oTimeStamp.sSeconds.szValue
                                                               );
               DIA_TR_INF("oDeviceListExtendedResult.u8DeviceHandle = %d", (*it).u8DeviceHandle);
               DIA_TR_INF("oDeviceListExtendedResult.bDeviceConnectedStatus = \"%s\"", (*it).bDeviceConnectedStatus ? "CONNECTED":"DISCONNECTED");
               DIA_TR_INF("oDeviceListExtendedResult.bOutgoingSourceDeviceStatus = \"%s\"", (*it).bOutgoingSourceDeviceStatus ? "OSD":"Non-OSD");
               DIA_TR_INF("oDeviceListExtendedResult.sDeviceName = \"%s\"", (*it).sDeviceName.szValue);
               DIA_TR_INF("oDeviceListExtendedResult.oDateTimeStamp[DD-MM-YYY (HH:MM:SS)] = \"%s-%s-%s (%s:%s:%s)\"", 
                                                            (*it).oDateTimeStamp.oDateStamp.sCldrYear.szValue,
                                                            (*it).oDateTimeStamp.oDateStamp.sCldrMonth.szValue,
                                                            (*it).oDateTimeStamp.oDateStamp.sCldrDay.szValue,
                                                            (*it).oDateTimeStamp.oTimeStamp.sHours.szValue,
                                                            (*it).oDateTimeStamp.oTimeStamp.sMinutes.szValue,
                                                            (*it).oDateTimeStamp.oTimeStamp.sSeconds.szValue
                                                         );
               // DIA_TR_INF("btDeviceInfo.DeviceHandle = %d", btDeviceInfo.DeviceHandle);
               // DIA_TR_INF("btDeviceInfo.DeviceConnectedStatus = \"%s\"", btDeviceInfo.DeviceConnectedStatus ? "CONNECTED":"DISCONNECTED");
               // DIA_TR_INF("btDeviceInfo.OutgoingSourceDeviceStatus = \"%s\"", btDeviceInfo.OutgoingSourceDeviceStatus ? "OSD":"Non-OSD");
               // DIA_TR_INF("btDeviceInfo.DeviceName = \"%s\"", btDeviceInfo.DeviceName);
               // DIA_TR_INF("btDeviceInfo.DateTimeStamp[DD-MM-YYY (HH:MM:SS)] = \"%s-%s-%s (%s:%s:%s)\"", 
                                                            // btDeviceInfo.DateTimeStamp.CldrYear,
                                                            // btDeviceInfo.DateTimeStamp.CldrMonth,
                                                            // btDeviceInfo.DateTimeStamp.CldrDay,
                                                            // btDeviceInfo.DateTimeStamp.Hours,
                                                            // btDeviceInfo.DateTimeStamp.Minutes,
                                                            // btDeviceInfo.DateTimeStamp.Seconds
                                                         // );
               btDeviceList.push_back(btDeviceInfo);
            }
            pListener->vOnBTDeviceListResponse(numOfPairedDevices, btDeviceList, changedBTDeviceList);
         }
         else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_ERR( "dia_SAFeatureBTDeviceList --- opcode error received with error code: %d", u16ErrorCode);
            dia_ErrorInfo errInfo(DIA_FAILED);
            pListener->vOnError(errInfo);
         }
         else
         {
            DIA_TR_ERR("dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList --- UNKNOWN OPCODE==%d", poMessage->u8GetOpCode());
            dia_ErrorInfo errInfo(DIA_FAILED);
            pListener->vOnError(errInfo);
         }

         (tVoid) poMessage->bDelete();
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList --- No Listener Found!");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureBTDeviceList::vHandleGetBTDeviceList --- poMessage EMPTY!");
   }
}

//-----------------------------------------------------------------------------

