/*
 * dia_SAFeatureAuthorizationLevel.h
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_SAFEATURE_AUTHORIZATION_LEVEL__
#define __INCLUDED_DIA_SAFEATURE_AUTHORIZATION_LEVEL__

#include <com/adit/de/ALD/change_levelProxy.h>
#include <com/adit/de/ALD/change_levelClientBase.h>
#include <com/adit/de/ALD/level_statusProxy.h>
#include <com/adit/de/ALD/level_statusClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUTHORIZATIONLEVEL_LISTENER__
#include <common/interfaces/dia_IAuthorizationLevelListener.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATUREAUTHORIZATIONLEVELFSM__
#include <common/framework/fsm/generated/dia_SAFeatureAuthorizationLevelFSM.h>
#endif

using namespace com::adit::de::ALD::change_level;
using namespace com::adit::de::ALD::level_status;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureAuthorizationLevel
   : public dia_SystemAdapterFeatureASF<Change_levelProxy>,
     public Change_levelClientBase,
     public dia_SystemAdapterFeatureASF<Level_statusProxy>,
     public Level_statusClientBase,
     public dia_IAuthorizationLevel,
     public dia_ITimerListener,
     protected dia_SAFeatureAuthorizationLevelFSM::FsmBehaviour
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SAFeatureAuthorizationLevel);
public:
   //! constructor
   dia_SAFeatureAuthorizationLevel (
         dia_SystemAdapterServicePluginASF<Change_levelProxy>& srvPluginChangeLevel,
         dia_SystemAdapterServicePluginASF<Level_statusProxy>& srvPluginLevelStatus
         );

   //! destructor
   virtual ~dia_SAFeatureAuthorizationLevel ( void );


   tDiaResult setup ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAuthorizationLevel methods
   //
   //-------------------------------------------------------------------------

   //! request current seed at ALD
   virtual tDiaResult requestSeed ( const std::vector<tU8>& initData );
   //! According to the received key the calculated seed is send to ALD for verification
   virtual tDiaResult provideKey ( const std::vector<tU8>& key );
   //! lock all engineering interfaces via ALD
   virtual tDiaResult lockDevice ( void );
   //! request current level from ALD
   virtual tDiaResult getActiveLevel ( void );
   //! request current level from ALD
   virtual tU16 getCurrentLevel ( void ) const { return mActiveLevel; }

   ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   //
   // change_level interface
   //
   ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   // Callback 'ChallengeCallbackIF'
   virtual void onChallengeResponse ( const ::boost::shared_ptr<Change_levelProxy>& proxy, const ::boost::shared_ptr<ChallengeResponse>& response );
   virtual void onChallengeError ( const ::boost::shared_ptr<Change_levelProxy>& proxy, const ::boost::shared_ptr<ChallengeError>& error );
   virtual void onChallengeResponse ( void ); //lint !e1411 Warning : Member with different signature hides virtual member

   // Callback 'LockDeviceCallbackIF'
   virtual void onLockDeviceError(const ::boost::shared_ptr<Change_levelProxy>& proxy, const ::boost::shared_ptr<LockDeviceError>& error);
   virtual void onLockDeviceResponse(const ::boost::shared_ptr<Change_levelProxy>& proxy, const ::boost::shared_ptr<LockDeviceResponse>& response);
   virtual void onLockDeviceResponse ( tDiaResult retCode ); //lint !e1411 Warning : Member with different signature hides virtual member

   // Callback 'ResponseCallbackIF'
   virtual void onResponseError(const ::boost::shared_ptr<Change_levelProxy>& proxy, const ::boost::shared_ptr<ResponseError>& error);
   virtual void onResponseResponse(const ::boost::shared_ptr<Change_levelProxy>& proxy, const ::boost::shared_ptr<ResponseResponse>& response);
   virtual void onResponseResponse ( tDiaResult result ); //lint !e1411 Warning : Member with different signature hides virtual member

   ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   //
   // level_status interface
   //
   ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   // Callback 'LevelCallbackIF'
   virtual void onLevelError(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelError >& error);
   virtual void onLevelUpdate(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelUpdate >& update);
   virtual void onLevelUpdate ( tU16 level ); //lint !e1411 Warning : Member with different signature hides virtual member


   // Callback 'LevelChangeDoneCallbackIF'
   virtual void onLevelChangeDoneError(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelChangeDoneError >& error);
   virtual void onLevelChangeDoneSignal(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelChangeDoneSignal >& signal);
   virtual void onLevelChangeDoneSignal ( tU16 level ); //lint !e1411 Warning : Member with different signature hides virtual member

   // Callback 'NewLevelCallbackIF'
   virtual void onNewLevelError(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< NewLevelError >& error);
   virtual void onNewLevelSignal(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< NewLevelSignal >& signal);
   virtual void onNewLevelSignal ( tU16 level ); //lint !e1411 Warning : Member with different signature hides virtual member

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

protected:
   //! deprecated default constructor
   dia_SAFeatureAuthorizationLevel ();

   static tDiaResult startMonitoringOfChangeLevel ( void* cookie );
   static tDiaResult stopMonitoringOfChangeLevel ( void* cookie );
   static tDiaResult startMonitoringOfLevelStatus ( void* cookie );
   static tDiaResult stopMonitoringOfLevelStatus ( void* cookie );

   tDiaResult acceptEvent ( dia_SAFeatureAuthorizationLevelFSM::FsmEvent event, void* pArg );

   // FSM actions
   virtual void vFsmHandleError ( void* pArg );
   virtual void vFsmHandleWarning ( void* pArg );
   virtual void vFsmNotifyDeviceLock ( void* pArg );
   virtual void vFsmNotifyKeyValidationResult ( void* pArg );
   virtual void vFsmNotifyLevel ( void* pArg );
   virtual void vFsmNotifyLevelChange ( void* pArg );
   virtual void vFsmNotifyLevelChangeIndication ( void* pArg );
   virtual void vFsmNotifySeed ( void* pArg );
   virtual void vFsmRequestLevel ( void* pArg );
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmStartMonitoring ( void* pArg );
   virtual void vFsmStoreLevel ( void* pArg );
   virtual void vStopMonitoring ( void* pArg );
   virtual void vFsmStartInitTimer ( void* pArg );
   virtual void vFsmStopInitTimer ( void* pArg );


protected:
   //! currently activated security level
   tU16 mActiveLevel;
   //! error code modified by state machine actions
   tDiaResult mErrorCode;
   //! pointer to the state machine
   dia_SAFeatureAuthorizationLevelFSM::Fsm* mpFSM;
   //! asynchronous continuation token for the NewLevel signal registration
   act_t mSignalNewLevelAct;
   //! asynchronous continuation token for the LevelChanged signal registration
   act_t mSignalLevelChangedAct;
   //! received challenge
   std::vector<tU8> mReceivedChallenge;
   //! timer used to retry getting the current level from ALD
   dia_Timer mLevelTimer;
   //! flag to indicate that ALD's level status service is available
   static bool mIsLevelStatusServiceAvailable;
   //! flag to indicate that ALD's level changed service is available
   static bool mIsLevelChangedServiceAvailable;
};

#endif /* __INCLUDED_DIA_SAFEATURE_AUTHORIZATION_LEVEL__ */
