/*!
 * \file       dia_SAFeatureAuthorizationLevel.cpp
 *
 * \brief      System adapter to ALD (authorization level deamon)
 *
 * \details    System adapter to ALD (authorization level deamon)
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreSysAdapters
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

/* PATHS for ASF communication
 * XML-Definition: x.vws\di_middleware_server\components\fc_diagnosis\project\framework\platform\asf\AuthorizationLevelDaemon.xml
 * Generated Code: x.vws_GEN\ai_projects\generated\components\asf\asf\diag_AuthotizationLevelDaemon\dbus\src-gen\com\adit\de\ALD\change_levelClientBase.h
 *                 x.vws_GEN\ai_projects\generated\components\asf\asf\diag_AuthotizationLevelDaemon\dbus\src-gen\com\adit\de\ALD\change_levelProxy.h
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif


#include "dia_SAFeatureAuthorizationLevel.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

//-----------------------------------------------------------------------------

#define DIA_C_U8_ALD_RETCODE_SUCCESS                  ((tU8)    0x00)
#define DIA_C_U8_ALD_MAX_RETURN_CODES                 ((tU8)      15)

using namespace dia;

//------------------------------------------------------------------------------

bool dia_SAFeatureAuthorizationLevel::mIsLevelStatusServiceAvailable  = false;
bool dia_SAFeatureAuthorizationLevel::mIsLevelChangedServiceAvailable = false;

//------------------------------------------------------------------------------

dia_SAFeatureAuthorizationLevel::dia_SAFeatureAuthorizationLevel (
      dia_SystemAdapterServicePluginASF<Change_levelProxy>& srvPluginChangeLevel, dia_SystemAdapterServicePluginASF<Level_statusProxy>& srvPluginLevelStatus
   )
   : dia_SystemAdapterFeatureASF<Change_levelProxy>(srvPluginChangeLevel),
     dia_SystemAdapterFeatureASF<Level_statusProxy>(srvPluginLevelStatus),
     mActiveLevel(DIA_C_U16_ALD_UNKNOWN_LEVEL),
     mErrorCode(DIA_E_NO_ERROR),
     mpFSM(0),
     mSignalNewLevelAct(0),
     mSignalLevelChangedAct(0)
{
   mLevelTimer.s32Create();
}

//-----------------------------------------------------------------------------

dia_SAFeatureAuthorizationLevel::~dia_SAFeatureAuthorizationLevel ( void )
{
   _BP_TRY_BEGIN
   {
      delete mpFSM;
      mpFSM = 0;

      mLevelTimer.s32Delete();
      mLevelTimer.removeTimerListener(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SAFeatureAuthorizationLevel::~dia_SAFeatureAuthorizationLevel !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::setup ( void )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::setup");

   if ( !mpFSM )
   {
      // create the state machine object
      if ( !(dia_SAFeatureAuthorizationLevelFSM::Fsm::createFSM(&mpFSM,this)) )
      {
         DIA_TR_INF( "### STATE MACHINE INITIALIZATION FAILED ###");
         return DIA_FAILED;
      }
   }

   tDiaResult retCode1 = this->dia_SystemAdapterFeatureASF<Change_levelProxy>::customizeMonitoring (
         dia_SAFeatureAuthorizationLevel::startMonitoringOfChangeLevel,
         dia_SAFeatureAuthorizationLevel::stopMonitoringOfChangeLevel,
         this
         );

   tDiaResult retCode2 = this->dia_SystemAdapterFeatureASF<Level_statusProxy>::customizeMonitoring (
         dia_SAFeatureAuthorizationLevel::startMonitoringOfLevelStatus,
         dia_SAFeatureAuthorizationLevel::stopMonitoringOfLevelStatus,
         this
         );

   if ( (retCode1 != DIA_SUCCESS) || (retCode2 != DIA_SUCCESS) )
   {
      DIA_TR_ERR("##### dia_SAFeatureAuthorizationLevel::setup: FAILED TO HOOK MONITORING METHODS (0x%08x,0x%08x)", retCode1, retCode2);
      return DIA_FAILED;
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::startMonitoringOfChangeLevel ( void* /*cookie*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::startMonitoringOfChangeLevel");
   dia_SAFeatureAuthorizationLevel::mIsLevelChangedServiceAvailable = true;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::stopMonitoringOfChangeLevel ( void* /*cookie*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::stopMonitoringOfChangeLevel");
   dia_SAFeatureAuthorizationLevel::mIsLevelChangedServiceAvailable = false;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::acceptEvent ( dia_SAFeatureAuthorizationLevelFSM::FsmEvent event, void* pArg )
{
   ScopeTrace oTrace("dia_SAFeatureAuthorizationLevel::acceptEvent(dia_SAFeatureAuthorizationLevelFSM::FsmEvent,void*)");

   if ( !mpFSM )  return DIA_E_FSM_NOT_AVAILABLE;

   mErrorCode = DIA_E_NO_ERROR;

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::acceptEvent - State (before): %s (%p)", mpFSM->getStateName(),mpFSM);
   mpFSM->acceptEvent(event,pArg);
   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::acceptEvent - State (after): %s", mpFSM->getStateName());

   return mErrorCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::startMonitoringOfLevelStatus ( void* cookie )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::startMonitoringOfLevelStatus");

   if ( !cookie ) return DIA_E_INVALID_POINTER;

   dia_SAFeatureAuthorizationLevel::mIsLevelStatusServiceAvailable = true;

   dia_SAFeatureAuthorizationLevel* pObj = (dia_SAFeatureAuthorizationLevel*) cookie;

   return pObj->acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evStart,pObj);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::stopMonitoringOfLevelStatus ( void* cookie )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::stopMonitoringOfLevelStatus");

   if ( !cookie ) return DIA_E_INVALID_POINTER;

   dia_SAFeatureAuthorizationLevel::mIsLevelStatusServiceAvailable = false;

   dia_SAFeatureAuthorizationLevel* pObj = (dia_SAFeatureAuthorizationLevel*) cookie;

   return pObj->acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evStop,pObj);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::requestSeed ( const std::vector<tU8>& initVector )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::requestSeed(const std::vector<tU8>&)");

   tDiaResult retCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::requestSeed: size: %zu, init: %s", initVector.size(), dia::utils::bin2str(initVector,' ').c_str());

   Change_levelProxy* pProxy = this->dia_SystemAdapterFeatureASF<Change_levelProxy>::mpSrvPlugin->getProxy();
   if ( pProxy )
   {
      act_t result = pProxy->sendChallengeRequest(*this, initVector);
      retCode = ( result != 0 ) ? DIA_SUCCESS : DIA_FAILED;
      DIA_TR_INF("dia_SAFeatureAuthorizationLevel::sendChallengeRequest returned %lu",result);
   }

   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::requestSeed FAILED (ERR=0x%08x)", retCode);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::provideKey ( const std::vector<tU8>& keyData )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::provideKey");

   tDiaResult retCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::provideKey: size: %zu, data: %s", keyData.size(), dia::utils::bin2str(keyData,' ').c_str());

   Change_levelProxy* pProxy = this->dia_SystemAdapterFeatureASF<Change_levelProxy>::mpSrvPlugin->getProxy();
   if ( pProxy )
   {
      act_t result = pProxy->sendResponseRequest(*this, keyData);
      retCode = ( result != 0 ) ? DIA_SUCCESS : DIA_FAILED;
      DIA_TR_INF("dia_SAFeatureAuthorizationLevel::sendKey sendResponseRequest returned %lu .", result);
   }

   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::provideKey FAILED (ERR=0x%08x)", retCode);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::lockDevice ( void )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::lockDevice");

   tDiaResult retCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::lockDevice sendLockDeviceRequest to ALD");

   Change_levelProxy* pProxy = this->dia_SystemAdapterFeatureASF<Change_levelProxy>::mpSrvPlugin->getProxy();
   if ( pProxy )
   {
      act_t result = pProxy->sendLockDeviceRequest(*this);
      retCode = ( result != 0 ) ? DIA_SUCCESS : DIA_FAILED;
      DIA_TR_INF("dia_SAFeatureAuthorizationLevel::lockDevice sendLockDeviceRequest returned %lu .", result);
   }

   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::lockDevice FAILED (ERR=0x%08x)", retCode);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAuthorizationLevel::getActiveLevel ( void )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::getActiveLevel");

   tDiaResult retCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;

   if ( mActiveLevel == DIA_C_U16_ALD_UNKNOWN_LEVEL )
   {
      DIA_TR_INF("dia_SAFeatureAuthorizationLevel::getActiveLevel sendLevelGet to ALD");

      Level_statusProxy* pProxy = this->dia_SystemAdapterFeatureASF<Level_statusProxy>::mpSrvPlugin->getProxy();
      if ( pProxy )
      {
         if ( dia_SAFeatureAuthorizationLevel::mIsLevelStatusServiceAvailable )
         {
            act_t result = pProxy->sendLevelGet(*this);
            retCode = ( result != 0 ) ? DIA_SUCCESS : DIA_FAILED;
            DIA_TR_INF("dia_SAFeatureAuthorizationLevel::getActiveLevel sendLevelGet returned %lu .", result);
         }
         else
         {
            DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::getActiveLevel PENDING (ALD SERVICE NOT YET AVAILABLE)");
            // request can be ignored. we will automatically request the level once the service is getting available
            retCode = DIA_SUCCESS;
         }
      }

      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::getActiveLevel FAILED (ERR=0x%08x)", retCode);
      }
   }
   else
   {
      // we already have received the currently active level from ALD
      retCode = DIA_SUCCESS;
      getInstanceOfApplication()->postMessage (
            new dia_tclDiagSession::tclEventIntMsgRxGeneric (
                  new dia_FunctorOneArgNoReturnValue<dia_SAFeatureAuthorizationLevel,tU16>(this,&dia_SAFeatureAuthorizationLevel::onLevelUpdate,mActiveLevel)
            )
      );
   }

   return retCode;
}

//=============================================================================
//=============================================================================

void
dia_SAFeatureAuthorizationLevel::onChallengeError ( const ::boost::shared_ptr<Change_levelProxy>& /*proxy*/, const ::boost::shared_ptr<ChallengeError>& /*error*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onChallengeError");

   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::onChallengeError (NOT YET IMPLEMENTED) !!");
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onChallengeResponse ( const ::boost::shared_ptr<Change_levelProxy>& /*proxy*/, const ::boost::shared_ptr<ChallengeResponse>& response )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onChallengeResponse");

   mReceivedChallenge.clear();
   mReceivedChallenge.reserve(response->getChallenge().size());
   mReceivedChallenge = response->getChallenge();
   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorNoArgsNoReturnValue< dia_SAFeatureAuthorizationLevel>(this,&dia_SAFeatureAuthorizationLevel::onChallengeResponse)
         )
   );

//   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onChallengeResponse: size: %d, data: %s", data.size(), dia::utils::bin2str(data,' ').c_str());
//
//   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evSeedReceived,&data);
}

void
dia_SAFeatureAuthorizationLevel::onChallengeResponse ( void )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onChallengeResponse()");

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onChallengeResponse: size: %zu, challenge: %s", mReceivedChallenge.size(), dia::utils::bin2str(mReceivedChallenge,' ').c_str());
   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evSeedReceived,&mReceivedChallenge);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onLockDeviceError ( const ::boost::shared_ptr<Change_levelProxy>& /*proxy*/, const ::boost::shared_ptr<LockDeviceError>& /*error*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLockDeviceError");

   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::onLockDeviceError (NOT YET IMPLEMENTED) !!");
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onLockDeviceResponse ( const ::boost::shared_ptr<Change_levelProxy>& /*proxy*/, const ::boost::shared_ptr<LockDeviceResponse>& response )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLockDeviceResponse");

   tDiaResult retCode = (DIA_C_U8_ALD_RETCODE_SUCCESS == response->getResult()) ? DIA_SUCCESS : DIA_FAILED;
   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorOneArgNoReturnValue<dia_SAFeatureAuthorizationLevel,tDiaResult>(this,&dia_SAFeatureAuthorizationLevel::onLockDeviceResponse,retCode)
         )
   );
//   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onLockDeviceResponse: Return Code Is 0x%08x",retCode);
//   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evDeviceLock,&retCode);
}

void
dia_SAFeatureAuthorizationLevel::onLockDeviceResponse ( tDiaResult retCode )
{
   dia_tclFnctTrace trc("dia_SAFeatureAuthorizationLevel::onLockDeviceResponse");

//   tDiaResult retCode = (DIA_C_U8_ALD_RETCODE_SUCCESS == response->getResult()) ? DIA_SUCCESS : DIA_FAILED;
   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onLockDeviceResponse: Return Code Is 0x%08x",retCode);
   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evDeviceLock,&retCode);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onResponseError ( const ::boost::shared_ptr<Change_levelProxy>& /*proxy*/, const ::boost::shared_ptr<ResponseError>& /*error*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onResponseError");

   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::onResponseError (NOT YET IMPLEMENTED) !!");
}

//-----------------------------------------------------------------------------

struct enALDResult
{
   tDiaResult  mRetCode;
   const char* mResponseStr;
};
void
dia_SAFeatureAuthorizationLevel::onResponseResponse(const ::boost::shared_ptr<Change_levelProxy>& /*proxy*/, const ::boost::shared_ptr<ResponseResponse>& response)
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onResponseResponse");

   static enALDResult responseMapping[DIA_C_U8_ALD_MAX_RETURN_CODES] = {
         { DIA_SUCCESS, "OK"},
         { DIA_E_INVALID_SECURITY_KEY,   "INVALID"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "NO_RESOURCE"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "PERSISTENT_STATE_FILE_ACCESS_ISSUES"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "INVALID_LEVEL"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "SCRIPTS_MODIFIED"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "SCRIPTS_FAILED"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "SCRIPTS_TIMEOUT"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "SCRIPTS_TIMEOUT"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "VERIFICATION_KEY_MODIFIED"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "VERIFICATION_KEY_MODIFIED"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "CHALLENGE_EXPIRED"},
         { DIA_E_INVALID_SECURITY_KEY,   "CHALLENGE_INVALID_REPONSE"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "DAEMON_BUSY_LEVEL_CHANGE"},
         { DIA_E_CONDITIONS_NOT_CORRECT, "DAEMON_BUSY_LEVEL_RECOVERY"}
   };

   tU32 result = response->getResult();

   tDiaResult mappedResult;
   const char* resultStr;

   if (result < DIA_C_U8_ALD_MAX_RETURN_CODES)
   {
	   mappedResult = responseMapping[(tU8)result].mRetCode ;
   	   resultStr = responseMapping[(tU8)result].mResponseStr ;
   }
   else
   {
	   mappedResult = DIA_E_CONDITIONS_NOT_CORRECT;
   	   resultStr = "UNKNOWN";
   }
   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onResponseResponse result=\"%s\" (0x%08x).",resultStr,result);

   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorOneArgNoReturnValue<dia_SAFeatureAuthorizationLevel,tDiaResult>(this,&dia_SAFeatureAuthorizationLevel::onResponseResponse,mappedResult)
         )
   );

//   tDiaResult retCode = (result == DIA_C_U8_ALD_RETCODE_SUCCESS) ? DIA_SUCCESS : DIA_FAILED;
//   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evKeyValidated,&retCode);
}

void
dia_SAFeatureAuthorizationLevel::onResponseResponse ( tDiaResult result )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onResponseResponse");

//   tDiaResult retCode = (DIA_C_U8_ALD_RETCODE_SUCCESS == response->getResult()) ? DIA_SUCCESS : DIA_FAILED;
   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evKeyValidated,&result);
}

//=============================================================================
//=============================================================================

void
dia_SAFeatureAuthorizationLevel::onLevelError ( const ::boost::shared_ptr< Level_statusProxy >& /*proxy*/, const ::boost::shared_ptr< LevelError >& /*error*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLevelError");

   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::onLevelError (NOT YET IMPLEMENTED) !!");
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onLevelUpdate ( const ::boost::shared_ptr< Level_statusProxy >& /*proxy*/, const ::boost::shared_ptr< LevelUpdate >& update )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLevelUpdate(const Level_statusProxy& , const LevelUpdate&)");

   tU16 level = (tU16) update->getLevel();
   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorOneArgNoReturnValue<dia_SAFeatureAuthorizationLevel,tU16>(this,&dia_SAFeatureAuthorizationLevel::onLevelUpdate,level)
         )
   );

//   tU16 level = (tU16) update->getLevel();
//   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onLevelUpdate: level = 0x%04x",level);
//
//   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evLevel,&level);
}

void
dia_SAFeatureAuthorizationLevel::onLevelUpdate ( tU16 level )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLevelUpdate(tU16)");

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onLevelUpdate: level = 0x%04x",level);
   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evLevel,&level);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onLevelChangeDoneError ( const ::boost::shared_ptr< Level_statusProxy >& /*proxy*/, const ::boost::shared_ptr< LevelChangeDoneError >& /*error*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::LevelChangeDoneError");

   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::LevelChangeDoneError (NOT YET IMPLEMENTED) !!");
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal ( const ::boost::shared_ptr< Level_statusProxy >& /*proxy*/, const ::boost::shared_ptr< LevelChangeDoneSignal >& signal )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal");

   tU16 level = (tU16) signal->getNew_level();
   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorOneArgNoReturnValue<dia_SAFeatureAuthorizationLevel,tU16>(this,&dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal,level)
         )
   );


//   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal: level = 0x%04x",level);
//
//   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evLevelChanged,&level);
}

void
dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal ( tU16 level )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal(tU16)");

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onLevelChangeDoneSignal: level = 0x%04x",level);
   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evLevelChanged,&level);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onNewLevelError ( const ::boost::shared_ptr< Level_statusProxy >& /*proxy*/, const ::boost::shared_ptr< NewLevelError >& /*error*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onNewLevelError");

//   //! class constructor
//   dia_ErrorInfo ( tDiaResult errCode = DIA_FAILED );
//   virtual void vOnError ( const dia_ErrorInfo& errInfo ) {}

   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::onNewLevelError (NOT YET IMPLEMENTED) !!");
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::onNewLevelSignal ( const ::boost::shared_ptr< Level_statusProxy >& /*proxy*/, const ::boost::shared_ptr< NewLevelSignal >& signal )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onNewLevelSignal");

   tU16 level = (tU16) signal->getNew_level();
   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorOneArgNoReturnValue<dia_SAFeatureAuthorizationLevel,tU16>(this,&dia_SAFeatureAuthorizationLevel::onNewLevelSignal,level)
         )
   );

//   tU16 level = (tU16) signal->getNew_level();
//   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onNewLevelSignal: level = 0x%04x",level);
//
//   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evLevelChangeIndication,&level);
}

void
dia_SAFeatureAuthorizationLevel::onNewLevelSignal ( tU16 level )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::onNewLevelSignal(tU16)");

   DIA_TR_INF("dia_SAFeatureAuthorizationLevel::onNewLevelSignal: level = 0x%04x",level);
   (void) acceptEvent(dia_SAFeatureAuthorizationLevelFSM::evLevelChangeIndication,&level);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmHandleError ( void* /*pArg*/ )
{
   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::vFsmHandleError (ERROR=0x%08x)) !!",mErrorCode);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmHandleWarning ( void* /*pArg*/ )
{
   DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::vFsmHandleWarning (ERROR=0x%08x)) !!",mErrorCode);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmNotifyDeviceLock ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmNotifyDeviceLock");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   tDiaResult retCode = *((tDiaResult*) pArg);

   dia_IAuthorizationLevelListener* pListener = 0;
   if ((querySysAdapterListener<dia_IAuthorizationLevelListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnLockDeviceResult(retCode);
   }

}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmNotifyKeyValidationResult ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmNotifyKeyValidationResult");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   tDiaResult retCode = *((tDiaResult*) pArg);

   dia_IAuthorizationLevelListener* pListener = 0;
   if ( (querySysAdapterListener<dia_IAuthorizationLevelListener>(&pListener) == DIA_SUCCESS) && pListener )
   {
      pListener->vOnKeyValidationResult(retCode);
   }

}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmNotifyLevel ( void* /*pArg*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmNotifyLevel");

   dia_IAuthorizationLevelListener* pListener = 0;
   if ((querySysAdapterListener<dia_IAuthorizationLevelListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnLevel(mActiveLevel);
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmNotifyLevelChange ( void* /*pArg*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmNotifyLevelChange");

   dia_IAuthorizationLevelListener* pListener = 0;
   if ((querySysAdapterListener<dia_IAuthorizationLevelListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnLevelChanged(mActiveLevel);
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmNotifyLevelChangeIndication ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmNotifyLevelChangeIndication");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   tU16 level = *((tU16*) pArg);

   dia_IAuthorizationLevelListener* pListener = 0;
   if ((querySysAdapterListener<dia_IAuthorizationLevelListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnLevelRequested(level);
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmNotifySeed ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmNotifySeed");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   std::vector<tU8>* pData = (std::vector<tU8>*) pArg;

   dia_IAuthorizationLevelListener* pListener = 0;
   if ((querySysAdapterListener<dia_IAuthorizationLevelListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnSeed(*pData);
   }

}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmRequestLevel ( void* /*pArg*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmRequestLevel");

   Level_statusProxy* pProxy = this->dia_SystemAdapterFeatureASF<Level_statusProxy>::mpSrvPlugin->getProxy();
   if ( !pProxy )
   {
      DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::vFsmRequestLevel DIA_E_ASF_PROXY_NOT_AVAILABLE");
      mErrorCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;
      return;
   }

   if ( pProxy->sendLevelGet(*this) == 0 )
   {
      mErrorCode = DIA_FAILED;
      DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::vFsmRequestLevel FAILED");
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmReset ( void* /*pArg*/ )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmReset");

   mActiveLevel = DIA_C_U16_ALD_UNKNOWN_LEVEL;
   mErrorCode = DIA_E_NO_ERROR;
   mSignalNewLevelAct = 0;
   mSignalLevelChangedAct = 0;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmStartMonitoring ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmStartMonitoring");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   dia_SAFeatureAuthorizationLevel* pObj = (dia_SAFeatureAuthorizationLevel*) pArg;

   if ( dia_SystemAdapterFeatureASF<Level_statusProxy>::mpSrvPlugin )
   {
      Level_statusProxy* pProxy = dia_SystemAdapterFeatureASF<Level_statusProxy>::mpSrvPlugin->getProxy();
      if ( pProxy )
      {
         mSignalNewLevelAct     = pProxy->sendNewLevelRegister(*pObj);
         mSignalLevelChangedAct = pProxy->sendLevelChangeDoneRegister(*pObj);
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::startMonitoringOfLevelStatus: FAILED. ERR=DIA_E_ASF_PROXY_NOT_AVAILABLE");
         mErrorCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;
      }
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmStoreLevel ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmStoreLevel");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   mActiveLevel = *((tU16*) pArg);
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vStopMonitoring ( void* pArg )
{
   ScopeTrace trc("dia_SAFeatureAuthorizationLevel::vFsmReset");

   if ( !pArg  )
   {
      mErrorCode = DIA_E_INVALID_POINTER;
      return;
   }

   if ( dia_SystemAdapterFeatureASF<Level_statusProxy>::mpSrvPlugin )
   {
      Level_statusProxy* pProxy = dia_SystemAdapterFeatureASF<Level_statusProxy>::mpSrvPlugin->getProxy();
      if ( pProxy )
      {
         (void) pProxy->sendNewLevelDeregister(mSignalNewLevelAct);
         (void) pProxy->sendLevelChangeDoneDeregister(mSignalLevelChangedAct);
         mSignalNewLevelAct = 0;
         mSignalLevelChangedAct = 0;
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureAuthorizationLevel::stopMonitoringOfLevelStatus: FAILED. ERR=DIA_E_ASF_PROXY_NOT_AVAILABLE");
         mErrorCode = DIA_E_ASF_PROXY_NOT_AVAILABLE;
      }
   }
}

//---------------------------------------------------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmStartInitTimer ( void* /*pArg*/ )
{
   ScopeTrace oTrace("dia_SAFeatureAuthorizationLevel::vFsmStartInitTimer(void*)");
   mLevelTimer.addTimerListener(this);
   mLevelTimer.s32SetTime(0,0);
   mLevelTimer.s32SetTime(1000, 1000);
}

//---------------------------------------------------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vFsmStopInitTimer ( void* /*pArg*/ )
{
   ScopeTrace oTrace("dia_SAFeatureAuthorizationLevel::vFsmStopInitTimer(void*)");
   mLevelTimer.s32SetTime(0,0);
   mLevelTimer.removeTimerListener(this);
}

//---------------------------------------------------------------------------------------------------------------------

void
dia_SAFeatureAuthorizationLevel::vOnTimerElapsed ( dia_TimerID /*id*/ )
{
   ScopeTrace oTrace("dia_SAFeatureAuthorizationLevel::vOnTimerElapsed(dia_TimerID)");
   (void) acceptEvent( dia_SAFeatureAuthorizationLevelFSM::evTimeout,0);
}


