/*
 * dia_SAFeatureAudioModeControl.h
 *
 *  Created on: 25.05.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_AUDIO_MODE_CONTROL__
#define __INCLUDED_DIA_SAFEATURE_AUDIO_MODE_CONTROL__

#include <org/genivi/audiomanager/CommandInterfaceProxy.h>
#include <org/genivi/audiomanager/CommandInterfaceClientBase.h>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_MODE_CONTROL__
#include <common/interfaces/dia_IAudioModeControl.h>
#endif

using namespace org::genivi::audiomanager::CommandInterface;

namespace dia {

//-----------------------------------------------------------------------------

class SAFeatureAudioModeControl
   : public dia_SystemAdapterFeatureASF<CommandInterfaceProxy>,
     public CommandInterfaceClientBase,
     public dia::IAudioModeControl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(SAFeatureAudioModeControl);

public:
   //! class constructor
   SAFeatureAudioModeControl ( dia_SystemAdapterServicePluginASF<CommandInterfaceProxy>& pSrvPlugin );

   //! class destructor
   virtual ~SAFeatureAudioModeControl ( void );

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia::IAudioModeControl methods
   //
   //-------------------------------------------------------------------------

   //! switch audio component to obsolete function - don't use anymore. Activates the test tone with a certain frequency and volume. Still available for old projects.
   virtual tDiaResult setAudioMode ( dia::AudioMode& mode );
   //! activates the test tone with a certain frequency and volume for certain channel with DBV
   virtual tDiaResult getAudioMode ( dia::AudioMode& mode );

   //-------------------------------------------------------------------------
   //
   // Overloaded CommandInterfaceClientBase methods
   //
   //-------------------------------------------------------------------------

   //! receive result from Audio via ASF
   virtual void onSetSystemPropertyResponse ( const ::boost::shared_ptr<CommandInterfaceProxy>& proxy, const ::boost::shared_ptr<SetSystemPropertyResponse>& response );
   virtual void onSetSystemPropertyError ( const ::boost::shared_ptr<CommandInterfaceProxy>& proxy, const ::boost::shared_ptr<SetSystemPropertyError>& error );

   //! signal indication from SystemPropertyChangedCallbackIF
   virtual void onSystemPropertyChangedError ( const ::boost::shared_ptr<CommandInterfaceProxy>& proxy, const ::boost::shared_ptr<SystemPropertyChangedError>& error );
   virtual void onSystemPropertyChangedSignal ( const ::boost::shared_ptr<CommandInterfaceProxy>& proxy, const ::boost::shared_ptr<SystemPropertyChangedSignal>& signal );

protected:
   virtual void onAudioModeUpdate ( const dia::AudioMode& mode );

protected:
   //! Acknowledgement from ASF for SystemPropertyChanged signal
   act_t mSystemPropertyChangeAct;
   //! request mode
   dia::AudioMode mRequestedMode;
   //! current mode of audio component
   dia::AudioMode mCurrentMode;
};

} // namespace dia

#endif /* __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_AUDIO__ */
