/*
 * dia_SAFeatureAudioModeControl.cpp
 *
 *  Created on: 25.05.2016
 *      Author: gib2hi
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include <common/framework/application/dia_Application.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_AUDIO_MODE_CONTROL__
#include "common/interfaces/dia_IAudioModeControl.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_AUDIO_MODE_CONTROL__
#include "dia_SAFeatureAudioModeControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_MODE_CONTROL_LISTENER__
#include "common/interfaces/dia_IAudioModeControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif


//#include "../../../../../ai_audio/components/AudioManager/include/audiomanagertypes.h"

//using namespace am;
static const tU16  SYP_DIAG_REMOTE_CONTROL = 5;
#define SYP_DIAG_REMOTE_CONTROL_OFF  ((int16_t) 0)
#define SYP_DIAG_REMOTE_CONTROL_ON   ((int16_t) 1)

namespace dia {

//-----------------------------------------------------------------------------

SAFeatureAudioModeControl::SAFeatureAudioModeControl ( dia_SystemAdapterServicePluginASF<CommandInterfaceProxy>& pSrvPlugin )
   : dia_SystemAdapterFeatureASF(pSrvPlugin),
     mSystemPropertyChangeAct(0),
     mRequestedMode(dia::DIA_EN_AUDIO_MODE_UNKNOWN,false),
     mCurrentMode(dia::DIA_EN_AUDIO_MODE_UNKNOWN,false)
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::SAFeatureAudioModeControl");
//   mSystemPropertyChangeAct = 0;
}

//-----------------------------------------------------------------------------

SAFeatureAudioModeControl::~SAFeatureAudioModeControl ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
SAFeatureAudioModeControl::startMonitoring()
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::startMonitoring");

   if ( mpSrvPlugin && mpSrvPlugin->getProxy() )
   {
      mSystemPropertyChangeAct = mpSrvPlugin->getProxy()->sendSystemPropertyChangedRegister(*this);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
SAFeatureAudioModeControl::stopMonitoring()
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::stopMonitoring");

   if ( mpSrvPlugin && mpSrvPlugin->getProxy() )
   {
      mpSrvPlugin->getProxy()->sendSystemPropertyChangedDeregister(mSystemPropertyChangeAct);
   }

   return DIA_SUCCESS;
}

////-----------------------------------------------------------------------------
//enum enAudioMode
//{
//   DIA_EN_AUDIO_MODE_UNKNOWN = 0,
//   DIA_EN_AUDIO_MODE_BEEP,                   // Beep. Different beeps can be started with this
//   DIA_EN_AUDIO_MODE_FADER_STATUS_ACTIVE,    // Fader status active
//   DIA_EN_AUDIO_MODE_VOLMODE_STREAM_MAIN_1,  // Volume mode for main1 stream
//   DIA_EN_AUDIO_MODE_VOLMODE_STREAM_MIX_1,   // Volume mode for Mix1 stream
//   DIA_EN_AUDIO_MODE_DIAG_REMOTE_CONTROL,    // Diagnosis remote control
//   DIA_EN_AUDIO_MODE_AM_SRV_STS,             // System property for service availability status of GAM
//   DIA_EN_AUDIO_MODE_HMISTARTUP_MUTE,        // System Property to report that HMI is ready and remove MUTE_HMISTARTUP
//   DIA_EN_AUDIO_MODE_COUNT
//};
//

tDiaResult
SAFeatureAudioModeControl::setAudioMode ( dia::AudioMode& mode )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::setAudioMode()");

   if ( mode.getMode() != DIA_EN_AUDIO_MODE_DIAG_REMOTE_CONTROL )
   {
      DIA_TR_ERR("dia::SAFeatureAudioModeControl::setAudioMode mode=0x%02x not supported", mode.getMode());
      return DIA_E_NOT_SUPPORTED;
   }

   mRequestedMode = mode;

   // Create ASF/DBUS Msg. and forward it
   uint16 systemProperty = SYP_DIAG_REMOTE_CONTROL;
   int16  s16Value = ( mode.getState() ) ? SYP_DIAG_REMOTE_CONTROL_ON : SYP_DIAG_REMOTE_CONTROL_OFF;

   DIA_TR_INF("dia::SAFeatureAudioModeControl::setAudioMode mode=SYP_DIAG_REMOTE_CONTROL, %s", ( mode.getState() ) ? "ON" : "OFF");

   SetSystemPropertyRequestPropertyStruct sSysproperty;
   sSysproperty.setElem1 ((tS16) systemProperty);
   sSysproperty.setElem2 (s16Value);

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin && mpSrvPlugin->getProxy() )
   {
      act_t sendRet = mpSrvPlugin->getProxy()->sendSetSystemPropertyRequest(*this, sSysproperty);
      DIA_TR_INF("dia::SAFeatureAudioModeControl::setAudioMode sendSetSystemPropertyRequest with return=%lu .", sendRet);
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("dia::SAFeatureAudioModeControl::setAudioMode mpSrvPlugin - unable to send request (invalid pointer)");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
SAFeatureAudioModeControl::getAudioMode ( dia::AudioMode& mode )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::getAudioMode()");
   mode = mCurrentMode;
   return DIA_SUCCESS;
}

//=============================================================================
//=============================================================================

void
SAFeatureAudioModeControl::onSetSystemPropertyResponse ( const ::boost::shared_ptr<CommandInterfaceProxy>& /*proxy*/, const ::boost::shared_ptr<SetSystemPropertyResponse>& response )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::onSetSystemPropertyResponse()");

   int16 retCode = response->getResult();

   if ( retCode == 0 )
   {
      DIA_TR_INF("dia::SAFeatureAudioModeControl::onSetSystemPropertyResponse - mode active");
      // Dont update the remote control plugin status now, wait for "SystemPropertyChanged" signal from Audio manager
   }
   else
   {
      DIA_TR_ERR("dia::SAFeatureAudioModeControl::onSetSystemPropertyResponse - mode activation failed: retCode = 0x%04x .", retCode);
   }
}

//-----------------------------------------------------------------------------

void
SAFeatureAudioModeControl::onSetSystemPropertyError ( const ::boost::shared_ptr<CommandInterfaceProxy>& /*proxy*/, const ::boost::shared_ptr<SetSystemPropertyError>& /*error*/)
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::onSetSystemPropertyError()");
}

//-----------------------------------------------------------------------------

void
SAFeatureAudioModeControl::onSystemPropertyChangedError ( const ::boost::shared_ptr<CommandInterfaceProxy>& /*proxy*/, const ::boost::shared_ptr<SystemPropertyChangedError>& error )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::onSystemPropertyChangedError()");

   DIA_TR_ERR( "=> ErrorName = \"%s\", ErrorMessage = \"%s\"", error->getName().c_str(), error->getMessage().c_str());
}

//-----------------------------------------------------------------------------

void
SAFeatureAudioModeControl::onSystemPropertyChangedSignal ( const ::boost::shared_ptr<CommandInterfaceProxy>& /*proxy*/, const ::boost::shared_ptr<SystemPropertyChangedSignal>& signal )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::onSystemPropertyChangedSignal()");

   static enAudioMode modeMapping[DIA_EN_AUDIO_MODE_COUNT] = {
         DIA_EN_AUDIO_MODE_UNKNOWN,
         DIA_EN_AUDIO_MODE_BEEP,
         DIA_EN_AUDIO_MODE_FADER_STATUS_ACTIVE,
         DIA_EN_AUDIO_MODE_VOLMODE_STREAM_MAIN_1,
         DIA_EN_AUDIO_MODE_VOLMODE_STREAM_MIX_1,
         DIA_EN_AUDIO_MODE_DIAG_REMOTE_CONTROL,
         DIA_EN_AUDIO_MODE_AM_SRV_STS,
         DIA_EN_AUDIO_MODE_HMISTARTUP_MUTE,
   };

   /*am::am_SystemPropertyType_e*/ tS16 sysPropType = (tS16) signal->getSystemProperty().getElem1();
   if ( sysPropType >= DIA_EN_AUDIO_MODE_COUNT ) return;

   int16 value = signal->getSystemProperty().getElem2();
   if ( (value < 0) || (value > 1) ) return;

   enAudioMode mode = modeMapping[sysPropType];
   if ( mode != DIA_EN_AUDIO_MODE_DIAG_REMOTE_CONTROL ) return;

   dia::AudioMode receivedMode(mode,(value == SYP_DIAG_REMOTE_CONTROL_ON) ? true : false);

   DIA_TR_INF("dia::SAFeatureAudioModeControl::onSystemPropertyChangedSignal - mode changed (mode = %d, %s)", receivedMode.mMode, receivedMode.mState ? "enabled" : "disabled");

   getInstanceOfApplication()->postMessage (
         DIA_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               DIA_NEW dia_FunctorOneArgNoReturnValue<SAFeatureAudioModeControl,const dia::AudioMode&>(this,&SAFeatureAudioModeControl::onAudioModeUpdate,receivedMode)
         )
   );
}

void
SAFeatureAudioModeControl::onAudioModeUpdate ( const dia::AudioMode& mode )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioModeControl::onAudioModeUpdate()");

   mCurrentMode = mode;

   dia::IAudioModeControlListener* pListener = 0;
   if ((querySysAdapterListener<dia::IAudioModeControlListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnAudioModeControlUpdate(mCurrentMode);
   }
}

} // namespace dia

