/*
 * dia_RemoteControlPluginAudio.cpp
 *
 *  Created on: 08.05.2014
 *      Author: shw2abt
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_AUDIO__
#include "dia_RemoteControlPluginAudio.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

//#include "../../../../../ai_audio/components/AudioManager/include/audiomanagertypes.h"
//using namespace am;
static const tU16  SYP_DIAG_REMOTE_CONTROL = 5;
#define SYP_DIAG_REMOTE_CONTROL_OFF  ((int16_t) 0)
#define SYP_DIAG_REMOTE_CONTROL_ON   ((int16_t) 1)

//-----------------------------------------------------------------------------

dia_RemoteControlPluginAudio::dia_RemoteControlPluginAudio ( tCString name, dia_SystemAdapterServicePluginASF<CommandInterfaceProxy>& pSrvPlugin ) : 
     dia_SystemAdapterFeatureASF(pSrvPlugin),
     dia_RemoteControlPlugin(name)
{
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::dia_RemoteControlPluginAudio");
   mSystemPropertyChangeAct = 0;
}

//-----------------------------------------------------------------------------

dia_RemoteControlPluginAudio::~dia_RemoteControlPluginAudio ( void )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RemoteControlPluginAudio::startMonitoring()
{
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()) )
   {
      mSystemPropertyChangeAct = mpSrvPlugin->getProxy()->sendSystemPropertyChangedRegister(*this);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RemoteControlPluginAudio::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()) )
   {
      mpSrvPlugin->getProxy()->sendSystemPropertyChangedDeregister(mSystemPropertyChangeAct);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RemoteControlPluginAudio::requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings /*settings*/ )
{
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::requestRemoteControlMode()");
   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("dia_RemoteControlPluginAudio::requestRemoteControlMode 1xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx .");

   if ( mode == DIA_EN_REMOTE_CONTROL_MODE_ACTIVE || mode == DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE )
   {

      // Create ASF/DBUS Msg. and forward it
      uint16 systemProperty = SYP_DIAG_REMOTE_CONTROL;
      int16  s16Value;

      if(mode==DIA_EN_REMOTE_CONTROL_MODE_ACTIVE){
         s16Value = SYP_DIAG_REMOTE_CONTROL_ON;
         DIA_TR_INF("dia_RemoteControlPluginAudio::requestRemoteControlMode set Mode to ACTIVE (%d).", s16Value);
      } else {
         s16Value = SYP_DIAG_REMOTE_CONTROL_OFF;
         DIA_TR_INF("dia_RemoteControlPluginAudio::requestRemoteControlMode set Mode to INactive (%d).", s16Value);
      }

      DIA_TR_INF("dia_RemoteControlPluginAudio::requestRemoteControlMode set RemoteControlProperty (%d).", systemProperty);

      SetSystemPropertyRequestPropertyStruct sSysproperty;
      sSysproperty.setElem1 ((tS16) systemProperty);
      sSysproperty.setElem2 (s16Value);

      // Type of sendConnectRequest
      act_t sendRet;

     if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
     {
      sendRet = mpSrvPlugin->getProxy()->sendSetSystemPropertyRequest(*this, sSysproperty);
      DIA_TR_INF("dia_RemoteControlPluginAudio::requestRemoteControlMode sendSetSystemPropertyRequest with return=%lu .", sendRet);
      retCode = DIA_SUCCESS;
     }
     else
     {
      DIA_TR_INF("dia_RemoteControlPluginAudio::requestRemoteControlMode mpSrvPlugin / mpSrvPlugin->getProxy() is NULL");
      retCode = DIA_FAILED;
     }
   }
   else
   {
      DIA_TR_ERR("dia_RemoteControlPluginAudio::requestRemoteControlMode incorrect mode=0x%02x .", mode);
   }

  return retCode;
}

//=============================================================================
//=============================================================================

void
dia_RemoteControlPluginAudio::onSetSystemPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetSystemPropertyResponse >& response){
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::onSetSystemPropertyResponse()");

   DIA_TR_INF("dia_RemoteControlPluginAudio::onSetSystemPropertyResponse 2xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx .");

   int16 ret = response->getResult();
   DIA_TR_INF("dia_RemoteControlPluginAudio::onSetSystemPropertyResponse retValue = 0x%02x .", ret);

   if(ret==0/*E_OK*/){
      DIA_TR_INF("dia_RemoteControlPluginAudio::onSetSystemPropertyResponse activation successful .");
      // Dont update the remote control plugin status now, wait for "SystemPropertyChanged" signal from Audio manager
   } else {
      DIA_TR_ERR("dia_RemoteControlPluginAudio::onSetSystemPropertyResponse ERROR: retValue = 0x%02x .", ret);
   }

   DIA_TR_INF("dia_RemoteControlPluginAudio::onSetSystemPropertyResponse 3xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx .");
}

//-----------------------------------------------------------------------------

void
dia_RemoteControlPluginAudio::onSetSystemPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetSystemPropertyError >& /*error*/){
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::onSetSystemPropertyError()");

   DIA_TR_INF("dia_RemoteControlPluginAudio::onSetSystemPropertyError xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx .");
}

//-----------------------------------------------------------------------------

void
dia_RemoteControlPluginAudio::onSystemPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SystemPropertyChangedError >& error)
{
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::onSystemPropertyChangedError()");
   DIA_TR_ERR( "=> ErrorName = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "=> ErrorMessage = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void
dia_RemoteControlPluginAudio::onSystemPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SystemPropertyChangedSignal >& signal)
{
   dia_tclFnctTrace trc("dia_RemoteControlPluginAudio::onSystemPropertyChangedSignal()");
   if( signal->getSystemProperty().getElem1() == SYP_DIAG_REMOTE_CONTROL )
   {
      int16 s16Value = signal->getSystemProperty().getElem2();

      if( s16Value == SYP_DIAG_REMOTE_CONTROL_ON )
      {
         DIA_TR_INF("dia_RemoteControlPluginAudio::onSystemPropertyChangedSignal finish REMOTE_CONTROL_MODE_ACTIVE .");
//       vOnRemoteControlUpdate(DIA_EN_REMOTE_CONTROL_MODE_ACTIVE);

         getInstanceOfApplication()->postMessage (
               OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
                     OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_RemoteControlPluginAudio,dia_eRemoteCtrlMode>(this,&dia_RemoteControlPluginAudio::vOnRemoteControlUpdateAudio,DIA_EN_REMOTE_CONTROL_MODE_ACTIVE)
               )
         );
      }
      else if( s16Value == SYP_DIAG_REMOTE_CONTROL_OFF )
      {
         DIA_TR_INF("dia_RemoteControlPluginAudio::onSystemPropertyChangedSignal finish REMOTE_CONTROL_MODE_NOT_ACTIVE .");
//       vOnRemoteControlUpdate(DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE);

         getInstanceOfApplication()->postMessage (
               OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
                     OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_RemoteControlPluginAudio,dia_eRemoteCtrlMode>(this,&dia_RemoteControlPluginAudio::vOnRemoteControlUpdateAudio,DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE)
               )
         );
      }
      else
      {
         DIA_TR_ERR("dia_RemoteControlPluginAudio::onSystemPropertyChangedSignal RemoteControlMode wrong: 0x%02x .", s16Value);
      }
   }
}
