/*
 * dia_SecurityTimer.h
 *
 *  Created on: 10.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SECURITY_TIMER__
#define __INCLUDED_DIA_SECURITY_TIMER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

using namespace std;

class dia_SecurityTimerClient;

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_SecurityTimer
#ifndef __DIA_UNIT_TESTING__
   : protected OSAL_tclTimer
#endif
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_SecurityTimer);

public:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult tearDown ( void );

   //! start the timer
   virtual void setTiming ( tU32 timeout, tU32 cycleValue );
   virtual tU32 getTimeout ( void ) const { return mTimeout; }
   virtual tU32 getCycleTime ( void ) const { return mCycleValue; }

   //! start the timer
   virtual tDiaResult start ( void );
   //! check if the timer is running
   bool isRunning ( void ) const;

   //! add a timer client
   virtual tDiaResult addTimerClient ( dia_SecurityTimerClient* pClient );

   //! internal callback function called by the OSAL timer
   virtual void vOnAlarm ( void );

#ifdef __DIA_UNIT_TESTING__
   virtual tS32 s32Delete ( void ) { return OSAL_OK; }
   virtual tS32 s32Create ( void ) { return OSAL_OK; }
   virtual tS32 s32SetTime(OSAL_tMSecond /*msec*/, OSAL_tMSecond /*interval*/) { return 0; }
#endif

protected:
   //! default constructor
   dia_SecurityTimer ( void );
   //! class destructor
   virtual ~dia_SecurityTimer ( void );

   //! start the timer
   virtual tDiaResult setTime ( tU32 timeout, tU32 cycleValue );
   //! stop the timer
   virtual tDiaResult stop ( void );
   //! remove a timer client
   virtual tDiaResult removeTimerClient ( dia_SecurityTimerClient* pClient );

protected:
   //! flag to indicate if the timer was already set up
   bool mIsSetup;
   //! flag to indicate if the timer is active or not
   bool mIsActive;
   //! configured timeout value
   tU32 mTimeout;
   //! configured cycle time
   tU32 mCycleValue;
   //! list of timer clients
   std::list<dia_SecurityTimerClient*> mClientRep;
};

dia_SecurityTimer* getInstanceOfSecurityTimer ( void );
void releaseInstanceOfSecurityTimer ( void );

#endif /* __INCLUDED_DIA_SECURITY_TIMER__ */
