/*
 * dia_SecurityTimer.cpp
 *
 *  Created on: 10.08.2012
 *      Author: gib2hi
 */


#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY_MANAGER__
#include <common/framework/security/dia_SecurityManager.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY_TIMER__
#include <common/framework/security/dia_SecurityTimer.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY_TIMER_CLIENT__
#include <common/framework/security/dia_SecurityTimerClient.h>
#endif

#define DIA_C_U32_SECURITY_TIMER_DEFAULT_TIMEOUT    ((tU32) 1000) // timeout value in milliseconds
#define DIA_C_U32_SECURITY_TIMER_DEFAULT_CYCLETIME  ((tU32) 1000) // timeout value in milliseconds


DIA_IMPL_SINGLETON_WITH_SETUP_AND_TEARDOWN(dia_SecurityTimer)

#ifndef __DIA_UNIT_TESTING__

dia_SecurityTimer*
getInstanceOfSecurityTimer ( void )
{
   return dia_SecurityTimer::getInstance();
}

void
releaseInstanceOfSecurityTimer ( void )
{
   return dia_SecurityTimer::deleteInstance();
}

#endif

//------------------------------------------------------------------------------

dia_SecurityTimer::dia_SecurityTimer ( void )
   : mIsSetup(false),
     mIsActive(false),
     mTimeout(DIA_C_U32_SECURITY_TIMER_DEFAULT_TIMEOUT),
     mCycleValue(DIA_C_U32_SECURITY_TIMER_DEFAULT_CYCLETIME)
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::dia_SecurityTimer");
}

//------------------------------------------------------------------------------

dia_SecurityTimer::~dia_SecurityTimer ( void )
{
// dia_tclFnctTrace oTrace("dia_SecurityTimer::~dia_SecurityTimer");
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SecurityTimer::setup ( void )
{
   if ( !mIsSetup )
   {
#ifndef __DIA_UNIT_TESTING__
      s32Create();
#endif
      mIsSetup = true;
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

//! shutdown method for the application
tDiaResult
dia_SecurityTimer::tearDown ( void )
{
   if ( mIsSetup )
   {
      stop();
      s32Delete();
      mIsSetup = false;
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
dia_SecurityTimer::setTiming ( tU32 timeout, tU32 cycleValue )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::setTiming(timeout,cycleValue)");

   mTimeout = timeout;
   mCycleValue = cycleValue;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SecurityTimer::setTime ( tU32 timeout, tU32 cycleValue )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::setTime(timeout,cycleValue)");

#ifndef __DIA_UNIT_TESTING__
   return ( s32SetTime(timeout,cycleValue) == OSAL_OK ) ? DIA_SUCCESS : DIA_FAILED;
#else
   DIA_PARAMETER_INTENTIONALLY_UNUSED(timeout);
   DIA_PARAMETER_INTENTIONALLY_UNUSED(cycleValue);
   return DIA_SUCCESS;
#endif
}

//------------------------------------------------------------------------------

tDiaResult
dia_SecurityTimer::start ( void )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::start()");

   if ( mIsActive ) return DIA_SUCCESS;
   if ( mClientRep.empty() ) return DIA_FAILED;

   tDiaResult retCode = setTime(mTimeout,mCycleValue);
   if ( retCode == DIA_SUCCESS )
   {
      mIsActive = true;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SecurityTimer::stop ( void )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::stop()");

   if ( !mIsActive ) return DIA_SUCCESS;

   tDiaResult retCode = setTime(0,0);
   if ( retCode == DIA_SUCCESS )
   {
      mIsActive = false;
   }

   return retCode;
}

//------------------------------------------------------------------------------

bool
dia_SecurityTimer::isRunning ( void ) const
{
   return mIsActive;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SecurityTimer::addTimerClient ( dia_SecurityTimerClient* pClient )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::addTimerClient()");

   if ( !pClient ) return DIA_E_INVALID_POINTER;

   // check if the corresponding object is already registered
   list<dia_SecurityTimerClient*>::iterator iter;
   iter = find(mClientRep.begin(), mClientRep.end(), pClient);
   if ( iter != mClientRep.end() ) return DIA_FAILED;

   mClientRep.push_back(pClient);

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SecurityTimer::removeTimerClient ( dia_SecurityTimerClient* pClient )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::removeTimerClient()");

   if ( !pClient ) return DIA_E_INVALID_POINTER;

   // check if the corresponding object is already registered
   list<dia_SecurityTimerClient*>::iterator iter = find(mClientRep.begin(), mClientRep.end(), pClient);
   if ( iter == mClientRep.end() ) return DIA_E_NOT_FOUND;

   mClientRep.erase(iter);

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
dia_SecurityTimer::vOnAlarm ( void )
{
   dia_tclFnctTrace oTrace("dia_SecurityTimer::vOnAlarm()");

   vector<dia_SecurityTimerClient*> elapsedTimers;

   // iterate through the timer list and record elapsed timers
   list<dia_SecurityTimerClient*>::iterator iter;
   for ( iter=mClientRep.begin(); iter != mClientRep.end(); iter++ )
   {
      DIA_TR_INF( "Calling SecurityTimerClient::Tick()");

      if ( (*iter)->vOnSecurityTimerTick() )
      {
         DIA_TR_INF( "Timer of SecurityTimerClient is elapsed...");
         // add the timer to the list of elapsed timers
         elapsedTimers.push_back(*iter);
      }
   }

   // remove elapsed timers from the client repository
   if ( !elapsedTimers.empty() )
   {
      vector<dia_SecurityTimerClient*>::iterator iter2;
      for ( iter2=elapsedTimers.begin(); iter2 != elapsedTimers.end(); iter2++ )
      {
         DIA_TR_INF( "Removing SecurityTimerClient from repository...");
         (void) removeTimerClient(*iter2);
      }
   }

   // stop the timer if all signal timers are elapsed
   if ( mClientRep.empty() )
   {
      DIA_TR_INF( "SecurityTimerClientRep is empty. Stop the timer !!");
      stop();
   }
}
