/*
 * dia_SecurityModuleTTFIS.cpp
 *
 *  Created on: 30.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SECURITY_MODULE_TTFIS__
#include <common/framework/security/dia_SecurityModuleTTFIS.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DRIVER__
#include <common/framework/platform/dia_IDriver.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include <common/framework/config/dia_ConfigManager.h>
#endif

//-----------------------------------------------------------------------------

dia_SecurityModuleTTFIS::dia_SecurityModuleTTFIS ( dia_IDriver* pDriver )
   : dia_SecurityModule("dia_SecurityModuleTTFIS"),
     mpDriver(pDriver)
{}

//-----------------------------------------------------------------------------

dia_SecurityModuleTTFIS::~dia_SecurityModuleTTFIS ( void )
{
   mpDriver = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SecurityModuleTTFIS::setTraceDriver ( dia_IDriver* pDriver )
{
   tDiaResult retCode = DIA_FAILED;
   if ( pDriver )
   {
      mpDriver = pDriver;
      retCode  = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SecurityModuleTTFIS::lockAccess ( dia_SecurityLockLevelID lockLevelID )
{
   dia_tclFnctTrace trc("dia_SecurityModuleTTFIS::lockAccess()");

   DIA_TR_INF("#######################################################");
   DIA_TR_INF("#");
   DIA_TR_INF("# LOCKING TTFIS ACCESS");
   DIA_TR_INF("#");
   DIA_TR_INF("#######################################################");

   tDiaResult retCode = DIA_FAILED;

   if ( mpDriver )
   {
      if ( lockLevelID == DIA_UID_SECURITY_LOCK_LEVEL_LOCKED )
      {
         // if security is disabled via the HW config string we always return FALSE (master)
         if ( dia_checkPropertyValue(DIA_PROP_CM_CONFIG_INTERFACE_LOCK) == TRUE )
         {
            if ( mpDriver->ioctrl(DIA_C_S32_IOCTRL_TRACE_SET_LOCK_STATUS,TRUE) == DIA_SUCCESS )
            {
               DIA_TR_INF("#######################################################");
               DIA_TR_INF("#");
               DIA_TR_INF("# LOCKED TTFIS ACCESS");
               DIA_TR_INF("#");
               DIA_TR_INF("#######################################################");
               mIsAccessLocked = true;
               retCode = DIA_SUCCESS;
            }
            else
            {
               DIA_TR_INF("#######################################################");
               DIA_TR_INF("#");
               DIA_TR_INF("# LOCKING TTFIS ACCESS FAILED !!!");
               DIA_TR_INF("#");
               DIA_TR_INF("#######################################################");
            }
         }
         else
         {
            DIA_TR_INF("#### SECURITY MANAGEMENT DISABLED VIA CONFIGURATION ####");
            return DIA_SUCCESS;
         }
      }
      else if ( lockLevelID == DIA_UID_SECURITY_LOCK_LEVEL_DISABLED )
      {
         if ( mpDriver->ioctrl(DIA_C_S32_IOCTRL_TRACE_SET_LOCK_STATUS,FALSE) == DIA_SUCCESS )
         {
            DIA_TR_INF("#######################################################");
            DIA_TR_INF("#");
            DIA_TR_INF("# UNLOCKED TTFIS ACCESS");
            DIA_TR_INF("#");
            DIA_TR_INF("#######################################################");
            mIsAccessLocked = false;
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_INF("#######################################################");
            DIA_TR_INF("#");
            DIA_TR_INF("# UNLOCKING TTFIS ACCESS FAILED !!!");
            DIA_TR_INF("#");
            DIA_TR_INF("#######################################################");
         }
      }
      else
      {
         DIA_TR_INF("# UNKNOWN SECURITY LEVEL 0x%08x !!!",lockLevelID);
      }
   }
   else
   {
      retCode = DIA_E_DRIVER_NOT_AVAILABLE;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SecurityModuleTTFIS::unlockAccess ( void )
{
   dia_tclFnctTrace trc("dia_SecurityModuleTTFIS::unlockAccess()");

   DIA_TR_INF("#######################################################");
   DIA_TR_INF("#");
   DIA_TR_INF("# UNLOCKING TTFIS ACCESS");
   DIA_TR_INF("#");
   DIA_TR_INF("#######################################################");

   return lockAccess(DIA_UID_SECURITY_LOCK_LEVEL_DISABLED);
}

