/*
 * dia_RoutineCtrlTimer.cpp
 *
 *  Created on: 23.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_TIMER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlTimer.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_TIMER_CLIENT__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlTimerClient.h"
#endif

#ifndef __DIA_UNIT_TESTING__

dia_RoutineCtrlTimer*
getInstanceOfRoutineCtrlTimer ( void )
{
   return dia_RoutineCtrlTimer::getInstance();
}

void
releaseInstanceOfRoutineCtrlTimer ( void )
{
   return dia_RoutineCtrlTimer::deleteInstance();
}

#endif

// implementation of the singleton methods
DIA_IMPL_SINGLETON_WITH_SETUP_AND_TEARDOWN(dia_RoutineCtrlTimer)

//------------------------------------------------------------------------------

dia_RoutineCtrlTimer::dia_RoutineCtrlTimer ( void )
   : mIsSetup(false),
     mbIsActive(false)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::dia_RoutineCtrlTimer");
}

//------------------------------------------------------------------------------

dia_RoutineCtrlTimer::~dia_RoutineCtrlTimer ( void )
{
// dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::~dia_RoutineCtrlTimer");
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlTimer::setup ( void )
{
   if ( !mIsSetup )
   {
#ifndef __DIA_UNIT_TESTING__
      s32Create();
#endif
      mIsSetup = true;
   }
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlTimer::tearDown ( void )
{
   if ( mIsSetup )
   {
      stop();
      s32Delete();
      mIsSetup = false;
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tBool
dia_RoutineCtrlTimer::start ( tU32 timeoutValue, tU32 cycleValue )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::start()");

   tBool bRetCode = FALSE;

   if ( !mbIsActive && !mClientRep.empty() )
   {
#ifndef __DIA_UNIT_TESTING__
      if ( s32SetTime(timeoutValue,cycleValue) == OSAL_OK )
#else
      DIA_PARAMETER_INTENTIONALLY_UNUSED(cycleValue);
      DIA_PARAMETER_INTENTIONALLY_UNUSED(timeoutValue);
#endif
      {
         bRetCode   = TRUE;
         mbIsActive = true;
      }
   }

   return bRetCode;
}

//------------------------------------------------------------------------------

tBool
dia_RoutineCtrlTimer::stop ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::stop()");

   tBool bRetCode = FALSE;

   if ( mbIsActive )
   {
#ifndef __DIA_UNIT_TESTING__
      if ( s32SetTime(0,0) == OSAL_OK )
#endif
      {
         bRetCode   = TRUE;
         mbIsActive = false;
      }
   }

   return bRetCode;
}

//------------------------------------------------------------------------------

tBool
dia_RoutineCtrlTimer::bIsRunning ( void ) const
{
   return mbIsActive ? TRUE : FALSE;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlTimer::addTimerClient ( dia_RoutineCtrlTimerClient* pClient )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::addTimerClient()");

   tDiaResult retCode = DIA_FAILED;

   if ( pClient )
   {
      // check if the corresponding object is already registered
      list<dia_RoutineCtrlTimerClient*>::iterator iter;
      iter = find(mClientRep.begin(), mClientRep.end(), pClient);
      if ( iter == mClientRep.end() )
      {
         mClientRep.push_back(pClient);
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlTimer::removeTimerClient ( dia_RoutineCtrlTimerClient* pClient )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::removeTimerClient()");

   tDiaResult retCode = DIA_FAILED;

   if ( pClient )
   {
      // check if the corresponding object is already registered
      list<dia_RoutineCtrlTimerClient*>::iterator iter;
      iter = find(mClientRep.begin(), mClientRep.end(), pClient);
      if ( iter != mClientRep.end() )
      {
         mClientRep.erase(iter);
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_RoutineCtrlTimer::vOnAlarm ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlTimer::vOnAlarm()");

   vector<dia_RoutineCtrlTimerClient*> elapsedTimers;

   // iterate through the timer list and record elapsed timers
   list<dia_RoutineCtrlTimerClient*>::iterator iter;
   for ( iter=mClientRep.begin(); iter != mClientRep.end(); iter++ )
   {
      DIA_TR_INF( "Calling TimerClient::Tick()");

      if ( (*iter)->onTimerTickRoutineCtrl() == DIA_E_TIMEOUT )
      {
         DIA_TR_INF( "Timer of TimerClient is elapsed...");
         // add the timer to the list of elapsed timers
         elapsedTimers.push_back(*iter);
      }
   }

   // remove elapsed timers from the client repository
   if ( !elapsedTimers.empty() )
   {
      vector<dia_RoutineCtrlTimerClient*>::iterator iter2;
      for ( iter2=elapsedTimers.begin(); iter2 != elapsedTimers.end(); iter2++ )
      {
         DIA_TR_INF( "Removing TimerClient from repository...");
         removeTimerClient(*iter2);
      }

      // at least one timer has been elapsed, so we need to update the ioctrl signal states
      dia_RoutineCtrlManager* pMgr = dia_RoutineCtrlManager::getInstance();
      if ( pMgr )
      {
         pMgr->vUpdateRoutineCtrlStatus();
      }
   }

   // stop the timer if all signal timers are elapsed
   if ( mClientRep.empty() )
   {
       DIA_TR_INF( "TimerClientRep is empty. Stop the timer !!");
      stop();
   }
}
