/*
 * dia_RoutineCtrlManager.h
 *
 *  Created on: 09.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#define __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include "common/interfaces/dia_ISessionListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINECONTROL_LISTENER__
#include "common/interfaces/dia_IRoutineControlListener.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINECTRLMANAGERFSM__
#include "common/framework/fsm/generated/dia_RoutineCtrlManagerFSM.h"
#endif

class dia_RoutineCtrlTimer;

class dia_Routine;
class dia_IRoutineControlListener;

class dia_RoutineCtrlManager
   : protected dia_RoutineCtrlManagerFSM::FsmBehaviour,
     public dia_ISessionListenerImpl,
     public dia_IRoutineControl
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlManager);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlManager);

public:
   //! setup method used to allocate memory on the heap etc.
   virtual tDiaResult setup ( void );
   //! teardown method used for cleanup tasks like releasing memory from heap
   virtual tDiaResult tearDown ( void );
   //! setup shall only performed once
   virtual bool isSetup ( void ) const { return mIsSetup; }

   //! install a signal handler
   tDiaResult addRoutine ( dia_Routine* pRoutine );
   //! install a signal handler
   tDiaResult removeRoutine ( dia_UID uid );
   //! return the number of signals in the signal repository
   tU16 numberOfRoutines ( void ) const;

   //! update the RoutineCtrl status
   virtual void vUpdateRoutineCtrlStatus ( void );
   //!
   dia_eRoutineStatus getRoutineControlStatus ( void );

   //! check if the result of the specified signal is available
   tBool bIsResultReady ( dia_UID uID/* dia_eRoutineID ID*/ );
   //! check if the result of the specified signal is available
   bool isResultReady ( dia_UID uID/* dia_eRoutineID ID*/ );

   const std::map<dia_UID,dia_Routine*>& getRoutines ( void ) const;

   //
   // Methods defined in dia_IRoutineControl interface
   //

   //! start the specified routine
   virtual tDiaResult startRoutine ( dia_UID uid, std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE );  //lint !e1735 Info: verified that same default parameter is used as in base class
   //! stop the specified routine
   virtual tDiaResult stopRoutine ( dia_UID uid, std::vector<tU8>& params );
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestRoutineResult ( dia_UID uID/* dia_eRoutineID ID*/, std::vector<tU8>& results );
   //! query for a certain routine
   virtual tDiaResult queryRoutine ( dia_UID uID/* dia_eRoutineID id*/, dia_Routine** ppRoutine );
   //! query for a certain routine
   virtual tDiaResult queryRoutineByDID ( tU16 did, dia_Routine** ppRoutine );
   //! query for a certain routine
   virtual tDiaResult onRoutineTimeout ( dia_UID uID/* dia_eRoutineID id*/ );

   //
   // Methods defined in SessionListener interface
   //

   virtual tDiaResult configureSessionHandling ( tU8 currentSession, tU8 nextSession, bool stopMode = true );
   virtual tDiaResult configureSessionHandling ( tU8 currentSession, bool stopMode = true );

   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );

   //! method used by routine objects to inform about an update
   virtual void vOnRoutineUpdate ( dia_Routine& routine );

   //! add a listener for the signal with the given UID
   virtual tDiaResult addRoutineControlListener ( dia_UID uid, dia_IRoutineControlListener* pListener );
   //! remove a listener
   virtual tDiaResult removeRoutineControlListener ( dia_UID uid, dia_IRoutineControlListener* pListener );

protected:
    //! default class constructor
   dia_RoutineCtrlManager ( void );
    //! class destructor
    virtual ~dia_RoutineCtrlManager ( void );

    virtual void vFsmAddRoutine ( void* pArg );
    virtual void vFsmCollectRoutines ( void* pArg );
    virtual void vFsmHandleTimeout ( void* pArg );
    virtual void vFsmRemoveRoutine ( void* pArg );
    virtual void vFsmReset ( void* pArg );
    virtual void vFsmStopNextRoutine ( void* pArg );

    // FSM guards
    virtual bool bFsmIsNoRoutineActive ( void* pArg );

protected:
   //! status of the routines (e.g. used in generic measurement value)
   dia_eRoutineStatus mRoutineCtrlStatus;

   //! pointer to the FSM object
   dia_RoutineCtrlManagerFSM::Fsm* mpFSM;

   //! flag to indicate whether setup() was already called
   bool mIsSetup;

   //! repository of routines controlled by this manager class
   std::map<dia_UID /*dia_eRoutineID */,dia_Routine*> mRoutineRep;
   std::map<dia_UID /*dia_eRoutineID */,dia_Routine*>::iterator mRoutineRepIter;
   std::map<dia_UID /*dia_eRoutineID */,dia_Routine*>::const_iterator mRoutineRepCIter;

   //! timer used for short term adjustment of signals
   dia_RoutineCtrlTimer* mpTimer;

   //
//   std::vector<dia_UID /*dia_eRoutineID*/> mActiveRoutines;
   std::map<dia_UID,dia_Routine*> mActiveRoutines;
   std::map<dia_UID,dia_Routine*>::iterator mActiveRoutineIter;
   std::map<tU16,bool> mSessionHandlingRep;

   tBool mIsResultReady;

   //! map of listeners
   std::map<dia_UID,dia_IRoutineControlListener*> mListenerRep;
};

dia_RoutineCtrlManager* getInstanceOfRoutineControlManager ( void );
void releaseInstanceOfRoutineControlManager ( void );

#endif /* __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__ */
