/*
 * dia_Routine.cpp
 *
 *  Created on: 22.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_TIMER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlTimer.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

dia_Routine::dia_Routine (
      tCString name,
      tU16 udsID, // uds subfunction
      dia_eRoutineID /*routineID */, // unique internal identifier
      dia_eRoutineType routineType, // short-term or long-term
      dia_eRoutineCtrlMonitoringMode monitoringMode
   )
   : mName(name),
     mUdsID(udsID),
     mType(routineType),
     mStatus(DIA_EN_RTCTRL_STATUS_UNKNOWN),
     mTimerMode(monitoringMode),
     mTimerValue(0),
     mTimerCounter(DIA_C_U16_RTCTRL_TIMER_TIMEOUT_INFINITE),
     mIsResultReady(FALSE)
{
   mUID = dia_getHashCodeFromString(mName);
   DIA_TR_INF( "Routine instantiated: %s UID: %08x", mName, mUID);
}

dia_Routine::dia_Routine (
      tCString name,
      tU16 udsID, // uds subfunction
      dia_eRoutineType routineType, // short-term or long-term
      dia_eRoutineCtrlMonitoringMode monitoringMode
   )
   : mName(name),
     mUdsID(udsID),
     mType(routineType),
     mStatus(DIA_EN_RTCTRL_STATUS_UNKNOWN),
     mTimerMode(monitoringMode),
     mTimerValue(0),
     mTimerCounter(DIA_C_U16_RTCTRL_TIMER_TIMEOUT_INFINITE),
     mIsResultReady(FALSE)
{
   mUID = dia_getHashCodeFromString(mName);
   DIA_TR_INF( "Routine instantiated: %s UID: %08x", mName, mUID);
}

dia_Routine::dia_Routine ( const std::string& name, tU16 udsID, dia_eRoutineType routineType, dia_eRoutineCtrlMonitoringMode monitoringMode )
   : mName(name.c_str()),
     mUdsID(udsID),
     mType(routineType),
     mStatus(DIA_EN_RTCTRL_STATUS_UNKNOWN),
     mTimerMode(monitoringMode),
     mTimerValue(0),
     mTimerCounter(DIA_C_U16_RTCTRL_TIMER_TIMEOUT_INFINITE),
     mIsResultReady(FALSE)
{
   mUID = dia_getHashCodeFromString(mName);
   DIA_TR_INF( "Routine instantiated: %s UID: %08x", mName, mUID);
}

//-----------------------------------------------------------------------------

dia_Routine::~dia_Routine ( void )
{
   mName = 0;
}

//-----------------------------------------------------------------------------

tCString
dia_Routine::getName ( void ) const
{
   return mName;
}

//-----------------------------------------------------------------------------

tU16
dia_Routine::getDID ( void ) const
{
   return mUdsID;
}

//-----------------------------------------------------------------------------

dia_UID
dia_Routine::getUID ( void ) const
{
   return mUID;
}

//-----------------------------------------------------------------------------

dia_eRoutineType
dia_Routine::getType ( void ) const
{
   return mType;
}

//-----------------------------------------------------------------------------

dia_eRoutineStatus
dia_Routine::getStatus ( void ) const
{
   return mStatus;
}

//-----------------------------------------------------------------------------

void
dia_Routine::setStatus ( dia_eRoutineStatus newStatus )
{
   DIA_TR_INF("dia_Routine::setStatus:  %u -> %u", mStatus, newStatus);
   mStatus = newStatus;
}

//-----------------------------------------------------------------------------

dia_eRoutineCtrlMonitoringMode
dia_Routine::getMonitoringMode ( void ) const
{
   return mTimerMode;
}

//-----------------------------------------------------------------------------

void
dia_Routine::setMonitoringMode ( dia_eRoutineCtrlMonitoringMode mode, tU8 timerValue )
{
   mTimerMode  = mode;
   mTimerValue = timerValue;
}

//------------------------------------------------------------------------------

tU8
dia_Routine::getUdsTimerValue ( void ) const
{
   return mTimerValue;
}


//-----------------------------------------------------------------------------

tBool
dia_Routine::bIsResultReady ( void ) const
{
   return mIsResultReady;
}

//-----------------------------------------------------------------------------

uint8_t dia_Routine::mapStatus2UDSResult(void) const
{
   return mapStatus2UDSResult(mStatus);
}

//-----------------------------------------------------------------------------

uint8_t dia_Routine::mapStatus2UDSResult(dia_eRoutineStatus Status)
{
   switch(Status)
   {
      case DIA_EN_RTCTRL_STATUS_UNKNOWN:
         return 0xFF;
      case DIA_EN_RTCTRL_STATUS_IDLE:
         return 0xFF;
      case DIA_EN_RTCTRL_STATUS_IN_PROGRESS:
         return 0x03;
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
         return 0x00;
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         return 0x01;
      case DIA_EN_RTCTRL_STATUS_ABORTED:
         return 0x02;
      case DIA_EN_RTCTRL_STATUS_TIMED_OUT:
         return 0xFF;
      default:
         return 0xFF;
   }
}

//-----------------------------------------------------------------------------

void
dia_Routine::vInitialize ( void )
{
   mResults.clear();
   mIsResultReady = FALSE;
}

//------------------------------------------------------------------------------

tDiaResult
dia_Routine::onTimerTickRoutineCtrl ( void )
{
   dia_tclFnctTrace oTrace("dia_Routine::onTimerTickRoutineCtrl()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( (mTimerCounter > 0) && (mTimerCounter != DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE) )
   {
      mTimerCounter--;
      if ( mTimerCounter == 0 )
      {
         // timer for this signal is elapsed
         vOnRoutineTimeout();
         retCode = DIA_E_TIMEOUT;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_Routine::vSetTimer ( tU16 seconds )
{
   mTimerCounter = seconds;
}

//------------------------------------------------------------------------------

void
dia_Routine::vOnRoutineTimeout ( void )
{
    DIA_TR_INF("dia_Routine::TimerElapsed !!");

    std::vector<tU8> params;

    // notify the HMI to switch off the test screen and update the signal status
    (void) stop(params);
}


