/*
 * dia_IOCtrlSignalRestrictedToRemoteControl.h
 *
 *  Created on: 30.01.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#define __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

//-----------------------------------------------------------------------------

class dia_IOCtrlSignalRestrictedToRemoteControl
   : public dia_IOCtrlSignal
{
public:
   //! class constructor
   dia_IOCtrlSignalRestrictedToRemoteControl (
         tCString name,
         tU16 udsID,
         tU8  ctrlValueSize = DIA_C_U16_IOCTRL_DEFAULT_PAYLOAD_SIZE,
         dia_eIOCtrlMode mode = DIA_EN_IOCTRL_CTRLMODE_ECU,
         dia_eIOCtrlMonitoringMode monitoring = DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED
         );

   //! deprecated class constructor
   dia_IOCtrlSignalRestrictedToRemoteControl (
         tU16 udsID,
         dia_eIOCtrlSignalType type,
         tU8  ctrlValueSize = DIA_C_U16_IOCTRL_DEFAULT_PAYLOAD_SIZE,
         dia_eIOCtrlMode mode = DIA_EN_IOCTRL_CTRLMODE_ECU,
         dia_eIOCtrlMonitoringMode monitoring = DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED
   );

   //! class destructor
   virtual ~dia_IOCtrlSignalRestrictedToRemoteControl ( void );

   //! check if all preconditions for using the iocontrol signal are matched
   virtual tDiaResult checkPreconditions ( void ) const;
   //! check if the signal is currently frozen
   virtual bool isFrozen ( void ) const;

protected:
   //! deprecated default constructor without implementation
   dia_IOCtrlSignalRestrictedToRemoteControl ( void );
};

#endif /* __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__ */
